/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.layouts;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import net.pubnative.sdk.layouts.PNLayoutWaterfall;

public abstract class PNLayout
extends PNLayoutWaterfall {
    private static final String TAG = PNLayout.class.getSimpleName();
    private boolean mIsRunning = false;
    private Handler mHandler = null;
    protected LoadListener mLoadListener;
    protected TrackListener mTrackListener;

    public void load(Context context, String string, String string2) {
        this.load(context, string, string2, this.mLoadListener);
    }

    public void load(Context context, String string, String string2, LoadListener loadListener) {
        if (loadListener == null) {
            Log.w((String)TAG, (String)"load - Error: listener not specified, dropping the call");
        } else if (this.mIsRunning) {
            Log.w((String)TAG, (String)"load - Error: layout already loading, dropping the call");
        } else {
            this.mIsRunning = true;
            this.mLoadListener = loadListener;
            this.initialize(context, string, string2);
        }
    }

    protected Handler getMainHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        return this.mHandler;
    }

    protected void invokeFinish() {
        final LoadListener loadListener = this.mLoadListener;
        this.mLoadListener = null;
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                if (loadListener != null) {
                    PNLayout.this.mIsRunning = false;
                    loadListener.onPNLayoutLoadFinish(PNLayout.this);
                }
            }
        });
    }

    protected void invokeFail(final Exception exception) {
        final LoadListener loadListener = this.mLoadListener;
        this.mLoadListener = null;
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                if (loadListener != null) {
                    PNLayout.this.mIsRunning = false;
                    loadListener.onPNLayoutLoadFail(PNLayout.this, exception);
                }
            }
        });
    }

    protected void invokeImpression() {
        if (this.mInsight != null) {
            this.mInsight.sendImpressionInsight();
        }
        if (this.mTrackListener != null) {
            this.mTrackListener.onPNLayoutTrackImpression(this);
        }
    }

    protected void invokeClick() {
        if (this.mInsight != null) {
            this.mInsight.sendClickInsight();
        }
        if (this.mTrackListener != null) {
            this.mTrackListener.onPNLayoutTrackClick(this);
        }
    }

    public void setLoadListener(LoadListener loadListener) {
        this.mLoadListener = loadListener;
    }

    public void setTrackListener(TrackListener trackListener) {
        this.mTrackListener = trackListener;
    }

    public static interface TrackListener {
        public void onPNLayoutTrackImpression(PNLayout var1);

        public void onPNLayoutTrackClick(PNLayout var1);
    }

    public static interface LoadListener {
        public void onPNLayoutLoadFinish(PNLayout var1);

        public void onPNLayoutLoadFail(PNLayout var1, Exception var2);
    }
}

