/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.layouts;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import net.pubnative.sdk.layouts.PNSmallLayout;
import net.pubnative.sdk.layouts.PNSmallLayoutView;

public class PNBanner
extends PNSmallLayout {
    protected static final String TAG = PNBanner.class.getSimpleName();
    protected WindowManager mWindowManager;
    protected FrameLayout mContainer;
    protected boolean isShown;

    public void show(Position position) {
        if (this.isShown) {
            Log.i((String)TAG, (String)"The banner is already shown, dropping this call");
        } else {
            if (this.mWindowManager == null) {
                this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
            }
            if (this.mContainer == null) {
                this.mContainer = new FrameLayout(this.mContext);
            }
            PNSmallLayoutView pNSmallLayoutView = this.getView(this.mContext);
            this.mContainer.addView((View)pNSmallLayoutView);
            this.startTrackingView();
            this.mWindowManager.addView((View)this.mContainer, (ViewGroup.LayoutParams)this.getWindowManagerParams(position));
            this.isShown = true;
        }
    }

    public void hide() {
        if (this.isShown) {
            this.stopTrackingView();
            this.mContainer.removeAllViews();
            this.mWindowManager.removeView((View)this.mContainer);
            this.isShown = false;
        }
    }

    protected WindowManager.LayoutParams getWindowManagerParams(Position position) {
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.width = -2;
        layoutParams.height = -2;
        layoutParams.flags = 262152;
        layoutParams.format = -3;
        switch (position) {
            case TOP: {
                layoutParams.gravity = 49;
                break;
            }
            case BOTTOM: {
                layoutParams.gravity = 81;
            }
        }
        return layoutParams;
    }

    public static enum Position {
        TOP,
        BOTTOM;

    }
}

