/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.config;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.pubnative.core.network.PNHttpRequest;
import net.pubnative.core.utils.PNDeviceUtils;
import net.pubnative.core.utils.PNStringUtils;
import net.pubnative.sdk.core.PNSettings;
import net.pubnative.sdk.core.adapter.request.PubnativeLibraryCPICache;
import net.pubnative.sdk.core.config.model.PNConfigAPIResponseModel;
import net.pubnative.sdk.core.config.model.PNConfigModel;
import net.pubnative.sdk.core.config.model.PNConfigRequestModel;

public class PNConfigManager {
    private static String TAG = PNConfigManager.class.getSimpleName();
    protected static final String SHARED_PREFERENCES_CONFIG = "net.pubnative.mediation";
    protected static final String CONFIG_STRING_KEY = "config";
    protected static final String APP_TOKEN_STRING_KEY = "appToken";
    protected static final String TIMESTAMP_LONG_KEY = "config.timestamp";
    protected static final String REFRESH_LONG_KEY = "refresh";
    protected static List<PNConfigRequestModel> sQueue = null;
    protected static boolean sIdle = true;

    private PNConfigManager() {
    }

    public static synchronized void getConfig(Context context, String string, Listener listener) {
        if (listener == null) {
            Log.e((String)TAG, (String)"getConfig - Error: listener is null, dropping this call");
        } else if (context == null) {
            Log.e((String)TAG, (String)"getConfig - Error: context is null");
            PNConfigManager.invokeLoaded(null, listener);
        } else if (TextUtils.isEmpty((CharSequence)string)) {
            Log.e((String)TAG, (String)"getConfig - Error: app token is null");
            PNConfigManager.invokeLoaded(null, listener);
        } else {
            PNConfigRequestModel pNConfigRequestModel = new PNConfigRequestModel();
            pNConfigRequestModel.context = context;
            pNConfigRequestModel.appToken = string;
            pNConfigRequestModel.listener = listener;
            PNConfigManager.enqueueRequest(pNConfigRequestModel);
            PNConfigManager.doNextConfigRequest();
        }
    }

    public static void clean(Context context) {
        PNConfigManager.setStoredAppToken(context, null);
        PNConfigManager.setStoredTimestamp(context, null);
        PNConfigManager.setStoredRefresh(context, null);
        PNConfigManager.setStoredConfig(context, null);
    }

    protected static void doNextConfigRequest() {
        PNConfigRequestModel pNConfigRequestModel;
        if (sIdle && (pNConfigRequestModel = PNConfigManager.dequeueRequest()) != null) {
            sIdle = false;
            if (PNSettings.os == null) {
                PNSettings.init(pNConfigRequestModel.context, new PNSettings.Listener(){

                    @Override
                    public void onInitFinish() {
                        PNConfigManager.getNextConfig(pNConfigRequestModel);
                    }
                });
            } else {
                PNConfigManager.getNextConfig(pNConfigRequestModel);
            }
        }
    }

    protected static void getNextConfig(final PNConfigRequestModel pNConfigRequestModel) {
        if (PNConfigManager.configNeedsUpdate(pNConfigRequestModel)) {
            PNSettings.init(pNConfigRequestModel.context, new PNSettings.Listener(){

                @Override
                public void onInitFinish() {
                    PNConfigManager.downloadConfig(pNConfigRequestModel);
                }
            });
        } else {
            PNConfigManager.serveStoredConfig(pNConfigRequestModel);
        }
    }

    protected static void serveStoredConfig(final PNConfigRequestModel pNConfigRequestModel) {
        String string = PNConfigManager.getStoredAppToken(pNConfigRequestModel.context);
        if (string != null && string.equals(pNConfigRequestModel.appToken)) {
            final PNConfigModel pNConfigModel = PNConfigManager.getStoredConfig(pNConfigRequestModel.context);
            PubnativeLibraryCPICache.init(pNConfigRequestModel.context, pNConfigRequestModel.appToken, pNConfigModel, new PubnativeLibraryCPICache.Listener(){

                @Override
                public void onPubnativeCpiCacheLoadFinish() {
                    PNConfigManager.invokeLoaded(pNConfigModel, pNConfigRequestModel.listener);
                }
            });
        } else {
            PNConfigManager.invokeLoaded(null, pNConfigRequestModel.listener);
        }
    }

    protected static PNConfigModel getStoredConfig(Context context) {
        PNConfigModel pNConfigModel = null;
        String string = PNConfigManager.getStoredConfigString(context);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                pNConfigModel = PNStringUtils.convertStringToObject(string, PNConfigModel.class);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)("getStoredConfig - Error: " + exception));
            }
        }
        if (pNConfigModel == null || pNConfigModel.isEmpty()) {
            pNConfigModel = null;
        }
        return pNConfigModel;
    }

    protected static void updateConfig(Context context, String string, PNConfigModel pNConfigModel) {
        if (context != null) {
            if (TextUtils.isEmpty((CharSequence)string) || pNConfigModel == null || pNConfigModel.isEmpty()) {
                PNConfigManager.clean(context);
            } else {
                PNConfigManager.setStoredConfig(context, pNConfigModel);
                PNConfigManager.setStoredAppToken(context, string);
                PNConfigManager.setStoredTimestamp(context, System.currentTimeMillis());
                if (pNConfigModel.globals.containsKey(REFRESH_LONG_KEY)) {
                    Double d = (Double)pNConfigModel.globals.get(REFRESH_LONG_KEY);
                    PNConfigManager.setStoredRefresh(context, d.longValue());
                }
            }
        }
    }

    protected static synchronized void downloadConfig(final PNConfigRequestModel pNConfigRequestModel) {
        PNHttpRequest pNHttpRequest = new PNHttpRequest();
        pNHttpRequest.start(pNConfigRequestModel.context, PNConfigManager.getConfigDownloadUrl(pNConfigRequestModel), new PNHttpRequest.Listener(){

            @Override
            public void onPNHttpRequestFinish(PNHttpRequest pNHttpRequest, String string) {
                PNConfigManager.processConfigDownloadResponse(pNConfigRequestModel, string);
                PNConfigManager.serveStoredConfig(pNConfigRequestModel);
            }

            @Override
            public void onPNHttpRequestFail(PNHttpRequest pNHttpRequest, Exception exception) {
                PNConfigManager.serveStoredConfig(pNConfigRequestModel);
            }
        });
    }

    protected static void processConfigDownloadResponse(PNConfigRequestModel pNConfigRequestModel, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            Log.w((String)TAG, (String)"downloadConfig - Error, empty response");
            PNConfigManager.serveStoredConfig(pNConfigRequestModel);
        } else {
            try {
                PNConfigAPIResponseModel pNConfigAPIResponseModel = (PNConfigAPIResponseModel)new Gson().fromJson(string, PNConfigAPIResponseModel.class);
                if ("ok".equals(pNConfigAPIResponseModel.status)) {
                    PNConfigManager.updateConfig(pNConfigRequestModel.context, pNConfigRequestModel.appToken, pNConfigAPIResponseModel.config);
                } else {
                    Log.w((String)TAG, (String)("downloadConfig - Error: " + pNConfigAPIResponseModel.error_message));
                    PNConfigManager.serveStoredConfig(pNConfigRequestModel);
                }
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)("downloadConfig - Error: " + exception));
                PNConfigManager.serveStoredConfig(pNConfigRequestModel);
            }
        }
    }

    protected static boolean configNeedsUpdate(PNConfigRequestModel pNConfigRequestModel) {
        boolean bl = false;
        String string = PNConfigManager.getStoredConfigString(pNConfigRequestModel.context);
        String string2 = PNConfigManager.getStoredAppToken(pNConfigRequestModel.context);
        Long l = PNConfigManager.getStoredRefresh(pNConfigRequestModel.context);
        Long l2 = PNConfigManager.getStoredTimestamp(pNConfigRequestModel.context);
        Long l3 = System.currentTimeMillis();
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            bl = true;
        } else if (string2 == null || !string2.equals(pNConfigRequestModel.appToken)) {
            bl = true;
        } else if (l == null || l2 == null) {
            bl = true;
        } else if (TimeUnit.MILLISECONDS.toMinutes(l3 - l2) >= l) {
            bl = true;
        }
        return bl;
    }

    protected static void invokeLoaded(PNConfigModel pNConfigModel, Listener listener) {
        sIdle = true;
        if (listener != null) {
            listener.onConfigLoaded(pNConfigModel);
        }
        PNConfigManager.doNextConfigRequest();
    }

    protected static void enqueueRequest(PNConfigRequestModel pNConfigRequestModel) {
        if (pNConfigRequestModel != null) {
            if (sQueue == null) {
                sQueue = new ArrayList<PNConfigRequestModel>();
            }
            sQueue.add(pNConfigRequestModel);
        }
    }

    protected static PNConfigRequestModel dequeueRequest() {
        PNConfigRequestModel pNConfigRequestModel = null;
        if (sQueue != null && sQueue.size() > 0) {
            pNConfigRequestModel = sQueue.remove(0);
        }
        return pNConfigRequestModel;
    }

    protected static String getConfigDownloadBaseUrl(Context context) {
        String string;
        String string2 = "https://ml.pubnative.net/ml/v1/config";
        PNConfigModel pNConfigModel = PNConfigManager.getStoredConfig(context);
        if (pNConfigModel != null && !pNConfigModel.isEmpty() && !TextUtils.isEmpty((CharSequence)(string = (String)pNConfigModel.globals.get("config_url")))) {
            string2 = string;
        }
        return string2;
    }

    protected static String getConfigDownloadUrl(PNConfigRequestModel pNConfigRequestModel) {
        Uri.Builder builder = Uri.parse((String)PNConfigManager.getConfigDownloadBaseUrl(pNConfigRequestModel.context)).buildUpon();
        builder.appendQueryParameter("app_token", pNConfigRequestModel.appToken);
        builder.appendQueryParameter("os_version", PNSettings.osVersion);
        builder.appendQueryParameter("device_name", PNSettings.deviceName);
        String string = null;
        PNDeviceUtils.ConnectionType connectionType = PNDeviceUtils.getConnectionType(pNConfigRequestModel.context);
        switch (connectionType) {
            case CELLULAR: {
                string = "cellular";
                break;
            }
            case WIFI: {
                string = "wifi";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            builder.appendQueryParameter("connection_type", string);
        }
        if (!PNSettings.isCoppaModeEnabled && PNSettings.targeting != null) {
            Map map = PNSettings.targeting.toDictionaryWithIap();
            for (String string2 : map.keySet()) {
                String string3 = (String)map.get(string2);
                builder.appendQueryParameter(string2, string3);
            }
        }
        return builder.build().toString();
    }

    protected static synchronized String getStoredConfigString(Context context) {
        return PNConfigManager.getStringSharedPreference(context, CONFIG_STRING_KEY);
    }

    protected static synchronized void setStoredConfig(Context context, PNConfigModel pNConfigModel) {
        String string = pNConfigModel != null ? new Gson().toJson((Object)pNConfigModel) : null;
        PNConfigManager.setStringSharedPreference(context, CONFIG_STRING_KEY, string);
    }

    protected static String getStoredAppToken(Context context) {
        return PNConfigManager.getStringSharedPreference(context, APP_TOKEN_STRING_KEY);
    }

    protected static void setStoredAppToken(Context context, String string) {
        PNConfigManager.setStringSharedPreference(context, APP_TOKEN_STRING_KEY, string);
    }

    protected static Long getStoredTimestamp(Context context) {
        return PNConfigManager.getLongSharedPreference(context, TIMESTAMP_LONG_KEY);
    }

    protected static void setStoredTimestamp(Context context, Long l) {
        PNConfigManager.setLongSharedPreference(context, TIMESTAMP_LONG_KEY, l);
    }

    protected static Long getStoredRefresh(Context context) {
        return PNConfigManager.getLongSharedPreference(context, REFRESH_LONG_KEY);
    }

    protected static void setStoredRefresh(Context context, Long l) {
        PNConfigManager.setLongSharedPreference(context, REFRESH_LONG_KEY, l);
    }

    protected static String getStringSharedPreference(Context context, String string) {
        SharedPreferences sharedPreferences;
        String string2 = null;
        if (context != null && !TextUtils.isEmpty((CharSequence)string) && (sharedPreferences = PNConfigManager.getSharedPreferences(context)) != null && sharedPreferences.contains(string)) {
            string2 = sharedPreferences.getString(string, null);
        }
        return string2;
    }

    protected static void setStringSharedPreference(Context context, String string, String string2) {
        SharedPreferences.Editor editor = PNConfigManager.getSharedPreferences(context).edit();
        if (context != null && !TextUtils.isEmpty((CharSequence)string) && editor != null) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                editor.remove(string);
            } else {
                editor.putString(string, string2);
            }
            editor.apply();
        }
    }

    protected static Long getLongSharedPreference(Context context, String string) {
        Long l;
        Long l2 = null;
        SharedPreferences sharedPreferences = PNConfigManager.getSharedPreferences(context);
        if (context != null && sharedPreferences.contains(string) && (l = Long.valueOf(sharedPreferences.getLong(string, 0L))) > 0L) {
            l2 = l;
        }
        return l2;
    }

    protected static void setLongSharedPreference(Context context, String string, Long l) {
        SharedPreferences.Editor editor;
        if (context != null && !TextUtils.isEmpty((CharSequence)string) && (editor = PNConfigManager.getSharedPreferences(context).edit()) != null) {
            if (l == null) {
                editor.remove(string);
            } else {
                editor.putLong(string, l.longValue());
            }
            editor.apply();
        }
    }

    protected static SharedPreferences getSharedPreferences(Context context) {
        SharedPreferences sharedPreferences = null;
        if (context != null) {
            sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_CONFIG, 0);
        }
        return sharedPreferences;
    }

    public static interface Listener {
        public void onConfigLoaded(PNConfigModel var1);
    }
}

