/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.core.view;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import net.pubnative.core.utils.PNBitmapDownloader;
import net.pubnative.sdk.R;

public class PNAPIContentInfoView
extends RelativeLayout
implements View.OnClickListener {
    private static final String TAG = PNAPIContentInfoView.class.getSimpleName();
    private RelativeLayout mContainerView;
    private TextView mContentInfoText;
    private ImageView mContentInfoIcon;
    private Handler mHandler;
    private Runnable mCloseTask = new Runnable(){

        @Override
        public void run() {
            PNAPIContentInfoView.this.closeLayout();
        }
    };

    public PNAPIContentInfoView(Context context) {
        super(context);
        this.init(context);
    }

    public PNAPIContentInfoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public PNAPIContentInfoView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    public void init(Context context) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mContainerView = (RelativeLayout)layoutInflater.inflate(R.layout.content_info_layout, (ViewGroup)this, true);
        this.mContentInfoIcon = (ImageView)this.mContainerView.findViewById(R.id.ic_context_icon);
        this.mContentInfoText = (TextView)this.mContainerView.findViewById(R.id.tv_context_text);
    }

    public void openLayout() {
        this.mContentInfoText.setVisibility(0);
        this.mHandler.postDelayed(this.mCloseTask, 3000L);
    }

    public void closeLayout() {
        this.mContentInfoText.setVisibility(8);
    }

    public void setIconUrl(String string) {
        new PNBitmapDownloader().download(string, this.mContentInfoIcon.getWidth(), this.mContentInfoIcon.getHeight(), new PNBitmapDownloader.DownloadListener(){

            @Override
            public void onDownloadFinish(String string, Bitmap bitmap) {
                PNAPIContentInfoView.this.mContentInfoIcon.setImageBitmap(bitmap);
            }

            @Override
            public void onDownloadFailed(String string, Exception exception) {
            }
        });
    }

    public void setIconClickUrl(final String string) {
        this.mContentInfoText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setFlags(0x10000000);
                    intent.setData(Uri.parse((String)string));
                    view.getContext().startActivity(intent);
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)"error on click content info text", (Throwable)exception);
                }
            }
        });
    }

    public void setContextText(String string) {
        if (string != null && !string.isEmpty()) {
            this.mContentInfoText.setText((CharSequence)string);
        }
    }

    public void onClick(View view) {
        this.openLayout();
    }
}

