package net.pubnative.sdk.layouts;

import android.content.Context;
import android.graphics.PixelFormat;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;

import net.pubnative.sdk.core.exceptions.PNException;

/**
 * Created by erosgarciaponte on 01.08.17.
 */

public class PNBanner extends PNSmallLayout {

    protected static final String TAG = PNBanner.class.getSimpleName();

    public enum Position {
        TOP,
        BOTTOM
    }

    protected WindowManager     mWindowManager;
    protected FrameLayout       mContainer;
    protected boolean           isShown;

    public void show(Position position) {
        if (isShown) {
            Log.i(TAG, "The banner is already shown, dropping this call");
        } else {
            if (mWindowManager == null) {
                mWindowManager = (WindowManager) mContext.getSystemService(Context.WINDOW_SERVICE);
            }

            if (mContainer == null) {
                mContainer = new FrameLayout(mContext);
            }

            View adView = getView(mContext);
            mContainer.addView(adView);
            startTrackingView();

            mWindowManager.addView(mContainer, getWindowManagerParams(position));

            isShown = true;
        }
    }

    public void hide() {
        if (isShown) {
            stopTrackingView();
            mContainer.removeAllViews();
            mWindowManager.removeView(mContainer);
            isShown = false;
        }
    }

    protected WindowManager.LayoutParams getWindowManagerParams(Position position) {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.width = WindowManager.LayoutParams.WRAP_CONTENT;
        params.height = WindowManager.LayoutParams.WRAP_CONTENT;
        params.flags = WindowManager.LayoutParams.FLAG_WATCH_OUTSIDE_TOUCH | WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE;
        params.format = PixelFormat.TRANSLUCENT;

        switch (position) {
            case TOP:
                params.gravity = Gravity.TOP | Gravity.CENTER_HORIZONTAL;
                break;
            case BOTTOM:
                params.gravity = Gravity.BOTTOM | Gravity.CENTER_HORIZONTAL;
                break;
        }
        return params;
    }
}
