package net.pubnative.api.core.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;

import net.pubnative.sdk.R;

public class PNAPILoadingView extends FrameLayout {
    public PNAPILoadingView(Context context) {
        super(context);
        init(context);
    }

    public PNAPILoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public PNAPILoadingView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init(context);
    }

    protected void init(Context context) {
        setBackgroundColor(context.getResources().getColor(R.color.pubnative_loading_background_color));
        ProgressBar progressBar = new ProgressBar(context);
        FrameLayout.LayoutParams params = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        params.gravity = Gravity.CENTER;
        addView(progressBar, params);
    }
}
