/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.network;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.pubnative.api.core.utils.PNAPICrypto;
import net.pubnative.sdk.core.exceptions.PNException;
import net.pubnative.sdk.core.utils.PNDeviceUtils;

public class PNHttpRequest {
    private static final String TAG = PNHttpRequest.class.getSimpleName();
    protected int mTimeoutInMillis = 4000;
    protected String mPOSTString = null;
    protected Listener mListener = null;
    protected Handler mHandler = null;

    public void setTimeout(int n) {
        this.mTimeoutInMillis = n;
    }

    public void setPOSTString(String string) {
        this.mPOSTString = string;
    }

    public void start(Context context, final String string, Listener listener) {
        this.mListener = listener;
        this.mHandler = new Handler(Looper.getMainLooper());
        if (this.mListener == null) {
            Log.w((String)TAG, (String)"Warning: null listener specified, performing request without callbacks");
        }
        if (context == null) {
            this.invokeFail(new IllegalArgumentException("PNAPIHttpRequest - Error: null context provided, dropping call"));
        } else if (TextUtils.isEmpty((CharSequence)string)) {
            this.invokeFail(new IllegalArgumentException("PNAPIHttpRequest - Error: null or empty url, dropping call"));
        } else if (PNDeviceUtils.isNetworkAvailable(context)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    PNHttpRequest.this.doRequest(string);
                }
            }).start();
        } else {
            this.invokeFail(PNException.REQUEST_NO_INTERNET);
        }
    }

    protected void disableConnectionReuseIfNecessary() {
        if (Integer.parseInt(Build.VERSION.SDK) < 8) {
            System.setProperty("http.keepAlive", "false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRequest(String string) {
        block15: {
            HttpURLConnection httpURLConnection = null;
            String string2 = this.mPOSTString;
            try {
                Object object;
                this.disableConnectionReuseIfNecessary();
                URL uRL = new URL(string);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setDoInput(true);
                httpURLConnection.setConnectTimeout(this.mTimeoutInMillis);
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    httpURLConnection.setRequestMethod("GET");
                } else {
                    httpURLConnection.setRequestMethod("POST");
                    httpURLConnection.setUseCaches(false);
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setRequestProperty("Content-Length", Integer.toString(string2.getBytes().length));
                    httpURLConnection.setRequestProperty("Content-MD5", PNAPICrypto.md5(string2));
                    OutputStream outputStream = httpURLConnection.getOutputStream();
                    object = new OutputStreamWriter(outputStream, "UTF-8");
                    ((Writer)object).write(string2);
                    ((OutputStreamWriter)object).flush();
                    ((OutputStreamWriter)object).close();
                }
                httpURLConnection.connect();
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    object = httpURLConnection.getInputStream();
                    try {
                        this.invokeFinish(this.stringFromInputStream((InputStream)object));
                    }
                    catch (PNException pNException) {
                        this.invokeFail(pNException);
                    }
                    break block15;
                }
                object = new HashMap();
                object.put("statusCode", n + "");
                try {
                    object.put("errorString", this.stringFromInputStream(httpURLConnection.getErrorStream()));
                }
                catch (PNException pNException) {
                    object.put("parsingException", pNException.toString());
                }
                this.invokeFail(PNException.extraException((Map)object));
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.invokeFail(new Exception("Not enough memory for making request!", outOfMemoryError));
            }
            catch (Exception exception) {
                this.invokeFail(exception);
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
    }

    protected String stringFromInputStream(InputStream inputStream) {
        String string = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            string = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)("stringFromInputStream - Error:" + iOException));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (string == null) {
                string = byteArrayOutputStream.toString();
            }
            hashMap.put("serverResponse", string);
            hashMap.put("IOException", iOException.toString());
            throw PNException.extraException(hashMap);
        }
        return string;
    }

    protected void invokeFinish(final String string) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (PNHttpRequest.this.mListener != null) {
                    PNHttpRequest.this.mListener.onPNHttpRequestFinish(PNHttpRequest.this, string);
                }
                PNHttpRequest.this.mListener = null;
            }
        });
    }

    protected void invokeFail(final Exception exception) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (PNHttpRequest.this.mListener != null) {
                    PNHttpRequest.this.mListener.onPNHttpRequestFail(PNHttpRequest.this, exception);
                }
                PNHttpRequest.this.mListener = null;
            }
        });
    }

    public static interface Listener {
        public void onPNHttpRequestFinish(PNHttpRequest var1, String var2);

        public void onPNHttpRequestFail(PNHttpRequest var1, Exception var2);
    }
}

