/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.util.Log;
import java.util.concurrent.LinkedBlockingQueue;

public class AdvertisingIdClient {
    private static final String TAG = AdvertisingIdClient.class.getSimpleName();
    protected static Listener sListener;
    protected static Handler sHandler;

    public static void getAdvertisingId(final Context context, Listener listener) {
        if (listener == null) {
            Log.e((String)TAG, (String)"getAdvertisingId - Error: null listener, dropping call");
        } else {
            sHandler = new Handler();
            sListener = listener;
            if (context == null) {
                AdvertisingIdClient.invokeFail(new Exception(TAG + " - Error: context null"));
            } else {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AdvertisingIdClient.getAdvertisingIdInfo(context);
                    }
                }).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getAdvertisingIdInfo(Context context) {
        Log.v((String)TAG, (String)"getAdvertisingIdInfo");
        try {
            PackageManager pm = context.getPackageManager();
            pm.getPackageInfo("com.android.vending", 0);
            Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
            intent.setPackage("com.google.android.gms");
            AdvertisingConnection connection = new AdvertisingConnection();
            try {
                if (context.bindService(intent, (ServiceConnection)connection, 1)) {
                    AdvertisingInterface adInterface = new AdvertisingInterface(connection.getBinder());
                    AdInfo adInfo = new AdInfo(adInterface.getId(), adInterface.isLimitAdTrackingEnabled(true));
                    AdvertisingIdClient.invokeFinish(adInfo);
                }
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)("getAdvertisingIdInfo - Error: " + exception));
                AdvertisingIdClient.invokeFail(exception);
            }
            finally {
                context.unbindService((ServiceConnection)connection);
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("getAdvertisingIdInfo - Error: " + exception));
            AdvertisingIdClient.invokeFail(exception);
        }
    }

    protected static void invokeFinish(final AdInfo adInfo) {
        Log.v((String)TAG, (String)"invokeFinish");
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                if (sListener != null) {
                    sListener.onAdvertisingIdClientFinish(adInfo);
                }
            }
        });
    }

    protected static void invokeFail(final Exception exception) {
        Log.v((String)TAG, (String)("invokeFail: " + exception));
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                if (sListener != null) {
                    sListener.onAdvertisingIdClientFail(exception);
                }
            }
        });
    }

    private static class AdvertisingInterface
    implements IInterface {
        private IBinder binder;

        public AdvertisingInterface(IBinder pBinder) {
            this.binder = pBinder;
        }

        public IBinder asBinder() {
            return this.binder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getId() throws RemoteException {
            String id;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, data, reply, 0);
                reply.readException();
                id = reply.readString();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLimitAdTrackingEnabled(boolean paramBoolean) throws RemoteException {
            boolean limitAdTracking;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(paramBoolean ? 1 : 0);
                this.binder.transact(2, data, reply, 0);
                reply.readException();
                limitAdTracking = 0 != reply.readInt();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return limitAdTracking;
        }
    }

    private static class AdvertisingConnection
    implements ServiceConnection {
        boolean retrieved = false;
        private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue(1);

        private AdvertisingConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.queue.put(service);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        public IBinder getBinder() throws InterruptedException {
            if (this.retrieved) {
                throw new IllegalStateException();
            }
            this.retrieved = true;
            return this.queue.take();
        }
    }

    public static class AdInfo {
        private final String mAdvertisingId;
        private final boolean mLimitAdTrackingEnabled;

        AdInfo(String advertisingId, boolean limitAdTrackingEnabled) {
            this.mAdvertisingId = advertisingId;
            this.mLimitAdTrackingEnabled = limitAdTrackingEnabled;
        }

        public String getId() {
            return this.mAdvertisingId;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.mLimitAdTrackingEnabled;
        }
    }

    public static interface Listener {
        public void onAdvertisingIdClientFinish(AdInfo var1);

        public void onAdvertisingIdClientFail(Exception var1);
    }
}

