/*
 * Decompiled with CFR 0.152.
 */
package net.protyposis.android.spectaculum;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import net.protyposis.android.spectaculum.InputSurfaceHolder;
import net.protyposis.android.spectaculum.SpectaculumView;

public class ImageView
extends SpectaculumView {
    private Bitmap mBitmap;

    public ImageView(Context context) {
        super(context);
        this.init();
    }

    public ImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
    }

    public void onInputSurfaceCreated(InputSurfaceHolder inputSurfaceHolder) {
        this.tryLoadBitmap();
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        this.updateResolution(this.mBitmap.getWidth(), this.mBitmap.getHeight());
        this.tryLoadBitmap();
    }

    private void tryLoadBitmap() {
        if (this.mBitmap != null && this.getInputHolder().getSurface() != null) {
            SurfaceTexture st = this.getInputHolder().getSurfaceTexture();
            Surface s = this.getInputHolder().getSurface();
            st.setDefaultBufferSize(this.mBitmap.getWidth(), this.mBitmap.getHeight());
            Canvas c = s.lockCanvas(null);
            c.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
            s.unlockCanvasAndPost(c);
        }
    }
}

