/*
 * Decompiled with CFR 0.152.
 */
package net.protyposis.android.spectaculum.gles.immersive;

import android.opengl.GLES20;
import net.protyposis.android.spectaculum.gles.GLUtils;
import net.protyposis.android.spectaculum.gles.TextureShaderProgram;

public class EquirectangularSphereShaderProgram
extends TextureShaderProgram {
    protected int mRotationMatrixHandle;
    protected int mModeHandle;

    public EquirectangularSphereShaderProgram() {
        super("fs_equirectangularsphere.glsl");
        this.mRotationMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"rotation");
        GLUtils.checkError((String)"glGetUniformLocation rotation");
        this.mModeHandle = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"mode");
        GLUtils.checkError((String)"glGetUniformLocation mode");
    }

    public void setRotationMatrix(float[] rotationMatrix) {
        this.use();
        GLES20.glUniformMatrix4fv((int)this.mRotationMatrixHandle, (int)1, (boolean)false, (float[])rotationMatrix, (int)0);
    }

    public void setMode(int mode) {
        if (mode < 0 || mode > 2) {
            throw new RuntimeException("mode must be in range [0, 2]");
        }
        this.use();
        GLES20.glUniform1i((int)this.mModeHandle, (int)mode);
    }
}

