/*
 * Decompiled with CFR 0.152.
 */
package net.protyposis.android.spectaculum.effects;

import android.os.Handler;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import net.protyposis.android.spectaculum.LibraryHelper;
import net.protyposis.android.spectaculum.SpectaculumView;
import net.protyposis.android.spectaculum.effects.BooleanParameter;
import net.protyposis.android.spectaculum.effects.ImmersiveEffect;
import net.protyposis.android.spectaculum.effects.Parameter;
import net.protyposis.android.spectaculum.gles.GLUtils;

public class ImmersiveTouchNavigation {
    private static final String TAG = ImmersiveTouchNavigation.class.getSimpleName();
    private SpectaculumView mSpectaculumView;
    private boolean mSpectaculumViewTouchEnabled;
    private GestureDetector mGestureDetector;
    private float mPanX;
    private float mPanY;
    private ImmersiveEffect mEffect;
    private BooleanParameter mParameter;
    private boolean mActive;
    private float[] mRotationMatrix = new float[16];
    private View.OnTouchListener mOnTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            return ImmersiveTouchNavigation.this.mActive && ImmersiveTouchNavigation.this.mGestureDetector.onTouchEvent(event);
        }
    };
    private GestureDetector.SimpleOnGestureListener mOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            ImmersiveTouchNavigation.this.mPanX = ImmersiveTouchNavigation.this.mPanX + distanceX / (float)ImmersiveTouchNavigation.this.mSpectaculumView.getWidth() * 180.0f;
            ImmersiveTouchNavigation.this.mPanY = ImmersiveTouchNavigation.this.mPanY + distanceY / (float)ImmersiveTouchNavigation.this.mSpectaculumView.getHeight() * 180.0f;
            ImmersiveTouchNavigation.this.mPanY = LibraryHelper.clamp((float)ImmersiveTouchNavigation.this.mPanY, (float)-90.0f, (float)90.0f);
            ImmersiveTouchNavigation.this.setRotation(-ImmersiveTouchNavigation.this.mPanY, -ImmersiveTouchNavigation.this.mPanX);
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            ImmersiveTouchNavigation.this.mPanX = 0.0f;
            ImmersiveTouchNavigation.this.mPanY = 0.0f;
            ImmersiveTouchNavigation.this.setRotation(0.0f, 0.0f);
            return true;
        }
    };

    public ImmersiveTouchNavigation(SpectaculumView spectaculumView) {
        this.mSpectaculumView = spectaculumView;
        this.mGestureDetector = new GestureDetector(this.mSpectaculumView.getContext(), (GestureDetector.OnGestureListener)this.mOnGestureListener);
        final Handler h = new Handler();
        this.mParameter = new BooleanParameter("TouchNav", false, new BooleanParameter.Delegate(){

            public void setValue(final Boolean value) {
                h.post(new Runnable(){

                    @Override
                    public void run() {
                        ImmersiveTouchNavigation.this.mActive = value;
                        if (ImmersiveTouchNavigation.this.mActive) {
                            ImmersiveTouchNavigation.this.activate();
                        } else {
                            ImmersiveTouchNavigation.this.deactivate();
                        }
                    }
                });
            }
        });
    }

    public void attachTo(ImmersiveEffect effect) throws RuntimeException {
        if (this.mEffect != null) {
            throw new RuntimeException("Previous effect is still attached, call detach() first");
        }
        this.mEffect = effect;
        this.mEffect.addParameter((Parameter)this.mParameter);
    }

    public void detach() {
        this.mEffect.removeParameter((Parameter)this.mParameter);
        this.mEffect = null;
    }

    public void activate() {
        this.mSpectaculumView.setOnTouchListener(this.mOnTouchListener);
        this.mSpectaculumViewTouchEnabled = this.mSpectaculumView.isTouchEnabled();
        this.mSpectaculumView.setTouchEnabled(true);
        this.mActive = true;
    }

    public void deactivate() {
        this.mSpectaculumView.setOnTouchListener(null);
        this.mSpectaculumView.setTouchEnabled(this.mSpectaculumViewTouchEnabled);
        this.mActive = false;
    }

    private void setRotation(float x, float y) {
        GLUtils.Matrix.setRotateEulerM((float[])this.mRotationMatrix, (int)0, (float)x, (float)y, (float)0.0f);
        this.mEffect.setRotationMatrix(this.mRotationMatrix);
    }
}

