/*
 * Decompiled with CFR 0.152.
 */
package net.protyposis.android.spectaculum.effects;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.util.Log;
import net.protyposis.android.spectaculum.effects.BooleanParameter;
import net.protyposis.android.spectaculum.effects.ImmersiveEffect;
import net.protyposis.android.spectaculum.effects.Parameter;

public class ImmersiveSensorNavigation
implements SensorEventListener {
    private static final String TAG = ImmersiveSensorNavigation.class.getSimpleName();
    private Context mContext;
    private ImmersiveEffect mEffect;
    private BooleanParameter mParameter;
    private SensorManager mSensorManager;
    private Sensor mSensor;
    private boolean mActive;
    private float[] mRotationMatrix = new float[16];
    private float[] mRemappedRotationMatrix = new float[16];

    public ImmersiveSensorNavigation(Context context) throws RuntimeException {
        this.mContext = context;
        this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        this.mSensor = this.mSensorManager.getDefaultSensor(11);
        if (this.mSensor == null) {
            throw new RuntimeException("No rotation sensor available");
        }
        final Handler h = new Handler();
        this.mParameter = new BooleanParameter("SensorNav", false, new BooleanParameter.Delegate(){

            public void setValue(final Boolean value) {
                h.post(new Runnable(){

                    @Override
                    public void run() {
                        ImmersiveSensorNavigation.this.mActive = value;
                        if (ImmersiveSensorNavigation.this.mActive) {
                            ImmersiveSensorNavigation.this.activate();
                        } else {
                            ImmersiveSensorNavigation.this.deactivate();
                        }
                    }
                });
            }
        });
    }

    public void attachTo(ImmersiveEffect effect) throws RuntimeException {
        if (this.mEffect != null) {
            throw new RuntimeException("Previous effect is still attached, call detach() first");
        }
        this.mEffect = effect;
        this.mEffect.addParameter((Parameter)this.mParameter);
    }

    public void detach() {
        this.mEffect.removeParameter((Parameter)this.mParameter);
        this.mEffect = null;
    }

    public void activate() {
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensor, 2);
        this.mActive = true;
    }

    public void deactivate() {
        this.mSensorManager.unregisterListener((SensorEventListener)this);
        this.mActive = false;
    }

    public void onSensorChanged(SensorEvent event) {
        if (this.mEffect != null && this.mActive) {
            SensorManager.getRotationMatrixFromVector((float[])this.mRotationMatrix, (float[])event.values);
            SensorManager.remapCoordinateSystem((float[])this.mRotationMatrix, (int)1, (int)3, (float[])this.mRemappedRotationMatrix);
            this.mEffect.setRotationMatrix(this.mRemappedRotationMatrix);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void debugOutputOrientationInDegree(float[] orientation) {
        double rad2deg = 57.29577951308232;
        float azimuth = (float)((double)orientation[0] * rad2deg);
        float pitch = (float)((double)orientation[1] * rad2deg);
        float roll = (float)((double)orientation[2] * rad2deg);
        Log.d((String)TAG, (String)(azimuth + ", " + pitch + ", " + roll));
    }
}

