/*
 * Decompiled with CFR 0.152.
 */
package net.protyposis.android.spectaculum.effects;

import android.opengl.Matrix;
import net.protyposis.android.spectaculum.effects.EnumParameter;
import net.protyposis.android.spectaculum.effects.FloatParameter;
import net.protyposis.android.spectaculum.effects.Parameter;
import net.protyposis.android.spectaculum.effects.ShaderEffect;
import net.protyposis.android.spectaculum.gles.GLUtils;
import net.protyposis.android.spectaculum.gles.TextureShaderProgram;
import net.protyposis.android.spectaculum.gles.immersive.EquirectangularSphereShaderProgram;

public class ImmersiveEffect
extends ShaderEffect {
    private EquirectangularSphereShaderProgram mShaderProgram;
    private float mRotX = 0.0f;
    private float mRotY = 0.0f;
    private float mRotZ = 0.0f;
    private float[] mRotationMatrix = new float[16];
    private Mode mMode;
    private FloatParameter mParameterRotX;
    private FloatParameter mParameterRotY;
    private FloatParameter mParameterRotZ;
    private EnumParameter<Mode> mParameterMode;
    private Runnable mRotationMatrixUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            ImmersiveEffect.this.mShaderProgram.setRotationMatrix(ImmersiveEffect.this.mRotationMatrix);
        }
    };

    public ImmersiveEffect() {
        Matrix.setIdentityM((float[])this.mRotationMatrix, (int)0);
        this.mMode = Mode.MONO;
    }

    protected TextureShaderProgram initShaderProgram() {
        this.mShaderProgram = new EquirectangularSphereShaderProgram();
        this.updateRotationMatrix();
        this.mShaderProgram.setMode(this.mMode.ordinal());
        this.mParameterRotX = new FloatParameter("RotX", -360.0f, 360.0f, this.mRotX, new FloatParameter.Delegate(){

            public void setValue(Float value) {
                ImmersiveEffect.this.mRotX = value.floatValue();
                ImmersiveEffect.this.updateRotationMatrix();
            }
        }, "Sets the rotation angle around the X-axis in degrees");
        this.mParameterRotY = new FloatParameter("RotY", -360.0f, 360.0f, this.mRotY, new FloatParameter.Delegate(){

            public void setValue(Float value) {
                ImmersiveEffect.this.mRotY = -value.floatValue();
                ImmersiveEffect.this.updateRotationMatrix();
            }
        }, "Sets the rotation angle around the Y-axis in degrees");
        this.mParameterRotZ = new FloatParameter("RotZ", -360.0f, 360.0f, this.mRotZ, new FloatParameter.Delegate(){

            public void setValue(Float value) {
                ImmersiveEffect.this.mRotZ = value.floatValue();
                ImmersiveEffect.this.updateRotationMatrix();
            }
        }, "Sets the rotation angle around the Z-axis in degrees");
        this.mParameterMode = new EnumParameter("Mode", Mode.class, (Enum)this.mMode, (Parameter.Delegate)new Parameter.Delegate<Mode>(){

            public void setValue(Mode value) {
                ImmersiveEffect.this.mMode = value;
                ImmersiveEffect.this.mShaderProgram.setMode(ImmersiveEffect.this.mMode.ordinal());
            }
        }, "Sets the render mode");
        this.addParameter((Parameter)this.mParameterRotX);
        this.addParameter((Parameter)this.mParameterRotY);
        this.addParameter((Parameter)this.mParameterRotZ);
        this.addParameter((Parameter)this.mParameterMode);
        return this.mShaderProgram;
    }

    private void updateRotationMatrix() {
        GLUtils.Matrix.setRotateEulerM((float[])this.mRotationMatrix, (int)0, (float)this.mRotX, (float)this.mRotY, (float)this.mRotZ);
        this.mShaderProgram.setRotationMatrix(this.mRotationMatrix);
    }

    public void setRotationMatrix(float[] R) {
        if (R.length < 16) {
            throw new RuntimeException("4x4 matrix expected");
        }
        System.arraycopy(R, 0, this.mRotationMatrix, 0, 16);
        if (this.isInitialized()) {
            this.getParameterHandler().post(this.mRotationMatrixUpdateRunnable);
            this.fireEffectChanged();
        }
    }

    public void setRotationX(float rotX) {
        if (this.isInitialized()) {
            this.mParameterRotX.setValue(Float.valueOf(rotX));
        } else {
            this.mRotX = rotX;
        }
    }

    public void setRotationY(float rotY) {
        if (this.isInitialized()) {
            this.mParameterRotY.setValue(Float.valueOf(rotY));
        } else {
            this.mRotX = rotY;
        }
    }

    public void setRotationZ(float rotZ) {
        if (this.isInitialized()) {
            this.mParameterRotZ.setValue(Float.valueOf(rotZ));
        } else {
            this.mRotX = rotZ;
        }
    }

    public void setMode(Mode mode) {
        if (this.isInitialized()) {
            this.mParameterMode.setValue((Enum)mode);
        } else {
            this.mMode = mode;
        }
    }

    public static enum Mode {
        MONO,
        STEREO_SBS,
        STEREO_TAB;

    }
}

