/*
 * Decompiled with CFR 0.152.
 */
package net.protyposis.android.spectaculum.effects;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.util.Log;
import net.protyposis.android.spectaculum.effects.BooleanParameter;
import net.protyposis.android.spectaculum.effects.EquirectangularSphereEffect;
import net.protyposis.android.spectaculum.effects.Parameter;

public class SensorRotationNavigation
implements SensorEventListener {
    private static final String TAG = SensorRotationNavigation.class.getSimpleName();
    private Context mContext;
    private EquirectangularSphereEffect mEffect;
    private BooleanParameter mParameter;
    private SensorManager mSensorManager;
    private Sensor mSensor;
    private boolean mActive;
    private float[] mRotationMatrix = new float[16];
    private float[] mRemappedRotationMatrix = new float[16];

    public SensorRotationNavigation(Context context) throws Exception {
        this.mContext = context;
        this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        this.mSensor = this.mSensorManager.getDefaultSensor(11);
        if (this.mSensor == null) {
            throw new Exception("No rotation sensor available");
        }
        final Handler h = new Handler();
        this.mParameter = new BooleanParameter("SensorNav", false, new BooleanParameter.Delegate(){

            public void setValue(final Boolean value) {
                h.post(new Runnable(){

                    @Override
                    public void run() {
                        SensorRotationNavigation.this.mActive = value;
                        if (SensorRotationNavigation.this.mActive) {
                            SensorRotationNavigation.this.activate();
                        } else {
                            SensorRotationNavigation.this.deactivate();
                        }
                    }
                });
            }
        });
    }

    public void attachTo(EquirectangularSphereEffect effect) throws Exception {
        if (this.mEffect != null) {
            throw new Exception("Previous effect is still attached, call detach() first");
        }
        this.mEffect = effect;
        this.mEffect.addParameter((Parameter)this.mParameter);
    }

    public void detach() {
        this.mEffect.removeParameter((Parameter)this.mParameter);
        this.mEffect = null;
    }

    public void activate() {
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensor, 2);
    }

    public void deactivate() {
        this.mSensorManager.unregisterListener((SensorEventListener)this);
    }

    public void onSensorChanged(SensorEvent event) {
        if (this.mEffect != null && this.mActive) {
            SensorManager.getRotationMatrixFromVector((float[])this.mRotationMatrix, (float[])event.values);
            SensorManager.remapCoordinateSystem((float[])this.mRotationMatrix, (int)1, (int)3, (float[])this.mRemappedRotationMatrix);
            this.mEffect.setRotationMatrix(this.mRemappedRotationMatrix);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void debugOutputOrientationInDegree(float[] orientation) {
        double rad2deg = 57.29577951308232;
        float azimuth = (float)((double)orientation[0] * rad2deg);
        float pitch = (float)((double)orientation[1] * rad2deg);
        float roll = (float)((double)orientation[2] * rad2deg);
        Log.d((String)TAG, (String)(azimuth + ", " + pitch + ", " + roll));
    }
}

