/*
 * Decompiled with CFR 0.152.
 */
package net.protyposis.android.spectaculum.effects;

import android.opengl.Matrix;
import net.protyposis.android.spectaculum.effects.EnumParameter;
import net.protyposis.android.spectaculum.effects.FloatParameter;
import net.protyposis.android.spectaculum.effects.Parameter;
import net.protyposis.android.spectaculum.effects.ShaderEffect;
import net.protyposis.android.spectaculum.gles.GLUtils;
import net.protyposis.android.spectaculum.gles.TextureShaderProgram;
import net.protyposis.android.spectaculum.gles.immersive.EquirectangularSphereShaderProgram;

public class EquirectangularSphereEffect
extends ShaderEffect {
    private EquirectangularSphereShaderProgram mShaderProgram;
    private float mRotX;
    private float mRotY;
    private float mRotZ;
    private float[] mRotationMatrix = new float[16];
    private Mode mMode;
    private Runnable mRotationMatrixUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            EquirectangularSphereEffect.this.mShaderProgram.setRotationMatrix(EquirectangularSphereEffect.this.mRotationMatrix);
        }
    };

    protected TextureShaderProgram initShaderProgram() {
        this.mShaderProgram = new EquirectangularSphereShaderProgram();
        this.mRotX = 0.0f;
        this.mRotY = 0.0f;
        this.mRotZ = 0.0f;
        Matrix.setIdentityM((float[])this.mRotationMatrix, (int)0);
        this.mMode = Mode.MONO;
        this.mShaderProgram.setRotationMatrix(this.mRotationMatrix);
        this.addParameter((Parameter)new FloatParameter("RotX", -360.0f, 360.0f, this.mRotX, new FloatParameter.Delegate(){

            public void setValue(Float value) {
                EquirectangularSphereEffect.this.mRotX = value.floatValue();
                EquirectangularSphereEffect.this.updateRotationMatrix();
            }
        }, "Sets the rotation angle around the X-axis in degrees"));
        this.addParameter((Parameter)new FloatParameter("RotY", -360.0f, 360.0f, this.mRotY, new FloatParameter.Delegate(){

            public void setValue(Float value) {
                EquirectangularSphereEffect.this.mRotY = -value.floatValue();
                EquirectangularSphereEffect.this.updateRotationMatrix();
            }
        }, "Sets the rotation angle around the Y-axis in degrees"));
        this.addParameter((Parameter)new FloatParameter("RotZ", -360.0f, 360.0f, this.mRotZ, new FloatParameter.Delegate(){

            public void setValue(Float value) {
                EquirectangularSphereEffect.this.mRotZ = value.floatValue();
                EquirectangularSphereEffect.this.updateRotationMatrix();
            }
        }, "Sets the rotation angle around the Z-axis in degrees"));
        this.addParameter((Parameter)new EnumParameter("VR Mode", Mode.class, (Enum)this.mMode, (Parameter.Delegate)new Parameter.Delegate<Mode>(){

            public void setValue(Mode value) {
                EquirectangularSphereEffect.this.mMode = value;
                EquirectangularSphereEffect.this.mShaderProgram.setMode(EquirectangularSphereEffect.this.mMode.ordinal());
            }
        }, "Sets the VR mode"));
        return this.mShaderProgram;
    }

    private void updateRotationMatrix() {
        GLUtils.Matrix.setRotateEulerM((float[])this.mRotationMatrix, (int)0, (float)this.mRotX, (float)this.mRotY, (float)this.mRotZ);
        this.mShaderProgram.setRotationMatrix(this.mRotationMatrix);
    }

    public void setRotationMatrix(float[] R) {
        if (R.length < 16) {
            throw new RuntimeException("4x4 matrix expected");
        }
        System.arraycopy(R, 0, this.mRotationMatrix, 0, 16);
        this.getParameterHandler().post(this.mRotationMatrixUpdateRunnable);
        this.fireEffectChanged();
    }

    public static enum Mode {
        MONO,
        STEREO_SBS,
        STEREO_TAB;

    }
}

