/*
 * Decompiled with CFR 0.152.
 */
package net.protyposis.android.spectaculum.gles.flowabs;

import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Random;
import net.protyposis.android.spectaculum.gles.GLUtils;
import net.protyposis.android.spectaculum.gles.Texture2D;

public class RandomLuminanceNoiseTexture
extends Texture2D {
    private static final String TAG = RandomLuminanceNoiseTexture.class.getSimpleName();

    private RandomLuminanceNoiseTexture(int internalformat, int format, int width, int height, int type, Buffer pixels) {
        super(internalformat, format, width, height, type, pixels);
    }

    public static RandomLuminanceNoiseTexture generate(int width, int height) {
        int i;
        int i2;
        int j;
        float[] noise = new float[width * height];
        Random rnd = new Random(1L);
        int w = width;
        int h = height;
        int p = 0;
        for (j = 0; j < h; ++j) {
            for (i2 = 0; i2 < w; ++i2) {
                noise[p++] = 0.5f + 2.0f * (rnd.nextFloat() - 0.5f);
            }
        }
        p = 0;
        for (j = 0; j < h; ++j) {
            noise[p] = (3.0f * noise[p] + noise[p + 1]) / 4.0f;
            ++p;
            for (i2 = 1; i2 < w - 1; ++i2) {
                noise[p] = (noise[p - 1] + 2.0f * noise[p] + noise[p + 1]) / 4.0f;
                ++p;
            }
            noise[p] = (noise[p - 1] + 3.0f * noise[p]) / 4.0f;
            ++p;
        }
        p = 0;
        for (i = 0; i < w; ++i) {
            noise[p] = (3.0f * noise[p] + noise[p + w]) / 4.0f;
            ++p;
        }
        for (j = 1; j < h - 1; ++j) {
            for (i2 = 0; i2 < w; ++i2) {
                noise[p] = (noise[p - w] + 2.0f * noise[p] + noise[p + w]) / 4.0f;
                ++p;
            }
        }
        for (i = 0; i < w; ++i) {
            noise[p] = (noise[p - width] + 3.0f * noise[p]) / 4.0f;
            ++p;
        }
        if (GLUtils.HAS_GLES30 && GLUtils.HAS_GL_OES_texture_half_float) {
            float[] rgbNoise = new float[noise.length * 3];
            for (i2 = 0; i2 < noise.length; ++i2) {
                rgbNoise[i2 * 3 + 0] = noise[i2];
                rgbNoise[i2 * 3 + 1] = noise[i2];
                rgbNoise[i2 * 3 + 2] = noise[i2];
            }
            FloatBuffer pixels = ByteBuffer.allocateDirect(rgbNoise.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer().put(rgbNoise);
            pixels.rewind();
            return new RandomLuminanceNoiseTexture(34843, 6407, width, height, 5126, pixels);
        }
        Log.i((String)TAG, (String)"Texture fallback mode to GLES20 8 bit");
        byte[] byteNoise = new byte[width * height];
        for (i2 = 0; i2 < noise.length; ++i2) {
            byteNoise[i2] = (byte)(noise[i2] * 255.0f);
        }
        ByteBuffer pixels = ByteBuffer.allocateDirect(byteNoise.length).put(byteNoise);
        pixels.rewind();
        return new RandomLuminanceNoiseTexture(6409, 6409, width, height, 5121, pixels);
    }
}

