/*
 * Decompiled with CFR 0.152.
 */
package net.protyposis.android.spectaculum.gles.flowabs;

import net.protyposis.android.spectaculum.gles.Framebuffer;
import net.protyposis.android.spectaculum.gles.Texture2D;
import net.protyposis.android.spectaculum.gles.TextureShaderProgram;
import net.protyposis.android.spectaculum.gles.TexturedRectangle;
import net.protyposis.android.spectaculum.gles.flowabs.ColorQuantizationShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.DOGShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.FDOG0ShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.FDOG1ShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.FlowabsShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.GaussShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.LAB2RGBShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.LineIntegralConvolutionShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.MixWithEdgesShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.OrientationAlignedBilateralFilterShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.OverlayShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.RGB2LABShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.RandomLuminanceNoiseTexture;
import net.protyposis.android.spectaculum.gles.flowabs.SmoothedStructureTensorShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.TangentFlowMapShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.TextureGauss3x3ShaderProgram;
import net.protyposis.android.spectaculum.gles.flowabs.TextureGauss5x5ShaderProgram;

public class FlowAbs {
    private Framebuffer mFramebuffer1;
    private Framebuffer mFramebuffer2;
    private Framebuffer mFramebuffer3;
    private Framebuffer mFramebuffer4;
    private Framebuffer mFramebuffer5;
    private Framebuffer mFramebuffer6;
    private Framebuffer mFramebuffer7;
    private Framebuffer mFramebuffer8;
    private RandomLuminanceNoiseTexture mNoiseTexture;
    private TexturedRectangle mTexturedRectangle = new TexturedRectangle();
    private SmoothedStructureTensorShaderProgram mSstShader;
    private GaussShaderProgram mGaussShader;
    private TextureGauss3x3ShaderProgram mGauss3x3Shader;
    private TextureGauss5x5ShaderProgram mGauss5x5Shader;
    private TangentFlowMapShaderProgram mTfmShader;
    private LineIntegralConvolutionShaderProgram mLicShader;
    private DOGShaderProgram mDogShader;
    private RGB2LABShaderProgram mRgb2LabShader;
    private LAB2RGBShaderProgram mLab2RgbShader;
    private FDOG0ShaderProgram mFdog0Shader;
    private FDOG1ShaderProgram mFdog1Shader;
    private TextureShaderProgram mTextureCopyShader;
    private OrientationAlignedBilateralFilterShaderProgram mBilateralFilterShader;
    private ColorQuantizationShaderProgram mColorQuantizationShader;
    private MixWithEdgesShaderProgram mMixEdgesShader;
    private OverlayShaderProgram mOverlayShader;

    public FlowAbs(int width, int height) {
        this.mTexturedRectangle.reset();
        this.mSstShader = new SmoothedStructureTensorShaderProgram();
        this.mSstShader.setTextureSize(width, height);
        this.mGaussShader = new GaussShaderProgram();
        this.mGaussShader.setTextureSize(width, height);
        this.mGauss3x3Shader = new TextureGauss3x3ShaderProgram();
        this.mGauss3x3Shader.setTextureSize(width, height);
        this.mGauss5x5Shader = new TextureGauss5x5ShaderProgram();
        this.mGauss5x5Shader.setTextureSize(width, height);
        this.mTfmShader = new TangentFlowMapShaderProgram();
        this.mTfmShader.setTextureSize(width, height);
        this.mLicShader = new LineIntegralConvolutionShaderProgram();
        this.mLicShader.setTextureSize(width, height);
        this.mDogShader = new DOGShaderProgram();
        this.mDogShader.setTextureSize(width, height);
        this.mRgb2LabShader = new RGB2LABShaderProgram();
        this.mRgb2LabShader.setTextureSize(width, height);
        this.mLab2RgbShader = new LAB2RGBShaderProgram();
        this.mLab2RgbShader.setTextureSize(width, height);
        this.mFdog0Shader = new FDOG0ShaderProgram();
        this.mFdog0Shader.setTextureSize(width, height);
        this.mFdog1Shader = new FDOG1ShaderProgram();
        this.mFdog1Shader.setTextureSize(width, height);
        this.mTextureCopyShader = new TextureShaderProgram();
        this.mTextureCopyShader.setTextureSize(width, height);
        this.mBilateralFilterShader = new OrientationAlignedBilateralFilterShaderProgram();
        this.mBilateralFilterShader.setTextureSize(width, height);
        this.mColorQuantizationShader = new ColorQuantizationShaderProgram();
        this.mColorQuantizationShader.setTextureSize(width, height);
        this.mMixEdgesShader = new MixWithEdgesShaderProgram();
        this.mMixEdgesShader.setTextureSize(width, height);
        this.mOverlayShader = new OverlayShaderProgram();
        this.mOverlayShader.setTextureSize(width, height);
        this.mFramebuffer1 = new Framebuffer(width, height);
        this.mFramebuffer2 = new Framebuffer(width, height);
        this.mFramebuffer3 = new Framebuffer(width, height);
        this.mFramebuffer4 = new Framebuffer(width, height);
        this.mFramebuffer5 = new Framebuffer(width, height);
        this.mFramebuffer6 = new Framebuffer(width, height);
        this.mFramebuffer7 = new Framebuffer(width, height);
        this.mFramebuffer8 = new Framebuffer(width, height);
        this.mNoiseTexture = RandomLuminanceNoiseTexture.generate(width, height);
    }

    private void copy(Texture2D source, Framebuffer target) {
        target.bind();
        this.mTextureCopyShader.use();
        this.mTextureCopyShader.setTexture(source);
        this.mTexturedRectangle.draw(this.mTextureCopyShader);
    }

    private void tangentFlowMap(Texture2D source, Framebuffer target, Framebuffer tmp1, float sigma) {
        target.bind();
        this.mSstShader.use();
        this.mSstShader.setTexture(source);
        this.mTexturedRectangle.draw((TextureShaderProgram)this.mSstShader);
        tmp1.bind();
        this.mGaussShader.use();
        this.mGaussShader.setTexture(target.getTexture());
        this.mGaussShader.setSigma(sigma);
        this.mTexturedRectangle.draw((TextureShaderProgram)this.mGaussShader);
        target.bind();
        this.mTfmShader.use();
        this.mTfmShader.setTexture(tmp1.getTexture());
        this.mTexturedRectangle.draw((TextureShaderProgram)this.mTfmShader);
    }

    public void tangentFlowMap(Texture2D source, Framebuffer target, float sigma) {
        this.tangentFlowMap(source, this.mFramebuffer1, this.mFramebuffer2, sigma);
        target.bind();
        this.mLicShader.use();
        this.mLicShader.setTexture(this.mNoiseTexture, this.mFramebuffer1.getTexture());
        this.mLicShader.setSigma(5.0f);
        this.mTexturedRectangle.draw((TextureShaderProgram)this.mLicShader);
    }

    public void gauss(Texture2D source, Framebuffer target, float sigma) {
        target.bind();
        this.mGaussShader.use();
        this.mGaussShader.setSigma(sigma);
        this.mGaussShader.setTexture(source);
        this.mTexturedRectangle.draw((TextureShaderProgram)this.mGaussShader);
    }

    private void smoothFilter(Texture2D source, Texture2D tfm, Framebuffer target, int type, float sigma) {
        target.bind();
        if (type == 3) {
            this.mLicShader.use();
            this.mLicShader.setTexture(source, tfm);
            this.mLicShader.setSigma(sigma);
            this.mTexturedRectangle.draw((TextureShaderProgram)this.mLicShader);
        } else {
            FlowabsShaderProgram gauss = type == 1 ? this.mGauss3x3Shader : this.mGauss5x5Shader;
            gauss.use();
            gauss.setTexture(source);
            this.mTexturedRectangle.draw((TextureShaderProgram)gauss);
        }
    }

    public void smoothFilter(Texture2D source, Framebuffer target, int type, float sigma) {
        if (type == 0) {
            this.copy(source, target);
        } else {
            if (type == 3) {
                this.tangentFlowMap(source, this.mFramebuffer1, this.mFramebuffer2, sigma);
            }
            this.smoothFilter(source, this.mFramebuffer1.getTexture(), target, type, sigma);
        }
    }

    public void noiseTexture(Framebuffer target) {
        this.copy(this.mNoiseTexture, target);
    }

    private void bilateralFilter(Texture2D lab, Texture2D tfm, Framebuffer target, int n, float sigmaD, float sigmaR, Framebuffer tmp1) {
        this.mBilateralFilterShader.use();
        this.mBilateralFilterShader.setSigmaD(sigmaD);
        this.mBilateralFilterShader.setSigmaR(sigmaR);
        for (int i = 0; i < n; ++i) {
            tmp1.bind();
            this.mBilateralFilterShader.setTexture(i == 0 ? lab : target.getTexture(), tfm);
            this.mBilateralFilterShader.setPass(0);
            this.mTexturedRectangle.draw((TextureShaderProgram)this.mBilateralFilterShader);
            target.bind();
            this.mBilateralFilterShader.setTexture(tmp1.getTexture(), tfm);
            this.mBilateralFilterShader.setPass(1);
            this.mTexturedRectangle.draw((TextureShaderProgram)this.mBilateralFilterShader);
        }
    }

    public void bilateralFilter(Texture2D source, Framebuffer target, float gaussSigma, int n, float sigmaD, float sigmaR) {
        this.rgb2lab(source, this.mFramebuffer1);
        if (n > 0) {
            this.tangentFlowMap(source, this.mFramebuffer2, this.mFramebuffer3, gaussSigma);
            this.bilateralFilter(this.mFramebuffer1.getTexture(), this.mFramebuffer2.getTexture(), this.mFramebuffer3, n, sigmaD, sigmaR, this.mFramebuffer4);
            this.lab2rgb(this.mFramebuffer3.getTexture(), target);
        } else {
            this.lab2rgb(this.mFramebuffer1.getTexture(), target);
        }
    }

    private void dog(Texture2D source, Framebuffer target, Framebuffer tmp1, int n, float sigmaE, float sigmaR, float tau, float phi) {
        for (int i = 0; i < n; ++i) {
            Texture2D src = source;
            if (i > 0) {
                this.overlay(target.getTexture(), source, tmp1);
                src = tmp1.getTexture();
            }
            target.bind();
            this.mDogShader.use();
            this.mDogShader.setTexture(src);
            this.mDogShader.setSigmaE(sigmaE);
            this.mDogShader.setSigmaR(sigmaR);
            this.mDogShader.setTau(tau);
            this.mDogShader.setPhi(phi);
            this.mTexturedRectangle.draw((TextureShaderProgram)this.mDogShader);
        }
    }

    public void dog(Texture2D source, Framebuffer target, int n, float sigmaE, float sigmaR, float tau, float phi) {
        this.dog(source, target, this.mFramebuffer1, n, sigmaE, sigmaR, tau, phi);
    }

    public void rgb2lab(Texture2D source, Framebuffer target) {
        target.bind();
        this.mRgb2LabShader.use();
        this.mRgb2LabShader.setTexture(source);
        this.mTexturedRectangle.draw((TextureShaderProgram)this.mRgb2LabShader);
    }

    public void lab2rgb(Texture2D source, Framebuffer target) {
        target.bind();
        this.mLab2RgbShader.use();
        this.mLab2RgbShader.setTexture(source);
        this.mTexturedRectangle.draw((TextureShaderProgram)this.mLab2RgbShader);
    }

    private void fdog(Texture2D labOrBfeSource, Texture2D tfm, Framebuffer target, Framebuffer tmp1, Framebuffer tmp2, Framebuffer tmp3, int n, float sigmaE, float sigmaR, float tau, float sigmaM, float phi) {
        for (int i = 0; i < n; ++i) {
            Texture2D src = labOrBfeSource;
            if (i > 0) {
                this.overlay(tmp3.getTexture(), labOrBfeSource, tmp2);
                src = tmp2.getTexture();
            }
            tmp1.bind();
            this.mFdog0Shader.use();
            this.mFdog0Shader.setTexture(src, tfm);
            this.mFdog0Shader.setSigmaE(sigmaE);
            this.mFdog0Shader.setSigmaR(sigmaR);
            this.mFdog0Shader.setTau(tau);
            this.mTexturedRectangle.draw((TextureShaderProgram)this.mFdog0Shader);
            (i == n - 1 ? target : tmp3).bind();
            this.mFdog1Shader.use();
            this.mFdog1Shader.setTexture(tmp1.getTexture(), tfm);
            this.mFdog1Shader.setSigmaM(sigmaM);
            this.mFdog1Shader.setPhi(phi);
            this.mTexturedRectangle.draw((TextureShaderProgram)this.mFdog1Shader);
        }
    }

    public void fdog(Texture2D source, Framebuffer target, float gaussSigma, int n, float sigmaE, float sigmaR, float tau, float sigmaM, float phi) {
        this.rgb2lab(source, this.mFramebuffer1);
        this.tangentFlowMap(source, this.mFramebuffer2, this.mFramebuffer3, gaussSigma);
        this.fdog(this.mFramebuffer1.getTexture(), this.mFramebuffer2.getTexture(), target, this.mFramebuffer3, this.mFramebuffer4, this.mFramebuffer5, n, sigmaE, sigmaR, tau, sigmaM, phi);
    }

    private void colorQuantization(Texture2D source, Framebuffer target, Framebuffer tmp1, int filter, int numBins, float phiQ) {
        (filter > 0 ? tmp1 : target).bind();
        this.mColorQuantizationShader.use();
        this.mColorQuantizationShader.setNumBins(numBins);
        this.mColorQuantizationShader.setPhiQ(phiQ);
        this.mColorQuantizationShader.setTexture(source);
        this.mTexturedRectangle.draw((TextureShaderProgram)this.mColorQuantizationShader);
        if (filter > 0) {
            FlowabsShaderProgram gaussShader = filter == 1 ? this.mGauss3x3Shader : this.mGauss5x5Shader;
            target.bind();
            gaussShader.use();
            gaussShader.setTexture(tmp1.getTexture());
            this.mTexturedRectangle.draw((TextureShaderProgram)gaussShader);
        }
    }

    public void colorQuantization(Texture2D source, Framebuffer target, int filter, int numBins, float phiQ) {
        this.rgb2lab(source, this.mFramebuffer1);
        this.colorQuantization(this.mFramebuffer1.getTexture(), this.mFramebuffer2, this.mFramebuffer3, filter, numBins, phiQ);
        this.lab2rgb(this.mFramebuffer2.getTexture(), target);
    }

    public void mix(Texture2D source, Texture2D edges, Framebuffer target, float[] edgeColor) {
        target.bind();
        this.mMixEdgesShader.use();
        this.mMixEdgesShader.setColor(edgeColor[0], edgeColor[1], edgeColor[2]);
        this.mMixEdgesShader.setTexture(source, edges);
        this.mTexturedRectangle.draw((TextureShaderProgram)this.mMixEdgesShader);
    }

    public void overlay(Texture2D source, Texture2D edges, Framebuffer target) {
        target.bind();
        this.mOverlayShader.use();
        this.mOverlayShader.setTexture(source, edges);
        this.mTexturedRectangle.draw((TextureShaderProgram)this.mOverlayShader);
    }

    public void flowAbs(Texture2D source, Framebuffer target, float sstSigma, int bfNE, int bfNA, float bfSigmaD, float bfSigmaR, int fdogType, int fdogN, float fdogSigmaE, float fdogSigmaR, float fdogSigmaM, float fdogTau, float fdogPhi, int cqFilter, int cqNumBins, float cqPhiQ, float[] edgeColor, int fsType, float fsSigma) {
        this.rgb2lab(source, this.mFramebuffer1);
        this.tangentFlowMap(source, this.mFramebuffer2, this.mFramebuffer3, sstSigma);
        if (bfNE > 0) {
            this.bilateralFilter(this.mFramebuffer1.getTexture(), this.mFramebuffer2.getTexture(), this.mFramebuffer3, bfNE, bfSigmaD, bfSigmaR, this.mFramebuffer4);
        }
        if (bfNA > 0) {
            this.bilateralFilter(this.mFramebuffer1.getTexture(), this.mFramebuffer2.getTexture(), this.mFramebuffer4, bfNE, bfSigmaD, bfSigmaR, this.mFramebuffer5);
        }
        if (fdogType == 0) {
            this.fdog((bfNE > 0 ? this.mFramebuffer3 : this.mFramebuffer1).getTexture(), this.mFramebuffer2.getTexture(), this.mFramebuffer5, this.mFramebuffer6, this.mFramebuffer7, this.mFramebuffer8, fdogN, fdogSigmaE, fdogSigmaR, fdogTau, fdogSigmaM, fdogPhi);
        } else {
            this.dog((bfNE > 0 ? this.mFramebuffer3 : this.mFramebuffer1).getTexture(), this.mFramebuffer5, this.mFramebuffer6, fdogN, fdogSigmaE, fdogSigmaR, fdogTau, fdogPhi);
        }
        this.colorQuantization((bfNA > 0 ? this.mFramebuffer4 : this.mFramebuffer1).getTexture(), this.mFramebuffer3, this.mFramebuffer6, cqFilter, cqNumBins, cqPhiQ);
        this.lab2rgb(this.mFramebuffer3.getTexture(), this.mFramebuffer1);
        this.mix(this.mFramebuffer1.getTexture(), this.mFramebuffer5.getTexture(), this.mFramebuffer3, edgeColor);
        if (fsType == 0) {
            this.copy(this.mFramebuffer3.getTexture(), target);
        } else {
            this.smoothFilter(this.mFramebuffer3.getTexture(), this.mFramebuffer2.getTexture(), target, fsType, fsSigma);
        }
    }
}

