/*
 * Decompiled with CFR 0.152.
 */
package net.protyposis.android.spectaculum;

import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import java.io.IOException;
import java.util.List;
import net.protyposis.android.spectaculum.InputSurfaceHolder;
import net.protyposis.android.spectaculum.SpectaculumView;

public class CameraView
extends SpectaculumView {
    private static final String TAG = CameraView.class.getSimpleName();
    private Camera mCamera;
    private int mCameraId;

    public CameraView(Context context) {
        super(context);
        this.init(context);
    }

    public CameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mCameraId = 0;
        if (!this.checkCameraHardware(context)) {
            Log.w((String)TAG, (String)"no camera present");
        }
    }

    private boolean checkCameraHardware(Context context) {
        if (this.isInEditMode()) {
            return false;
        }
        return context.getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    public void onInputSurfaceCreated(InputSurfaceHolder inputSurfaceHolder) {
        this.startCamera();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.stopCamera();
        super.surfaceDestroyed(holder);
    }

    public void onPause() {
        this.stopCamera();
        super.onPause();
    }

    public void onResume() {
        super.onResume();
    }

    private void startCamera() {
        try {
            if (this.mCamera == null) {
                int height;
                int width;
                int result;
                this.mCamera = Camera.open((int)this.mCameraId);
                List supportedFocusModes = this.mCamera.getParameters().getSupportedFocusModes();
                if (supportedFocusModes != null && supportedFocusModes.contains("continuous-video")) {
                    Camera.Parameters params = this.mCamera.getParameters();
                    params.setFocusMode("continuous-video");
                    this.mCamera.setParameters(params);
                }
                Camera.CameraInfo info = new Camera.CameraInfo();
                Camera.getCameraInfo((int)this.mCameraId, (Camera.CameraInfo)info);
                WindowManager windowManager = (WindowManager)this.getContext().getSystemService("window");
                int rotation = windowManager.getDefaultDisplay().getRotation();
                int degrees = 0;
                switch (rotation) {
                    case 0: {
                        degrees = 0;
                        break;
                    }
                    case 1: {
                        degrees = 90;
                        break;
                    }
                    case 2: {
                        degrees = 180;
                        break;
                    }
                    case 3: {
                        degrees = 270;
                    }
                }
                if (info.facing == 1) {
                    result = (info.orientation + degrees) % 360;
                    result = (360 - result) % 360;
                } else {
                    result = (info.orientation - degrees + 360) % 360;
                }
                this.mCamera.setDisplayOrientation(result);
                this.mCamera.setPreviewTexture(this.getInputHolder().getSurfaceTexture());
                this.mCamera.startPreview();
                if (result == 0 || result == 180) {
                    width = this.mCamera.getParameters().getPreviewSize().width;
                    height = this.mCamera.getParameters().getPreviewSize().height;
                } else {
                    height = this.mCamera.getParameters().getPreviewSize().width;
                    width = this.mCamera.getParameters().getPreviewSize().height;
                }
                this.updateResolution(width, height);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void stopCamera() {
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    public boolean supportsCameraSwitch() {
        return Camera.getNumberOfCameras() > 1;
    }

    public void switchCamera() {
        this.mCameraId = (this.mCameraId + 1) % Camera.getNumberOfCameras();
        this.stopCamera();
        this.startCamera();
    }
}

