/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm.model;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.jenkins.rqm.model.RqmObject;
import net.praqma.jenkins.rqm.model.TestCase;
import net.praqma.jenkins.rqm.model.TestScript;
import net.praqma.jenkins.rqm.model.TestSuite;
import net.praqma.jenkins.rqm.model.exception.ClientCreationException;
import net.praqma.jenkins.rqm.model.exception.LoginException;
import net.praqma.jenkins.rqm.model.exception.RQMObjectParseException;
import net.praqma.jenkins.rqm.model.exception.RequestException;
import net.praqma.jenkins.rqm.request.RQMGetRequest;
import net.praqma.jenkins.rqm.request.RQMHttpClient;
import net.praqma.jenkins.rqm.request.RQMUtilities;
import net.praqma.jenkins.rqm.request.RqmParameterList;
import net.praqma.util.structure.Tuple;
import org.apache.commons.httpclient.NameValuePair;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestPlan
extends RqmObject<TestPlan> {
    private static final String RESOURCE_RQM_NAME = "testplan";
    private static final Logger log = Logger.getLogger(TestPlan.class.getName());
    private String testPlanTitle;
    private SortedSet<TestCase> testCases = new TreeSet<TestCase>();
    private SortedSet<TestSuite> testSuites = new TreeSet<TestSuite>();

    public TestPlan() {
    }

    public TestPlan(String testPlanName) {
        this.testPlanTitle = testPlanName;
        this.testCases = new TreeSet<TestCase>();
        this.testSuites = new TreeSet<TestSuite>();
    }

    @Override
    public HashMap<String, String> attributes() {
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("testplan_title", this.testPlanTitle);
        return attr;
    }

    @Override
    public TestPlan initializeSingleResource(String xml) throws RQMObjectParseException {
        try {
            Document doc = RqmObject.getDocumentReader(xml);
            NodeList list = doc.getElementsByTagName("ns3:title");
            String title = null;
            for (int i = 0; i < list.getLength(); ++i) {
                Node elem = list.item(i);
                if (elem.getNodeType() != 1) continue;
                title = ((Element)elem).getTextContent();
                this.setTestPlanTitle(title);
            }
            NodeList nlistForTestCases = doc.getElementsByTagName("testcase");
            for (int i = 0; i < nlistForTestCases.getLength(); ++i) {
                TestCase tc = new TestCase();
                Node elem = nlistForTestCases.item(i);
                if (elem.getNodeType() == 1) {
                    Element elm = (Element)elem;
                    tc.setRqmObjectResourceUrl(elm.getAttribute("href"));
                }
                this.getTestCases().add(tc);
            }
            NodeList nlistForTestSuites = doc.getElementsByTagName("testsuite");
            for (int i = 0; i < nlistForTestSuites.getLength(); ++i) {
                TestSuite suite = new TestSuite(null, null);
                Node elem = nlistForTestSuites.item(i);
                if (elem.getNodeType() == 1) {
                    Element elm = (Element)elem;
                    suite.setRqmObjectResourceUrl(elm.getAttribute("href"));
                }
                this.getTestSuites().add(suite);
            }
            return this;
        }
        catch (RQMObjectParseException ex) {
            throw new RQMObjectParseException("Failed to parse TestPlan object", ex);
        }
        catch (DOMException ex) {
            throw new RQMObjectParseException("DOM Exception, malformed xml?", ex);
        }
    }

    public String getFeedUrlForTestPlans(String host, int port, String context, String project) throws UnsupportedEncodingException {
        String request = String.format("%s:%s/%s/service/com.ibm.rqm.integration.service.IIntegrationService/resources/%s/testplan", host, port, context, URLEncoder.encode(project, "UTF-8"));
        return request;
    }

    public NameValuePair[] getParametersForFeedUrlForTestPlans() {
        NameValuePair[] pairs = new NameValuePair[]{new NameValuePair("fields", String.format("feed/entry/content/testplan[title='%s']/*", this.getTestPlanTitle()))};
        return pairs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(RqmObject.getDescriptor(this, this.getTestPlanTitle()));
        builder.append(String.format(" %s testsuite(s)%n %s testcase(s)", this.getTestSuites().size(), this.getTestCases().size()));
        builder.append("===Contents===%n");
        for (TestSuite suite : this.getTestSuites()) {
            builder.append(suite);
        }
        return builder.toString();
    }

    public SortedSet<TestCase> getTestCases() {
        return this.testCases;
    }

    public void setTestCases(SortedSet<TestCase> testCases) {
        this.testCases = testCases;
    }

    public Set<TestSuite> getTestSuites() {
        return this.testSuites;
    }

    public void setTestSuites(SortedSet<TestSuite> testSuites) {
        this.testSuites = testSuites;
    }

    public String getTestPlanTitle() {
        return this.testPlanTitle;
    }

    public void setTestPlanTitle(String testPlanTitle) {
        this.testPlanTitle = testPlanTitle;
    }

    @Override
    public List<TestPlan> read(RqmParameterList parameters) throws IOException {
        RQMHttpClient client = null;
        try {
            client = RQMUtilities.createClient(parameters.hostName, parameters.port, parameters.contextRoot, parameters.projectName, parameters.userName, parameters.passwd);
        }
        catch (MalformedURLException ex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "read", "Caught MalformedURLException in read throwing IO Exception", ex);
            throw new IOException("RqmMethodInvoker exception", ex);
        }
        catch (ClientCreationException cre) {
            log.logp(Level.SEVERE, this.getClass().getName(), "read", "Caught ClientCreationException in read throwing IO Exception", cre);
            throw new IOException("RqmMethodInvoker exception(ClientCreationException)", cre);
        }
        try {
            Tuple<Integer, String> res = new RQMGetRequest(client, parameters.requestString, parameters.parameterList).executeRequest();
            this.initializeSingleResource((String)res.t2);
            for (TestCase tc : this.getTestCases()) {
                parameters.requestString = tc.getRqmObjectResourceUrl();
                tc.read(parameters);
                for (TestScript ts : tc.getScripts()) {
                    parameters.requestString = ts.getRqmObjectResourceUrl();
                    ts.read(parameters);
                }
            }
            for (TestSuite suites : this.getTestSuites()) {
                parameters.requestString = suites.getRqmObjectResourceUrl();
                suites.read(parameters);
                for (TestCase tc : suites.getTestcases()) {
                    parameters.requestString = tc.getRqmObjectResourceUrl();
                    tc.read(parameters);
                    for (TestScript ts : tc.getScripts()) {
                        parameters.requestString = ts.getRqmObjectResourceUrl();
                        ts.read(parameters);
                    }
                }
            }
            return Arrays.asList(this);
        }
        catch (LoginException loginex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Caught login exception in invoke");
            throw new IOException("RqmMethodInvoker exception(LoginException)", loginex);
        }
        catch (RequestException reqExeception) {
            log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Caught RequestException in invoke");
            throw new IOException("RqmMethodInvoker exception(RequestException)", reqExeception);
        }
        catch (Exception ex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Caught Exception in invoke");
            throw new IOException("RqmMethodInvoker exception(Exception)", ex);
        }
    }

    @Override
    public String getResourceName() {
        return RESOURCE_RQM_NAME;
    }
}

