/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm.model;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.jenkins.rqm.model.RqmObject;
import net.praqma.jenkins.rqm.model.TestCase;
import net.praqma.jenkins.rqm.model.TestPlan;
import net.praqma.jenkins.rqm.model.TestSuite;
import net.praqma.jenkins.rqm.model.TopLevelObject;
import net.praqma.jenkins.rqm.model.exception.ClientCreationException;
import net.praqma.jenkins.rqm.model.exception.LoginException;
import net.praqma.jenkins.rqm.model.exception.RQMObjectParseException;
import net.praqma.jenkins.rqm.model.exception.RequestException;
import net.praqma.jenkins.rqm.request.RQMGetRequest;
import net.praqma.jenkins.rqm.request.RQMHttpClient;
import net.praqma.jenkins.rqm.request.RQMUtilities;
import net.praqma.jenkins.rqm.request.RqmParameterList;
import net.praqma.util.structure.Tuple;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestSuiteExecutionRecord
extends RqmObject<TestSuiteExecutionRecord>
implements TopLevelObject {
    private static final String RESOURCE_RQM_NAME = "suiteexecutionrecord";
    private static final Logger log = Logger.getLogger(TestSuiteExecutionRecord.class.getName());
    private TestSuite testSuite;
    private TestPlan testPlan;
    private String testSuiteExecutionRecordTitle;

    @Override
    public TestSuiteExecutionRecord initializeSingleResource(String xml) throws RQMObjectParseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static String getResourceFeedUrl(String host, int port, String context, String project) throws UnsupportedEncodingException {
        String request = String.format("%s:%s/%s/service/com.ibm.rqm.integration.service.IIntegrationService/resources/%s/%s", host, port, context, URLEncoder.encode(project, "UTF-8"), RESOURCE_RQM_NAME);
        return request;
    }

    public static NameValuePair[] getFilteringProperties(String host, int port, String context, String choseSuites) {
        String[] choices = choseSuites.split(",");
        String joined = "";
        for (String choice : choices) {
            if (StringUtils.isBlank((String)choice)) continue;
            joined = joined + String.format(" or title='%s'", choice);
        }
        joined = joined.substring(4, joined.length());
        String selectionString = choseSuites.length() == 1 ? String.format("title='%s'", choices[0]) : joined;
        NameValuePair nvp = new NameValuePair("fields", String.format("feed/entry/content/suiteexecutionrecord[%s]/*", selectionString));
        return new NameValuePair[]{nvp};
    }

    @Override
    public List<TestSuiteExecutionRecord> readMultiple(RqmParameterList parameters) throws IOException {
        ArrayList<TestSuiteExecutionRecord> tsers = new ArrayList<TestSuiteExecutionRecord>();
        RQMHttpClient client = null;
        try {
            client = RQMUtilities.createClient(parameters.hostName, parameters.port, parameters.contextRoot, parameters.projectName, parameters.userName, parameters.passwd);
        }
        catch (MalformedURLException ex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "read", "Caught MalformedURLException in read throwing IO Exception", ex);
            throw new IOException("RqmMethodInvoker exception", ex);
        }
        catch (ClientCreationException cre) {
            log.logp(Level.SEVERE, this.getClass().getName(), "read", "Caught ClientCreationException in read throwing IO Exception", cre);
            throw new IOException("RqmMethodInvoker exception(ClientCreationException)", cre);
        }
        try {
            Tuple<Integer, String> res = new RQMGetRequest(client, parameters.requestString, parameters.parameterList).executeRequest();
            Document doc = RqmObject.getDocumentReader((String)res.t2);
            NodeList n = doc.getElementsByTagName("ns4:suiteexecutionrecord");
            log.fine(String.format("Found %s test suite execution records", n.getLength()));
            for (int i = 0; i < n.getLength(); ++i) {
                TestSuiteExecutionRecord record = new TestSuiteExecutionRecord();
                Node nl = n.item(i);
                if (nl.getNodeType() == 1) {
                    Element suiteElement = (Element)nl;
                    String testSuiteExecutionRecordHref = suiteElement.getElementsByTagName("ns6:identifier").item(0).getTextContent();
                    String tserTitle = suiteElement.getElementsByTagName("ns6:title").item(0).getTextContent();
                    String testPlanHref = ((Element)suiteElement.getElementsByTagName("ns4:testplan").item(0)).getAttribute("href");
                    String testSuiteHref = ((Element)suiteElement.getElementsByTagName("ns4:testsuite").item(0)).getAttribute("href");
                    record.setRqmObjectResourceUrl(testSuiteExecutionRecordHref);
                    record.setTestSuite(new TestSuite(testSuiteHref).read(parameters).get(0));
                    record.setTestPlan(new TestPlan(testPlanHref).read(parameters).get(0));
                    record.setTestSuiteExecutionRecordTitle(tserTitle);
                }
                tsers.add(record);
            }
        }
        catch (LoginException ex) {
            Logger.getLogger(TestSuiteExecutionRecord.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (RequestException ex) {
            Logger.getLogger(TestSuiteExecutionRecord.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (RQMObjectParseException ex) {
            Logger.getLogger(TestSuiteExecutionRecord.class.getName()).log(Level.SEVERE, null, ex);
        }
        return tsers;
    }

    @Override
    public String getResourceName() {
        return RESOURCE_RQM_NAME;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public void setTestSuite(TestSuite testSuite) {
        this.testSuite = testSuite;
    }

    public TestPlan getTestPlan() {
        return this.testPlan;
    }

    public void setTestPlan(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public String getTestSuiteExecutionRecordTitle() {
        return this.testSuiteExecutionRecordTitle;
    }

    public void setTestSuiteExecutionRecordTitle(String testSuiteExecutionRecordTitle) {
        this.testSuiteExecutionRecordTitle = testSuiteExecutionRecordTitle;
    }

    public SortedSet<TestCase> getAllTestCases() {
        TreeSet<TestCase> testCases = new TreeSet<TestCase>();
        testCases.addAll(this.getTestSuite().getTestcases());
        return testCases;
    }
}

