/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm.model;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.praqma.jenkins.rqm.model.exception.RQMObjectParseException;
import net.praqma.jenkins.rqm.request.RqmParameterList;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class RqmObject<T>
implements Serializable {
    private static final Logger log = Logger.getLogger(RqmObject.class.getName());
    protected String rqmObjectResourceUrl;

    public abstract String getResourceName();

    public static Document getDocumentReader(String xml) throws RQMObjectParseException {
        Document doc = null;
        InputStream is = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            is = new BufferedInputStream(new ByteArrayInputStream(xml.getBytes(Charset.forName("utf8"))));
            doc = builder.parse(is);
            doc.normalize();
            is.close();
        }
        catch (IOException ex) {
            log.logp(Level.SEVERE, RqmObject.class.getName(), "getDocumentReader()", "Error in getDocumentReader", ex);
            throw new RQMObjectParseException(String.format("Failed to parse the following xml:%n%s", xml), ex);
        }
        catch (ParserConfigurationException ex) {
            log.logp(Level.SEVERE, RqmObject.class.getName(), "getDocumentReader()", "Error in getDocumentReader", ex);
            throw new RQMObjectParseException(String.format("Failed to parse the following xml:%n%s", xml), ex);
        }
        catch (SAXException ex) {
            log.logp(Level.SEVERE, RqmObject.class.getName(), "getDocumentReader()", "Error in getDocumentReader", ex);
            throw new RQMObjectParseException(String.format("Failed to parse the following xml:%n%s", xml), ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    log.log(Level.SEVERE, "Failed to close input stream", ex);
                }
            }
        }
        return doc;
    }

    public static Document getDocumentReader(InputStream is) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbFactory.newDocumentBuilder();
        Document doc = builder.parse(new BufferedInputStream(is));
        doc.normalize();
        is.close();
        return doc;
    }

    public abstract T initializeSingleResource(String var1) throws RQMObjectParseException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T intializeSingleResource(InputStream is) throws RQMObjectParseException {
        T t;
        BufferedReader bis = null;
        try {
            String line;
            bis = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = bis.readLine()) != null) {
                sb.append(line);
            }
            t = this.initializeSingleResource(sb.toString());
            if (bis == null) return t;
        }
        catch (IOException ioex) {
            try {
                log.logp(Level.SEVERE, this.getClass().getName(), "intializeSingleResource()", "Failed to stream", ioex);
                throw new RQMObjectParseException(String.format("Failed to parse %s", this.getClass().getSimpleName()), ioex);
            }
            catch (Throwable throwable) {
                if (bis == null) throw throwable;
                try {
                    bis.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RQMObjectParseException(String.format("Unable to close stream %s", this.getClass().getSimpleName()), ex);
                }
            }
        }
        try {
            bis.close();
            return t;
        }
        catch (IOException ex) {
            throw new RQMObjectParseException(String.format("Unable to close stream %s", this.getClass().getSimpleName()), ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RqmObject) {
            RqmObject other = (RqmObject)obj;
            if (other.getRqmObjectResourceUrl() == null || other.getRqmObjectResourceUrl().equals("")) {
                return false;
            }
            if (this.getRqmObjectResourceUrl() == null || this.getRqmObjectResourceUrl().equals("")) {
                return false;
            }
            return this.getRqmObjectResourceUrl().equals(other.getRqmObjectResourceUrl());
        }
        return false;
    }

    public int hashCode() {
        return this.getRqmObjectResourceUrl().hashCode();
    }

    public static String getDescriptor(RqmObject obj) {
        try {
            return String.format("[%s] %s%n", obj.getClass().getSimpleName(), obj.getRqmObjectResourceUrl().split("urn:")[1]);
        }
        catch (Exception ex) {
            log.fine(String.format("The descriptor does not contain an internal url reference%n The resource url is: %s", obj.getRqmObjectResourceUrl()));
            return String.format("[%s] %s%n", obj.getClass().getSimpleName(), obj.getRqmObjectResourceUrl());
        }
    }

    public static String getDescriptor(RqmObject obj, String title) {
        try {
            return String.format("[%s] %s (%s)%n", obj.getClass().getSimpleName(), title, obj.getRqmObjectResourceUrl().split("urn:")[1]);
        }
        catch (Exception ex) {
            log.fine(String.format("The descriptor does not contain an internal url reference%n The resource url is: %s", obj.getRqmObjectResourceUrl()));
            return String.format("[%s] %s%n", obj.getClass().getSimpleName(), title);
        }
    }

    public String getRqmObjectResourceUrl() {
        return this.rqmObjectResourceUrl;
    }

    public void setRqmObjectResourceUrl(String rqmObjectResourceUrl) {
        this.rqmObjectResourceUrl = rqmObjectResourceUrl;
    }

    public int getInternalId() throws RQMObjectParseException {
        try {
            int beginIndex = this.getRqmObjectResourceUrl().lastIndexOf(":");
            int length = this.getRqmObjectResourceUrl().length();
            return Integer.parseInt(this.getRqmObjectResourceUrl().substring(beginIndex + 1, length));
        }
        catch (NumberFormatException ex) {
            throw new RQMObjectParseException(String.format("Failed to extract internal id from resource url: %s", this.getRqmObjectResourceUrl()), ex);
        }
    }

    public List<T> read(RqmParameterList parameters) throws IOException {
        return null;
    }

    public List<T> readMultiple(RqmParameterList parameters) throws IOException {
        return this.read(parameters);
    }

    public List<T> createOrUpdate(RqmParameterList parameters) throws IOException {
        return null;
    }

    public HashMap<String, String> attributes() {
        return new HashMap<String, String>();
    }

    public static <T extends RqmObject> T createObject(Class<T> clazz, RqmParameterList parameters) throws InstantiationException, IllegalAccessException, IOException {
        RqmObject t = (RqmObject)clazz.newInstance();
        t.read(parameters);
        return (T)t;
    }
}

