/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm.request;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import net.praqma.jenkins.rqm.model.exception.ClientCreationException;
import net.praqma.jenkins.rqm.request.RQMHttpClient;

public class RQMUtilities {
    private static final String SERVICE = "/service/com.ibm.rqm.integration.service.IIntegrationService";
    private static final String RESOURCES = "/resources/";
    private static RQMHttpClient client;

    public static String getSingleResourceBaseUrl(String qmServerURL, String projectAlias, String resourceType) throws UnsupportedEncodingException {
        return String.format("%s%s%s%s%s", qmServerURL, SERVICE, RESOURCES, URLEncoder.encode(projectAlias, "UTF-8"), "/" + resourceType + "/");
    }

    public static String getSingleResourceBaseUrlWithId(String contextRoot, String hostName, int port, String projectAlias, String resourceType, String externalId) throws UnsupportedEncodingException {
        return String.format("%s%s%s%s%s", RQMUtilities.getServerUrl(contextRoot, hostName, port), SERVICE, RESOURCES, URLEncoder.encode(projectAlias, "UTF-8"), "/" + resourceType + "/" + externalId);
    }

    public static String getServerUrl(String context, String host, int port) {
        return String.format("%s:%s/%s", host, port, context);
    }

    public static String getSingleFeedUrl(String qmServerURL, String projectAlias, String resourceType) {
        return qmServerURL + SERVICE + RESOURCES + projectAlias + "/" + resourceType;
    }

    public static RQMHttpClient createClient(String host, int port, String contextRoot, String project, String user, String password) throws MalformedURLException, ClientCreationException {
        if (client == null) {
            client = new RQMHttpClient(host, port, contextRoot, project, user, password);
        }
        return client;
    }
}

