/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm.request;

import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class RQMSSLContext {
    private static final Logger log = Logger.getLogger(RQMSSLContext.class.getSimpleName());
    public static final String SSL_TLS = "SSL_TLS";
    public static final String SSLV3 = "SSLv3";
    public static final String TLS = "TLS";
    public static final String SSL = "SSL";

    public static SSLContext createSSLContext(TrustManager trustManager) {
        SSLContext context = RQMSSLContext.createSSLContext(SSL_TLS, trustManager);
        if (context == null) {
            context = RQMSSLContext.createSSLContext(SSLV3, trustManager);
        }
        if (context == null) {
            context = RQMSSLContext.createSSLContext(TLS, trustManager);
        }
        if (context == null) {
            context = RQMSSLContext.createSSLContext(SSL, trustManager);
        }
        if (context == null) {
            throw new RuntimeException("No acceptable encryption algorithm found");
        }
        return context;
    }

    private static SSLContext createSSLContext(String algorithm, TrustManager trustManager) {
        SSLContext context;
        try {
            context = SSLContext.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        try {
            context.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException e) {
            return null;
        }
        try {
            Socket s = context.getSocketFactory().createSocket();
            s.close();
        }
        catch (IOException e) {
            log.finest("Socket failure " + e.getMessage());
            return null;
        }
        catch (IllegalArgumentException e) {
            log.finest("Socket failure " + e.getMessage());
            return null;
        }
        return context;
    }
}

