/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm.model;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.jenkins.rqm.model.RqmObject;
import net.praqma.jenkins.rqm.model.TestCase;
import net.praqma.jenkins.rqm.model.TestScript;
import net.praqma.jenkins.rqm.model.TestSuiteExecutionRecord;
import net.praqma.jenkins.rqm.model.exception.ClientCreationException;
import net.praqma.jenkins.rqm.model.exception.LoginException;
import net.praqma.jenkins.rqm.model.exception.RQMObjectParseException;
import net.praqma.jenkins.rqm.model.exception.RequestException;
import net.praqma.jenkins.rqm.request.RQMGetRequest;
import net.praqma.jenkins.rqm.request.RQMHttpClient;
import net.praqma.jenkins.rqm.request.RQMUtilities;
import net.praqma.jenkins.rqm.request.RqmParameterList;
import net.praqma.util.structure.Tuple;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestSuite
extends RqmObject<TestSuite> {
    private static final Logger log = Logger.getLogger(TestSuite.class.getName());
    private static final String RESOURCE_RQM_NAME = "testsuite";
    private String testSuiteTitle;
    private Set<TestCase> testcases;
    private Set<TestSuiteExecutionRecord> testSuiteExecutionRecords;

    public TestSuite() {
    }

    public TestSuite(String rqmObjectResourceUrl) {
        this(rqmObjectResourceUrl, null);
    }

    public TestSuite(String rqmObjectResourceUrl, String suiteName) {
        this.testcases = new HashSet<TestCase>();
        this.testSuiteTitle = suiteName;
        this.rqmObjectResourceUrl = rqmObjectResourceUrl;
    }

    @Override
    public TestSuite initializeSingleResource(String xml) throws RQMObjectParseException {
        try {
            log.fine("Initializing test suite...");
            Document doc = RqmObject.getDocumentReader(xml);
            NodeList list = doc.getElementsByTagName("ns4:testsuite");
            for (int i = 0; i < list.getLength(); ++i) {
                Node elem = list.item(i);
                if (elem.getNodeType() != 1) continue;
                Element el = (Element)elem;
                String title = el.getElementsByTagName("ns6:description").item(0).getTextContent();
                NodeList suiteElements = el.getElementsByTagName("ns4:suiteelement");
                for (int selement = 0; selement < suiteElements.getLength(); ++selement) {
                    if (suiteElements.item(selement).getNodeType() != 1) continue;
                    Element suteElem = (Element)suiteElements.item(selement);
                    String testCaseHref = ((Element)suteElem.getElementsByTagName("ns4:testcase").item(0)).getAttribute("href");
                    TestCase tc = new TestCase(testCaseHref);
                    this.getTestcases().add(tc);
                }
                this.setSuiteTitle(title);
            }
            return this;
        }
        catch (Exception ex) {
            throw new RQMObjectParseException("Failed to initialize TestSuite", ex);
        }
    }

    public Set<TestCase> getTestcases() {
        return this.testcases;
    }

    public void setTestcases(Set<TestCase> testcases) {
        this.testcases = testcases;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(RqmObject.getDescriptor(this, this.getTestSuiteTitle()));
        if (this.getTestcases().size() > 0) {
            builder.append(String.format("Associated test cases:%n", new Object[0]));
            for (TestCase tc : this.getTestcases()) {
                builder.append(tc);
            }
        }
        return builder.toString();
    }

    public String getSuiteTitle() {
        return this.getTestSuiteTitle();
    }

    public void setSuiteTitle(String suiteTitle) {
        this.setTestSuiteTitle(suiteTitle);
    }

    public String getTestSuiteTitle() {
        return this.testSuiteTitle;
    }

    public void setTestSuiteTitle(String testSuiteTitle) {
        this.testSuiteTitle = testSuiteTitle;
    }

    @Override
    public List<TestSuite> read(RqmParameterList parameters) throws IOException {
        RQMHttpClient client = null;
        try {
            client = RQMUtilities.createClient(parameters.hostName, parameters.port, parameters.contextRoot, parameters.projectName, parameters.userName, parameters.passwd);
        }
        catch (MalformedURLException ex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "read", "Caught MalformedURLException in read throwing IO Exception", ex);
            throw new IOException("RqmMethodInvoker exception", ex);
        }
        catch (ClientCreationException cre) {
            log.logp(Level.SEVERE, this.getClass().getName(), "read", "Caught ClientCreationException in read throwing IO Exception", cre);
            throw new IOException("RqmMethodInvoker exception(ClientCreationException)", cre);
        }
        try {
            Tuple<Integer, String> res = new RQMGetRequest(client, this.getRqmObjectResourceUrl(), null).executeRequest();
            log.fine((String)res.t2);
            TestSuite suite = this.initializeSingleResource((String)res.t2);
            for (TestCase tc : suite.getTestcases()) {
                log.fine(String.format("Reading test case %s for suite %s", tc.getRqmObjectResourceUrl(), suite.getTestSuiteTitle()));
                tc.read(parameters);
            }
            for (TestCase tc : suite.getTestcases()) {
                for (TestScript script : tc.getScripts()) {
                    script.read(parameters).get(0);
                }
            }
            log.fine(suite.toString());
            return Arrays.asList(suite);
        }
        catch (LoginException loginex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Caught login exception in invoke");
            throw new IOException("RqmMethodInvoker exception(LoginException)", loginex);
        }
        catch (RequestException reqExeception) {
            log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Caught RequestException in invoke");
            throw new IOException("RqmMethodInvoker exception(RequestException)", reqExeception);
        }
        catch (Exception ex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Caught Exception in invoke");
            throw new IOException("RqmMethodInvoker exception(Exception)", ex);
        }
    }

    @Override
    public List<TestSuite> createOrUpdate(RqmParameterList parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public HashMap<String, String> attributes() {
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("testsuite_title", this.testSuiteTitle);
        return attr;
    }

    public Set<TestSuiteExecutionRecord> getTestSuiteExecutionRecords() {
        return this.testSuiteExecutionRecords;
    }

    public void setTestSuiteExecutionRecords(Set<TestSuiteExecutionRecord> testSuiteExecutionRecords) {
        this.testSuiteExecutionRecords = testSuiteExecutionRecords;
    }

    @Override
    public String getResourceName() {
        return RESOURCE_RQM_NAME;
    }
}

