/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm.request;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;
import javax.xml.ws.http.HTTPException;
import net.praqma.jenkins.rqm.model.exception.LoginException;
import net.praqma.jenkins.rqm.model.exception.RequestException;
import net.praqma.jenkins.rqm.request.RQMHttpClient;
import net.praqma.jenkins.rqm.request.RQMRequest;
import net.praqma.util.structure.Tuple;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;

public class RQMGetRequest
implements RQMRequest {
    GetMethod method = null;
    RQMHttpClient client = null;
    private static final Logger log = Logger.getLogger(RQMHttpClient.class.getName());

    public RQMGetRequest(RQMHttpClient client, String url, NameValuePair[] parameters) {
        Header[] headers;
        this.method = new GetMethod(url);
        this.method.addRequestHeader("Accept", "");
        this.method.addRequestHeader("Content-Type", "application/atom+xml");
        if (parameters != null) {
            this.method.setQueryString(parameters);
        }
        for (Header h : headers = this.method.getRequestHeaders()) {
            log.finest(String.format("[%s,%s]", h.getName(), h.getValue()));
        }
        this.client = client;
    }

    @Override
    public Tuple<Integer, String> executeRequest() throws LoginException, RequestException {
        Tuple result = new Tuple();
        try {
            String line;
            try {
                log.finest("ExecuteRequest");
                this.client.login();
            }
            catch (HttpException ex) {
                log.finest("HttpException: " + ex.getMessage());
                throw new LoginException(this.client.getUsr(), this.client.getPassword(), ex);
            }
            catch (GeneralSecurityException ex) {
                log.finest("GeneraSecurityException: " + ex.getMessage());
                throw new LoginException(this.client.getUsr(), this.client.getPassword(), ex);
            }
            int response = this.client.executeMethod((HttpMethod)this.method);
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.method.getResponseBodyAsStream(), Charset.forName("utf8")));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            reader.close();
            result.t1 = response;
            result.t2 = builder.toString();
        }
        catch (HTTPException ex) {
            log.severe(ex.getMessage());
            result.t1 = ex.getStatusCode();
            result.t2 = ex.getMessage() != null ? ex.getMessage() : "No message";
            throw new RequestException((Tuple<Integer, String>)result, (Throwable)ex);
        }
        catch (IOException ioex) {
            result.t1 = -1;
            result.t2 = ioex.getMessage() != null ? ioex.getMessage() : "No message";
            throw new RequestException((Tuple<Integer, String>)result, (Throwable)ioex);
        }
        finally {
            this.client.logout();
        }
        return result;
    }
}

