/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.ProminentProjectAction;
import java.util.ArrayList;
import java.util.List;
import net.praqma.jenkins.rqm.RQMBuildAction;
import net.praqma.jenkins.rqm.RqmPublisher;
import net.praqma.jenkins.rqm.model.TestCase;

public class RQMProjectAction
extends Actionable
implements ProminentProjectAction {
    public final AbstractProject<?, ?> project;
    private static final String PROJECT_NAME = "RQM Plugin";
    private static final String PROJECT_URL = "prqm";

    public RQMProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getDisplayName() {
        return PROJECT_NAME;
    }

    public String getSearchUrl() {
        return null;
    }

    public String getIconFileName() {
        return "/plugin/rqm-plugin/images/64x64/rqm-icon.png";
    }

    public String getUrlName() {
        return PROJECT_URL;
    }

    private RQMBuildAction _getPrevious(AbstractBuild<?, ?> build) {
        RQMBuildAction action = (RQMBuildAction)build.getAction(RQMBuildAction.class);
        if (action == null) {
            while (build != null) {
                if ((build = (AbstractBuild)build.getPreviousCompletedBuild()).getAction(RQMBuildAction.class) == null) continue;
                return (RQMBuildAction)build.getAction(RQMBuildAction.class);
            }
        }
        return action;
    }

    public RQMBuildAction getMostRecentNotNullRQMBuildAction() {
        RQMBuildAction action = null;
        AbstractBuild current = (AbstractBuild)this.project.getLastCompletedBuild();
        if (current == null) {
            return action;
        }
        action = this._getPrevious(current);
        return action;
    }

    public String getChosenCustomProperty() {
        return this.getMostRecentNotNullRQMBuildAction().customKey;
    }

    public RqmPublisher getRqmPublisher() {
        return (RqmPublisher)this.project.getPublishersList().get(RqmPublisher.class);
    }

    public List<TestCase> getListOfSelectedTestCases(String customPropertyName) {
        ArrayList<TestCase> list = new ArrayList<TestCase>();
        list.addAll(this.getMostRecentNotNullRQMBuildAction().testplan.getTestCaseHavingCustomFieldWithName(customPropertyName));
        return list;
    }
}

