/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.reloaded;

import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.ParameterValue;
import java.util.List;
import net.praqma.jenkins.plugin.reloaded.RebuildAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Util {
    public static ParameterValue getParameterValue(List<ParameterValue> pvs, String key) {
        for (ParameterValue pv : pvs) {
            if (!pv.getName().equals(key)) continue;
            return pv;
        }
        return null;
    }

    public static RebuildAction getDownstreamRebuildActionFromMatrixBuild(MatrixBuild mbuild) {
        RebuildAction action = (RebuildAction)mbuild.getAction(RebuildAction.class);
        if (action == null) {
            action = Util.getUpstreamRebuildAction(mbuild);
            if (action != null && action.doRebuildDownstream()) {
                return action;
            }
            return null;
        }
        return action;
    }

    public static RebuildAction getUpstreamRebuildAction(AbstractBuild<?, ?> build) {
        Cause.UpstreamCause cause = (Cause.UpstreamCause)build.getCause(Cause.UpstreamCause.class);
        if (cause != null) {
            AbstractProject project = build.getProject();
            List projects = project.getUpstreamProjects();
            for (AbstractProject p : projects) {
                if (!cause.getUpstreamProject().equals(p.getDisplayName())) continue;
                AbstractBuild origin = (AbstractBuild)p.getBuildByNumber(cause.getUpstreamBuild());
                return origin == null ? null : (RebuildAction)origin.getAction(RebuildAction.class);
            }
        }
        return null;
    }
}

