/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.reloaded;

import hudson.matrix.Combination;
import hudson.model.Action;
import java.util.HashMap;
import java.util.Map;

public class RebuildAction
implements Action {
    private Map<String, Boolean> configurations = new HashMap<String, Boolean>();
    private int baseBuildNumber = 0;
    private boolean rebuildDownstream = false;

    public void setBaseBuildNumber(int baseBuildNumber) {
        this.baseBuildNumber = baseBuildNumber;
    }

    public void setRebuildDownstream(boolean b) {
        this.rebuildDownstream = b;
    }

    public int getBaseBuildNumber() {
        return this.baseBuildNumber;
    }

    public boolean doRebuildDownstream() {
        return this.rebuildDownstream;
    }

    public RebuildAction clone(int baseBuildNumber) {
        RebuildAction ra = new RebuildAction();
        ra.baseBuildNumber = baseBuildNumber;
        ra.configurations = this.configurations;
        ra.rebuildDownstream = this.rebuildDownstream;
        return ra;
    }

    public RebuildAction clone() {
        RebuildAction ra = new RebuildAction();
        ra.baseBuildNumber = this.baseBuildNumber;
        ra.configurations = this.configurations;
        ra.rebuildDownstream = this.rebuildDownstream;
        return ra;
    }

    public void addConfiguration(Combination combination, boolean reuse) {
        this.configurations.put(combination.toString(), reuse);
    }

    public boolean getConfiguration(Combination combination) {
        if (this.configurations.containsKey(combination.toString())) {
            return this.configurations.get(combination.toString());
        }
        return false;
    }

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    public String toString() {
        return "Rebuild(" + this.baseBuildNumber + "/" + this.rebuildDownstream + "): " + this.configurations.size();
    }
}

