/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.reloaded;

import hudson.Extension;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import net.praqma.jenkins.plugin.reloaded.MatrixReloadedAction;
import net.praqma.jenkins.plugin.reloaded.RebuildAction;
import net.praqma.jenkins.plugin.reloaded.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class MatrixReloadedListener
extends RunListener<Run> {
    public MatrixReloadedListener() {
        super(Run.class);
    }

    public void onStarted(Run run, TaskListener listener) {
        if (run instanceof MatrixBuild && run.number > 1) {
            RebuildAction action = (RebuildAction)run.getAction(RebuildAction.class);
            if (action == null) {
                action = Util.getUpstreamRebuildAction((AbstractBuild)run);
                if (action != null && action.doRebuildDownstream()) {
                    action = action.clone(run.number - 1);
                    run.addAction((Action)action);
                } else {
                    return;
                }
            }
            MatrixBuild mb = (MatrixBuild)run;
            MatrixBuild base = (MatrixBuild)((MatrixProject)mb.getProject()).getBuildByNumber(action.getBaseBuildNumber());
            ((MatrixBuild)run).setBaseBuild(base);
        }
    }

    public void onCompleted(Run run, TaskListener listener) {
        MatrixReloadedAction action;
        AbstractBuild build;
        if (run instanceof MatrixBuild) {
            build = (AbstractBuild)run;
            action = new MatrixReloadedAction();
            build.getActions().add(action);
        }
        if (run instanceof MatrixRun) {
            build = (AbstractBuild)run;
            action = new MatrixReloadedAction(((MatrixRun)run).getParent().getCombination().toString());
            build.getActions().add(action);
        }
    }
}

