/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.hudson.scm;

import hudson.model.User;
import hudson.scm.ChangeLogSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.praqma.hudson.scm.ChangeLogSetImpl;

public class ChangeLogEntryImpl
extends ChangeLogSet.Entry {
    private static final transient Pattern splitChangeSet = Pattern.compile("^([^\\(]+)\\(([^\\)]+)(.*?)(\\S+)(\\S+)(.*)");
    private ChangeLogSetImpl parent;
    private String actName;
    private String actHeadline;
    private String msg;
    private String author;
    private String date;
    protected static Logger logger = Logger.getLogger(ChangeLogEntryImpl.class.getName());
    private volatile List<String> affectedPaths = new ArrayList<String>();

    public Collection<String> getAffectedPaths() {
        return this.affectedPaths;
    }

    public String getOnlyChangedFile(String fulltext) {
        Matcher m = splitChangeSet.matcher(fulltext);
        try {
            if (m.find()) {
                return m.group(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getOnlyClearCaseChangedFile(String fulltext) {
        Matcher m = splitChangeSet.matcher(fulltext);
        try {
            if (m.find()) {
                return m.group(2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getUserClearCaseNumber(String fulltext) {
        Matcher m = splitChangeSet.matcher(fulltext);
        try {
            if (m.find()) {
                return m.group(6);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setNextFilepath(String filepath) {
        this.affectedPaths.add(filepath);
    }

    public User getAuthor() {
        if (this.author == null) {
            return User.getUnknown();
        }
        return User.get((String)this.author);
    }

    public void setMyAuthor(String author) {
        this.author = author;
    }

    public void setParent(ChangeLogSetImpl parent) {
        this.parent = parent;
    }

    public String getMsg() {
        return this.actName;
    }

    public void setActName(String actName) {
        this.actName = actName;
    }

    public void setActHeadline(String actHeadline) {
        this.actHeadline = actHeadline;
    }

    public String getActHeadline() {
        return this.actHeadline;
    }
}

