/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.hudson.remoting;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.clearcase.Deliver;
import net.praqma.clearcase.exceptions.ClearCaseException;
import net.praqma.clearcase.exceptions.CleartoolException;
import net.praqma.clearcase.exceptions.DeliverException;
import net.praqma.clearcase.interfaces.Diffable;
import net.praqma.clearcase.ucm.entities.Activity;
import net.praqma.clearcase.ucm.entities.Baseline;
import net.praqma.clearcase.ucm.entities.Stream;
import net.praqma.clearcase.ucm.entities.Version;
import net.praqma.clearcase.ucm.view.SnapshotView;
import net.praqma.hudson.Config;
import net.praqma.hudson.Util;
import net.praqma.hudson.exception.DeliverNotCancelledException;
import net.praqma.hudson.exception.ScmException;
import net.praqma.hudson.remoting.EstablishResult;

public class RemoteDeliver
implements FilePath.FileCallable<EstablishResult> {
    private static final long serialVersionUID = 1L;
    private Logger logger;
    private String jobName;
    private String baseline;
    private String destinationstream;
    private BuildListener listener;
    private String id = "";
    private SnapshotView snapview;
    private String loadModule;
    private PrintStream out = null;
    private String viewtag = "";
    private boolean forceDeliver;
    private PrintStream pstream;
    private File workspace;
    private boolean swipe = true;

    public RemoteDeliver(String destinationstream, BuildListener listener, String loadModule, String baseline, String jobName, boolean forceDeliver, boolean swipe) {
        this.jobName = jobName;
        this.baseline = baseline;
        this.destinationstream = destinationstream;
        this.listener = listener;
        this.loadModule = loadModule;
        this.forceDeliver = forceDeliver;
        this.swipe = swipe;
    }

    public EstablishResult invoke(File workspace, VirtualChannel channel) throws IOException {
        this.out = this.listener.getLogger();
        this.logger = Logger.getLogger(RemoteDeliver.class.getName());
        this.logger.fine("Starting remote deliver");
        this.workspace = workspace;
        Baseline baseline = null;
        try {
            baseline = Baseline.get((String)this.baseline).load();
        }
        catch (Exception e) {
            throw new IOException("Could not create Baseline object: " + e.getMessage(), e);
        }
        this.logger.fine(baseline + " created");
        Stream destinationStream = null;
        try {
            destinationStream = Stream.get((String)this.destinationstream).load();
        }
        catch (Exception e) {
            throw new IOException("Could not create destination Stream object: " + e.getMessage(), e);
        }
        this.logger.fine(destinationStream + " created");
        try {
            this.snapview = this.makeDeliverView(destinationStream, workspace);
        }
        catch (Exception e) {
            throw new IOException("Could not create deliver view: " + e.getMessage(), e);
        }
        this.logger.fine("View: " + workspace);
        ArrayList<Activity> bldiff = new ArrayList();
        try {
            bldiff = Version.getBaselineDiff((Diffable)destinationStream, (Diffable)baseline, (boolean)true, (File)this.snapview.getViewRoot());
        }
        catch (Exception e1) {
            this.out.println("[" + Config.nameShort + "] Unable to create change log: " + e1.getMessage());
        }
        EstablishResult er = new EstablishResult(this.viewtag);
        er.setView(this.snapview);
        er.setActivities(bldiff);
        try {
            this.deliver(baseline, destinationStream, this.forceDeliver, 2);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return er;
    }

    private void deliver(Baseline baseline, Stream dstream, boolean forceDeliver, int triesLeft) throws IOException, DeliverNotCancelledException, ClearCaseException {
        this.logger.config("Delivering " + baseline.getShortname() + " to " + dstream.getShortname() + ". Tries left: " + triesLeft);
        if (triesLeft < 1) {
            this.out.println("[" + Config.nameShort + "] Unable to deliver, giving up.");
            throw new DeliverNotCancelledException("Unable to force cancel deliver");
        }
        Deliver deliver = null;
        try {
            this.out.println("[" + Config.nameShort + "] Starting deliver(tries left: " + triesLeft + ")");
            deliver = new Deliver(baseline, baseline.getStream(), dstream, this.snapview.getViewRoot(), this.snapview.getViewtag());
            deliver.deliver(true, false, true, false);
        }
        catch (DeliverException e) {
            this.logger.log(Level.FINE, "Failed to deliver", e);
            if (e.getType().equals((Object)DeliverException.Type.DELIVER_IN_PROGRESS)) {
                this.out.println("[" + Config.nameShort + "] Deliver already in progress");
                if (forceDeliver) {
                    this.out.println(e.getMessage());
                    this.out.println("[" + Config.nameShort + "] Forcing this deliver.");
                    Deliver.cancel((Stream)dstream);
                    this.snapview.Update(this.swipe, true, true, false, new SnapshotView.LoadRules(this.snapview, SnapshotView.Components.valueOf((String)this.loadModule.toUpperCase())));
                    this.logger.config("Trying to deliver again...");
                    this.deliver(baseline, dstream, forceDeliver, triesLeft - 1);
                }
                throw e;
            }
            throw e;
        }
        catch (CleartoolException e) {
            this.logger.warning("Unable to get status from stream: " + e.getMessage());
            throw new IOException(e);
        }
        catch (Exception e) {
            this.logger.warning("Unable deliver: " + e.getMessage());
            throw new IOException(e);
        }
    }

    private SnapshotView makeDeliverView(Stream stream, File workspace) throws ScmException {
        String newJobName = this.jobName.replaceAll("\\s", "_");
        this.viewtag = "CCUCM_" + newJobName + "_" + System.getenv("COMPUTERNAME") + "_" + stream.getShortname();
        File viewroot = new File(workspace, "view");
        return Util.makeView(stream, workspace, this.listener, this.loadModule, viewroot, this.viewtag);
    }

    public SnapshotView getSnapShotView() {
        return this.snapview;
    }
}

