/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.hudson.notifier;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.remoting.VirtualChannel;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.clearcase.exceptions.UnableToPromoteBaselineException;
import net.praqma.clearcase.ucm.entities.Baseline;
import net.praqma.clearcase.ucm.entities.Stream;
import net.praqma.clearcase.util.ExceptionUtils;
import net.praqma.hudson.CCUCMBuildAction;
import net.praqma.hudson.Config;
import net.praqma.hudson.exception.NotifierException;
import net.praqma.hudson.nametemplates.NameTemplate;
import net.praqma.hudson.notifier.RemotePostBuild;
import net.praqma.hudson.notifier.Status;
import net.praqma.hudson.remoting.RemoteUtil;
import net.praqma.hudson.scm.CCUCMScm;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;

public class CCUCMNotifier
extends Notifier {
    private PrintStream out;
    private Status status;
    private String id = "";
    private static Logger logger = Logger.getLogger(CCUCMNotifier.class.getName());
    private String jobName = "";
    private Integer jobNumber = 0;
    public static String logShortPrefix = String.format("[%s]", Config.nameShort);

    public CCUCMNotifier() {
    }

    public CCUCMNotifier(boolean recommended, boolean makeTag, boolean setDescription) {
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        CCUCMBuildAction action;
        boolean result;
        block13: {
            logger.fine("ClearCase UCM plugin notifier");
            result = true;
            this.out = listener.getLogger();
            this.status = new Status();
            this.jobName = ((AbstractProject)build.getParent()).getDisplayName().replace(' ', '_');
            this.jobNumber = build.getNumber();
            this.id = "[" + this.jobName + "::" + this.jobNumber + "]";
            SCM scmTemp = build.getProject().getScm();
            if (!(scmTemp instanceof CCUCMScm)) {
                return true;
            }
            Baseline baseline = null;
            action = (CCUCMBuildAction)build.getAction(CCUCMBuildAction.class);
            if (action == null) {
                logger.warning("WHOA, what happened!?");
                throw new AbortException("No ClearCase Action object found");
            }
            logger.fine(action.stringify());
            baseline = action.getBaseline();
            if (baseline != null) {
                this.out.println("Processing baseline");
                this.status.setErrorMessage(action.getError());
                try {
                    this.processBuild(build, launcher, listener, action);
                    if (!action.doSetDescription()) break block13;
                    String d = build.getDescription();
                    logger.fine(String.format("build.getDesciption() is: %s", d));
                    if (d != null) {
                        build.setDescription((d.length() > 0 ? d + "<br/>" : "") + this.status.getBuildDescr());
                        break block13;
                    }
                    logger.fine(String.format("Setting build description to: %s", this.status.getBuildDescr()));
                    build.setDescription(this.status.getBuildDescr());
                }
                catch (NotifierException ne) {
                    this.out.println("NotifierException: " + ne.getMessage());
                }
                catch (IOException e) {
                    this.out.println(String.format("%s Couldn't set build description", logShortPrefix));
                }
            } else if (action.getResolveBaselineException() != null) {
                build.setResult(Result.FAILURE);
            } else {
                this.out.println(String.format("%s Nothing to do!", logShortPrefix));
                String d = build.getDescription();
                if (d != null) {
                    build.setDescription((d.length() > 0 ? d + "<br/>" : "") + "Nothing to do");
                } else {
                    build.setDescription("Nothing to do");
                }
                build.setResult(Result.NOT_BUILT);
            }
        }
        if (action != null && action.getViewTag() != null) {
            logger.fine("Ending view " + action.getViewTag());
            RemoteUtil.endView(build.getWorkspace(), action.getViewTag());
        }
        this.out.println("[" + Config.nameShort + "] Post build steps done");
        return result;
    }

    private void processBuild(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, CCUCMBuildAction pstate) throws NotifierException {
        Baseline targetbaseline;
        Baseline sourcebaseline;
        Stream sourcestream;
        Stream targetstream;
        FilePath currentWorkspace;
        Result buildResult;
        block23: {
            buildResult = build.getResult();
            VirtualChannel ch = launcher.getChannel();
            if (ch == null) {
                logger.fine("The channel was null");
            }
            String workspace = null;
            currentWorkspace = build.getExecutor().getCurrentWorkspace();
            try {
                workspace = build.getExecutor().getCurrentWorkspace().absolutize().getRemote();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, String.format("%s Failed to get remote workspace", Config.nameShort), ex);
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, String.format("%s Failed to get remote workspace", Config.nameShort), ex);
            }
            if (StringUtils.isBlank((String)workspace)) {
                logger.warning("Workspace is null");
                throw new NotifierException("Workspace is null");
            }
            this.out.println(String.format("%s Build result: %s", logShortPrefix, buildResult));
            CCUCMBuildAction action = (CCUCMBuildAction)build.getAction(CCUCMBuildAction.class);
            targetstream = null;
            sourcestream = targetstream = pstate.getBaseline().getStream();
            targetbaseline = sourcebaseline = pstate.getBaseline();
            logger.fine(String.format("NTBC: %s", pstate.doNeedsToBeCompleted()));
            boolean treatSuccessful = buildResult.isBetterThan(pstate.getUnstable().treatSuccessful() ? Result.FAILURE : Result.UNSTABLE);
            if (pstate.doNeedsToBeCompleted() && pstate.getPolling().isPollingOther()) {
                this.status.setBuildStatus(buildResult);
                try {
                    this.out.print(logShortPrefix + " " + (treatSuccessful ? "Completing" : "Cancelling") + " the deliver. ");
                    RemoteUtil.completeRemoteDeliver(build.getExecutor().getCurrentWorkspace(), listener, pstate.getBaseline(), pstate.getStream(), action.getViewTag(), action.getViewPath(), treatSuccessful);
                    this.out.println("Success.");
                    if (!treatSuccessful || !pstate.doCreateBaseline()) break block23;
                    try {
                        this.out.println(String.format("%s Creating baseline on Integration stream.", logShortPrefix));
                        this.out.println(String.format("%s Absolute path of remoteWorkspace: %s", logShortPrefix, workspace));
                        pstate.setWorkspace(workspace);
                        NameTemplate.validateTemplates(pstate);
                        String name = NameTemplate.parseTemplate(pstate.getNameTemplate(), pstate);
                        targetbaseline = RemoteUtil.createRemoteBaseline(currentWorkspace, listener, name, pstate.getBaseline().getComponent(), action.getViewPath(), pstate.getBaseline().getUser());
                        if (action != null) {
                            action.setCreatedBaseline(targetbaseline);
                        }
                    }
                    catch (Exception e) {
                        ExceptionUtils.print((Throwable)e, (PrintStream)this.out, (boolean)false);
                        logger.warning("Failed to create baseline on stream");
                        logger.log(Level.WARNING, "", e);
                        if (pstate.doRecommend()) {
                            this.out.println(String.format("%s Cannot recommend Baseline when not created", logShortPrefix));
                        }
                        logger.warning("Failing build because baseline could not be created");
                        build.setResult(Result.FAILURE);
                        pstate.setRecommend(false);
                    }
                }
                catch (Exception e) {
                    this.status.setBuildStatus(buildResult);
                    this.status.setStable(false);
                    this.out.println("Failed.");
                    logger.log(Level.WARNING, "", e);
                    if (pstate.doRecommend()) {
                        this.out.println(String.format("%s Cannot recommend a baseline when deliver failed", logShortPrefix));
                    }
                    pstate.setRecommend(false);
                    if (treatSuccessful) {
                        try {
                            this.out.println(String.format("%s Trying to cancel the deliver.", logShortPrefix));
                            RemoteUtil.completeRemoteDeliver(currentWorkspace, listener, pstate.getBaseline(), pstate.getStream(), action.getViewTag(), action.getViewPath(), false);
                            this.out.println("Success.");
                        }
                        catch (Exception e1) {
                            this.out.println(" Failed.");
                            logger.warning("Failed to cancel deliver");
                            logger.log(Level.WARNING, "Exception caught - RemoteUtil.completeRemoteDeliver() - TreatSuccesful == true", e1);
                        }
                    }
                    logger.warning("Failed to cancel deliver");
                    logger.log(Level.WARNING, "TreatSuccesful == false", e);
                }
            }
        }
        if (pstate.getPolling().isPollingOther()) {
            targetstream = pstate.getStream();
        }
        try {
            logger.fine(String.format("%sRemote post build step", this.id));
            this.out.println(String.format("%s Performing common post build steps", logShortPrefix));
            this.status = (Status)currentWorkspace.act((FilePath.FileCallable)new RemotePostBuild(buildResult, this.status, listener, pstate.doMakeTag(), pstate.doRecommend(), pstate.getUnstable(), pstate.getPromotionLevel() == null, sourcebaseline, targetbaseline, sourcestream, targetstream, ((AbstractProject)build.getParent()).getDisplayName(), Integer.toString(build.getNumber())));
        }
        catch (Exception e) {
            this.status.setStable(false);
            logger.log(Level.WARNING, "", e);
            this.out.println(String.format("%s Error: Post build failed", logShortPrefix));
            Throwable cause = net.praqma.util.ExceptionUtils.unpackFrom(IOException.class, (Throwable)e);
            ExceptionUtils.print((Throwable)cause, (PrintStream)this.out, (boolean)true);
        }
        if (this.status.getPromotedLevel() != null) {
            logger.fine("Baseline promotion level was changed on the remote: promotedLevel != null");
            try {
                logger.fine(String.format("%sBaselines promotion planned to be set to %s", this.id, this.status.getPromotedLevel().toString()));
                pstate.getBaseline().setPromotionLevel(this.status.getPromotedLevel());
                logger.fine(String.format("%sBaselines promotion level updates to %s", this.id, this.status.getPromotedLevel().toString()));
            }
            catch (UnableToPromoteBaselineException e) {
                logger.warning("===UnableToPromoteBaseline===");
                logger.warning(String.format("Unable to set promotion level of baseline %s to %s", e.getEntity() != null ? e.getEntity().getFullyQualifiedName() : "null", e.getPromotionLevel()));
                e.print(this.out);
                logger.warning("===UnableToPromoteBaseline===");
            }
        }
        logger.fine("Setting build status on Status object");
        this.status.setBuildStatus(buildResult);
        if (!this.status.isStable()) {
            logger.fine("BuildStatus object marked build unstable");
            build.setResult(Result.UNSTABLE);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(CCUCMNotifier.class);
            this.load();
        }

        public String getDisplayName() {
            return Config.nameLong;
        }

        public Notifier newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return new CCUCMNotifier();
        }

        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }
    }
}

