/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.hudson;

import hudson.FilePath;
import hudson.model.BuildListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.praqma.clearcase.Cool;
import net.praqma.clearcase.PVob;
import net.praqma.clearcase.exceptions.ClearCaseException;
import net.praqma.clearcase.exceptions.ViewException;
import net.praqma.clearcase.ucm.entities.Activity;
import net.praqma.clearcase.ucm.entities.Baseline;
import net.praqma.clearcase.ucm.entities.Project;
import net.praqma.clearcase.ucm.entities.Stream;
import net.praqma.clearcase.ucm.entities.Version;
import net.praqma.clearcase.ucm.utils.VersionList;
import net.praqma.clearcase.ucm.view.SnapshotView;
import net.praqma.clearcase.ucm.view.UCMView;
import net.praqma.hudson.Config;
import net.praqma.hudson.exception.ScmException;

public abstract class Util {
    private static Logger logger = Logger.getLogger(Util.class.getName());

    public static Project.PromotionLevel getLevel(String level) {
        if (level.equalsIgnoreCase("any")) {
            return null;
        }
        return Project.getPlevelFromString((String)level);
    }

    public Stream getDeveloperStream(String streamname, PVob pvob, Stream buildIntegrationStream, Baseline foundationBaseline) throws ScmException {
        Stream devstream = null;
        try {
            devstream = Stream.streamExists((String)(streamname + pvob)) ? Stream.get((String)streamname, (PVob)pvob) : Stream.create((Stream)buildIntegrationStream, (String)(streamname + pvob), (boolean)true, (Baseline)foundationBaseline);
            devstream.load();
        }
        catch (Exception e) {
            throw new ScmException("Could not get stream: " + streamname, e);
        }
        return devstream;
    }

    public static String createChangelog(List<Activity> activities, Baseline bl, boolean trimmed) {
        logger.fine("Generating change set, " + trimmed);
        ChangeSetGenerator csg = new ChangeSetGenerator().createHeader(bl.getShortname());
        if (trimmed) {
            VersionList vl = new VersionList().addActivities(activities).setBranchName("^.*" + Cool.qfs + bl.getStream().getShortname() + ".*$");
            Map changeSet = vl.getLatestForActivities();
            for (Activity activity : changeSet.keySet()) {
                csg.addAcitivity(activity.getShortname(), activity.getHeadline(), activity.getUser(), (List)changeSet.get(activity));
            }
        } else {
            for (Activity activity : activities) {
                VersionList versions = new VersionList((List)activity.changeset.versions).getLatest();
                csg.addAcitivity(activity.getShortname(), activity.getHeadline(), activity.getUser(), (List<Version>)versions);
            }
        }
        return csg.close().get();
    }

    public static SnapshotView makeView(Stream stream, File workspace, BuildListener listener, String loadModule, File viewroot, String viewtag) throws ScmException {
        return Util.makeView(stream, workspace, listener, loadModule, viewroot, viewtag, true);
    }

    public static SnapshotView makeView(Stream stream, File workspace, BuildListener listener, String loadModule, File viewroot, String viewtag, boolean update) throws ScmException {
        PrintStream hudsonOut = listener.getLogger();
        SnapshotView snapview = null;
        hudsonOut.println("[" + Config.nameShort + "] View root: " + viewroot.getAbsolutePath());
        hudsonOut.println("[" + Config.nameShort + "] View tag : " + viewtag);
        boolean pathExists = false;
        try {
            if (viewroot.exists()) {
                pathExists = true;
                hudsonOut.println("[" + Config.nameShort + "] Reusing view root");
            } else if (!viewroot.mkdir()) {
                throw new ScmException("Could not create folder for view root:  " + viewroot.toString(), null);
            }
        }
        catch (Exception e) {
            throw new ScmException("Could not make workspace (for viewroot " + viewroot.toString() + "). Cause: " + e.getMessage(), e);
        }
        hudsonOut.println("[" + Config.nameShort + "] Determine if view tag exists");
        if (UCMView.viewExists((String)viewtag)) {
            block24: {
                hudsonOut.println("[" + Config.nameShort + "] Reusing view tag");
                try {
                    String vt = SnapshotView.viewrootIsValid((File)viewroot);
                    hudsonOut.println("[" + Config.nameShort + "] UUID resulted in " + vt);
                    if (vt.equals(viewtag) || !pathExists) break block24;
                    hudsonOut.println("[" + Config.nameShort + "] View tag is not the same as " + vt);
                    FilePath path = new FilePath(viewroot);
                    hudsonOut.println("[" + Config.nameShort + "] Trying to delete " + path);
                    try {
                        path.deleteRecursive();
                    }
                    catch (Exception e) {
                        throw new ScmException("Unable to recursively prepare view root", e);
                    }
                    Util.makeView(stream, workspace, listener, loadModule, viewroot, viewtag);
                }
                catch (ClearCaseException ucmE) {
                    try {
                        hudsonOut.println("[" + Config.nameShort + "] Regenerating invalid view root");
                        UCMView.end((String)viewtag);
                        SnapshotView.regenerateViewDotDat((File)viewroot, (String)viewtag);
                    }
                    catch (ClearCaseException ucmEx) {
                        ucmEx.print(hudsonOut);
                        throw new ScmException("Could not make workspace - could not regenerate view", (Exception)((Object)ucmEx));
                    }
                    catch (IOException e) {
                        throw new ScmException("Could not make workspace - could not regenerate view", e);
                    }
                }
                catch (Exception e) {
                    hudsonOut.println("[" + Config.nameShort + "] Failed making workspace: " + e.getMessage());
                    throw new ScmException("Failed making workspace", e);
                }
            }
            hudsonOut.println("[" + Config.nameShort + "] Getting snapshotview");
            try {
                snapview = SnapshotView.get((File)viewroot);
            }
            catch (ClearCaseException e) {
                e.print(hudsonOut);
                throw new ScmException("Could not get view for workspace", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new ScmException("Could not get view for workspace", e);
            }
        }
        try {
            hudsonOut.println("[" + Config.nameShort + "] Creating new view");
            snapview = SnapshotView.create((Stream)stream, (File)viewroot, (String)viewtag);
            hudsonOut.println("[" + Config.nameShort + "] Created new view in local workspace: " + viewroot.getAbsolutePath());
        }
        catch (ClearCaseException e) {
            e.print(hudsonOut);
            throw new ScmException("View not found in this region, but views with viewtag '" + viewtag + "' might exist in the other regions. Try changing the region Hudson or the slave runs in.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ScmException("Unable to create view: " + e.getMessage(), e);
        }
        if (update) {
            try {
                hudsonOut.println("[" + Config.nameShort + "] Updating view using " + loadModule.toLowerCase() + " modules.");
                snapview.Update(true, true, true, false, new SnapshotView.LoadRules(snapview, SnapshotView.Components.valueOf((String)loadModule.toUpperCase())));
            }
            catch (ClearCaseException e) {
                e.print(hudsonOut);
                if (e instanceof ViewException && ((ViewException)e).getType().equals((Object)ViewException.Type.REBASING)) {
                    hudsonOut.println("The view is currently being used to rebase another stream");
                }
                throw new ScmException("Could not update snapshot view", (Exception)((Object)e));
            }
        }
        return snapview;
    }

    public static void println(PrintStream out, Object msg) {
        out.println("[" + Config.nameShort + "] " + msg.toString());
    }

    public static void storeException(File file, Throwable throwable) throws IOException {
        file.delete();
        PrintWriter out = new PrintWriter(file);
        throwable.printStackTrace(out);
        out.close();
    }

    public static class ChangeSetGenerator {
        private StringBuilder buffer = new StringBuilder();

        public ChangeSetGenerator createHeader(String header) {
            this.buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.buffer.append("<changelog>");
            this.buffer.append("<changeset>");
            this.buffer.append("<entry>");
            this.buffer.append("<blName>" + header + "</blName>");
            return this;
        }

        public ChangeSetGenerator addAcitivity(String name, String header, String username, List<Version> versions) {
            this.buffer.append("<activity>");
            this.buffer.append("<actName>" + name + "</actName>");
            this.buffer.append("<actHeadline>" + header + "</actHeadline>");
            this.buffer.append("<author>" + username + "</author>");
            String temp = null;
            for (Version v : versions) {
                try {
                    temp = "<file>" + v.getSFile() + " (" + v.getVersion() + ") user: " + v.blame() + "</file>";
                }
                catch (ClearCaseException e) {
                    logger.warning("Could not generate log");
                }
                this.buffer.append(temp);
            }
            this.buffer.append("</activity>");
            return this;
        }

        public ChangeSetGenerator close() {
            this.buffer.append("</entry>");
            this.buffer.append("</changeset>");
            this.buffer.append("</changelog>");
            return this;
        }

        public String get() {
            return this.buffer.toString();
        }
    }
}

