/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyv.livescenes.playback.video;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import com.easefun.polyv.businesssdk.api.auxiliary.IPolyvAuxiliaryVideoViewListenerEvent;
import com.easefun.polyv.businesssdk.api.common.player.PolyvPlayError;
import com.easefun.polyv.businesssdk.api.common.player.PolyvPlayType;
import com.easefun.polyv.businesssdk.api.common.player.listener.IPolyvVideoViewListenerEvent;
import com.easefun.polyv.businesssdk.api.common.player.microplayer.PolyvCommonVideoView;
import com.easefun.polyv.businesssdk.api.common.ppt.IPolyvPPTView;
import com.easefun.polyv.businesssdk.model.video.PolyvBaseVideoParams;
import com.easefun.polyv.businesssdk.model.video.PolyvLiveChannelVO;
import com.easefun.polyv.businesssdk.model.video.PolyvLiveMarqueeVO;
import com.easefun.polyv.businesssdk.model.video.PolyvLogVideoLableVO;
import com.easefun.polyv.businesssdk.net.PolyvCommonApiManager;
import com.easefun.polyv.businesssdk.vodplayer.PolyvVodSDKClient;
import com.easefun.polyv.livescenes.config.PolyvLiveSDKClient;
import com.easefun.polyv.livescenes.log.PolyvELogSender;
import com.easefun.polyv.livescenes.log.PolyvLiveViewLog;
import com.easefun.polyv.livescenes.model.PolyvPlaybackVO;
import com.easefun.polyv.livescenes.net.PolyvApiManager;
import com.easefun.polyv.livescenes.net.PolyvJsonUtils;
import com.easefun.polyv.livescenes.playback.log.PolyvPlaybackVodQOSAnalytics;
import com.easefun.polyv.livescenes.playback.log.PolyvPlaybackVodViewLog;
import com.easefun.polyv.livescenes.playback.ppt.PolyvPlaybackPPTPlayWrapper;
import com.easefun.polyv.livescenes.playback.video.PolyvPlaybackVideoViewListener;
import com.easefun.polyv.livescenes.playback.video.api.IPolyvPlaybackVideoView;
import com.easefun.polyv.livescenes.playback.video.api.IPolyvPlaybackVideoViewPlayBinder;
import com.plv.foundationsdk.config.PLVPlayOption;
import com.plv.foundationsdk.log.PLVCommonLog;
import com.plv.foundationsdk.log.elog.logcode.play.PLVErrorCodePlayVideoInfo;
import com.plv.foundationsdk.log.elog.logcode.play.PLVErrorCodePlayVideoPlay;
import com.plv.foundationsdk.net.PLVResponseExcutor;
import com.plv.foundationsdk.net.PLVrResponseCallback;
import com.plv.foundationsdk.rx.PLVRxBaseTransformer;
import com.plv.foundationsdk.utils.PLVGsonUtil;
import com.plv.foundationsdk.utils.PLVUtils;
import com.plv.thirdpart.blankj.utilcode.util.EncryptUtils;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.util.List;
import java.util.Locale;
import tv.danmaku.ijk.media.player.IMediaPlayer;

public class PolyvPlaybackVideoView
extends PolyvCommonVideoView<PolyvPlaybackVO.DataBean, PolyvPlaybackVideoViewListener>
implements IPolyvPlaybackVideoView,
IPolyvPlaybackVideoViewPlayBinder {
    private Disposable b;
    private Disposable c;
    private PolyvPlaybackPPTPlayWrapper d;
    private PolyvLiveChannelVO e;
    private PolyvPlaybackVO.DataBean f;
    private Boolean g;
    private String userId;
    private String videoId;
    private String channelId;
    private PolyvPlayType h = PolyvPlayType.IDLE;
    private long i = 0L;
    private boolean j = false;
    private boolean k = false;
    private int l = 0;
    private int m = 0;

    public PolyvPlaybackVideoView(@NonNull Context context) {
        super(context);
    }

    public PolyvPlaybackVideoView(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public PolyvPlaybackVideoView(@NonNull Context context, @Nullable AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    protected void initial() {
        super.initial();
        this.d = new PolyvPlaybackPPTPlayWrapper(this);
    }

    protected void requestModleVO(PolyvBaseVideoParams polyvBaseVideoParams, int n) {
        this.c();
        this.release(true);
        this.a();
        this.a(polyvBaseVideoParams);
        this.b();
        this.g();
    }

    protected boolean onPlayInfo(int n, int n2) {
        if (n == 701) {
            this.i = System.currentTimeMillis();
        } else if (n == 702 && this.h == PolyvPlayType.ONLINE_PLAY && !this.j) {
            this.j = true;
            int n3 = (int)(System.currentTimeMillis() - this.i);
            PolyvPlaybackVodQOSAnalytics.getInstance().buffer(this.playId, this.videoId, n3, "", this.f == null ? "" : this.f.getChannelSessionId(), PolyvPlaybackVodQOSAnalytics.getInstance().getQOSAnalyticsParam());
        }
        return true;
    }

    protected boolean onPlayPrepared() {
        int n;
        this.createMarquee();
        if (this.h == PolyvPlayType.ONLINE_PLAY && !this.k) {
            this.k = true;
            n = (int)(System.currentTimeMillis() - this.startLoaderTime);
            PolyvPlaybackVodQOSAnalytics.getInstance().loading(this.playId, this.videoId, n, "", this.f == null ? "" : this.f.getChannelSessionId(), PolyvPlaybackVodQOSAnalytics.getInstance().getQOSAnalyticsParam());
        }
        this.setPlayerBufferingViewVisibility(8);
        this.setNoStreamViewVisibility(4);
        if (this.l > 0) {
            if (this.l < 100) {
                n = this.getDuration() * this.l / 100;
                this.seekTo(n);
            } else {
                this.seekTo(this.l);
            }
            this.l = 0;
        }
        if (this.ijkVideoView.getTargetState() != this.ijkVideoView.getStatePauseCode()) {
            this.start();
        }
        return true;
    }

    protected boolean onPlayError(int n, int n2) {
        if (this.destroyFlag) {
            return false;
        }
        this.a(n);
        PolyvPlaybackVodQOSAnalytics polyvPlaybackVodQOSAnalytics = PolyvPlaybackVodQOSAnalytics.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        PolyvPlaybackVodQOSAnalytics.getInstance();
        polyvPlaybackVodQOSAnalytics.error(this.playId, this.videoId, stringBuilder.append("video_type_").append("on_error_listener").toString(), "", this.f == null ? "" : this.f.getChannelSessionId(), "", "", PolyvPlaybackVodQOSAnalytics.getInstance().getQOSAnalyticsParam(), String.format(Locale.getDefault(), "%s implErr[%d] frameworkErr[%d]", this.getCurrentPlayPath(), n2, n), this.getCurrentPlayPath());
        this.setPlayerBufferingViewVisibility(8);
        this.setNoStreamViewVisibility(0);
        return true;
    }

    protected boolean onPlayCompelete() {
        IMediaPlayer iMediaPlayer = this.getMediaPlayer();
        if (iMediaPlayer != null) {
            PLVCommonLog.e((String)"PolyvBaseVideoView", (String)("pos:" + iMediaPlayer.getCurrentPosition() + "   dur :" + iMediaPlayer.getDuration()));
        }
        return true;
    }

    protected boolean onPlaySeek() {
        IMediaPlayer iMediaPlayer = this.getMediaPlayer();
        if (iMediaPlayer != null) {
            Log.i((String)"PolyvBaseVideoView", (String)(iMediaPlayer.getCurrentPosition() + "/" + iMediaPlayer.getDuration()));
        }
        return false;
    }

    protected void staticsVideoViewPlay() {
        if (this.h == PolyvPlayType.ONLINE_PLAY) {
            if (this.m == 1) {
                long l = 0L;
                if (this.getIjkMediaPlayer() != null) {
                    l = this.getIjkMediaPlayer().getTrafficStatisticByteCount();
                }
                PolyvPlaybackVodViewLog.getInstance().statVodPlay(this.playId, this.videoId, l, this.watchTimeDuration, this.stayTimeDuration, this.getCurrentPosition() / 1000, this.getDuration() / 1000, 1L, this.getViewerId(), "", this.viewLogParam2, "", this.viewLogParam4, this.viewLogParam5, this.getCurrentPlayPath());
            } else {
                PolyvLiveViewLog.getInstance().statLive(this.playId, this.userId, this.channelId, 0L, this.watchTimeDuration, this.stayTimeDuration, this.f == null ? "" : this.f.getChannelSessionId(), "0", this.getViewerId(), this.viewLogParam2, "vod", this.viewLogParam4, this.viewLogParam5);
            }
        }
    }

    protected Uri createPlayUri() {
        return null;
    }

    protected boolean isValidatePlayId() {
        if (PLVUtils.validateVideoId((String)this.videoId)) {
            return true;
        }
        int n = PolyvELogSender.sendPlaybackLog(PLVErrorCodePlayVideoPlay.class, 10, new Exception("\u89c6\u9891id\u65e0\u6548, vid is " + this.videoId));
        ((PolyvPlaybackVideoViewListener)this.polyvListener).notifyOnError(PolyvPlayError.toErrorObj((String)this.getCurrentPlayPath(), (int)n, (String)PLVErrorCodePlayVideoPlay.getMessage((int)10), (int)1001));
        this.setNoStreamViewVisibility(0);
        return false;
    }

    protected boolean canMove() {
        return true;
    }

    protected void onNetWorkRecover() {
        super.onNetWorkRecover();
        this.l = this.getCurrentPosition();
        ((PolyvPlaybackVideoViewListener)this.polyvListener).notifyVideoViewRestart(true);
        this.c();
        this.g();
    }

    protected void onNetWorkError() {
        super.onNetWorkError();
        this.l = this.getCurrentPosition();
    }

    protected PolyvPlaybackVideoViewListener createListener() {
        return new PolyvPlaybackVideoViewListener();
    }

    protected Handler createHandler() {
        return null;
    }

    public void pause() {
        super.pause();
        if (this.d != null) {
            this.d.pause();
        }
    }

    public void start() {
        super.start();
        if (this.d != null) {
            this.d.restart();
        }
    }

    public void seekTo(int n) {
        super.seekTo(n);
        if (this.d != null) {
            this.d.seekTo(n);
        }
    }

    public void destroy() {
        super.destroy();
        this.c();
        this.a();
        if (this.d != null) {
            this.d.destory();
            this.d = null;
        }
    }

    public void setOnPPTShowListener(IPolyvVideoViewListenerEvent.OnPPTShowListener onPPTShowListener) {
        ((PolyvPlaybackVideoViewListener)this.polyvListener).setOnPPTShowListener(onPPTShowListener);
    }

    public void setOnVideoViewRestartListener(IPolyvVideoViewListenerEvent.OnVideoViewRestart onVideoViewRestart) {
        ((PolyvPlaybackVideoViewListener)this.polyvListener).setOnVideoViewRestartListener(onVideoViewRestart);
    }

    public void setOnGetMarqueeVoListener(IPolyvVideoViewListenerEvent.OnGetMarqueeVoListener onGetMarqueeVoListener) {
        ((PolyvPlaybackVideoViewListener)this.polyvListener).setOnGetMarqueeVoListener(onGetMarqueeVoListener);
    }

    public void setOnDanmuServerOpenListener(IPolyvVideoViewListenerEvent.OnDanmuServerOpenListener onDanmuServerOpenListener) {
        ((PolyvPlaybackVideoViewListener)this.polyvListener).setOnDanmuServerOpenListener(onDanmuServerOpenListener);
    }

    public boolean changeBitRate(int n) {
        return false;
    }

    public boolean changeLines(int n) {
        return false;
    }

    public PolyvPlaybackVO.DataBean getModleVO() {
        return this.f;
    }

    public void bindPPTView(IPolyvPPTView iPolyvPPTView) {
        if (this.d != null) {
            this.d.bindPPTView(iPolyvPPTView);
        }
    }

    public void setViewerId(String string) {
        super.setViewerId(string);
        PolyvLiveSDKClient.getInstance().setViewerId(string);
    }

    protected String getSDKVersion() {
        return PolyvLiveSDKClient.getInstance().getPolyvLiveAndroidSdk();
    }

    @Override
    public PolyvPlayType getPlayType() {
        return this.h;
    }

    private void a() {
        this.playId = "";
        this.videoId = "";
        this.channelId = "";
        this.userId = "";
        this.h = PolyvPlayType.IDLE;
        this.f = null;
        this.e = null;
        this.g = false;
        this.mCurrentBufferPercentage = 0;
        this.watchTimeDuration = 0;
        this.stayTimeDuration = 0;
        this.l = 0;
        this.i = 0L;
        this.k = false;
        this.j = false;
    }

    private void a(PolyvBaseVideoParams polyvBaseVideoParams) {
        this.userId = polyvBaseVideoParams.getUserId();
        this.videoId = polyvBaseVideoParams.getVideoId();
        this.channelId = polyvBaseVideoParams.getChannelId();
        this.playId = PLVUtils.getPid();
        this.h = PolyvPlayType.ONLINE_PLAY;
        PolyvVodSDKClient.getInstance().setPolyvLogVideoLable(new PolyvLogVideoLableVO(this.videoId, this.playId));
        try {
            this.isOpenMarquee = (Boolean)polyvBaseVideoParams.getOptionValue(Boolean.class, "marquee", (Object)false);
            this.isAllowOpenAdHead = (Boolean)polyvBaseVideoParams.getOptionValue(Boolean.class, "head_ad", (Object)false);
            this.g = (Boolean)polyvBaseVideoParams.getOptionValue(Boolean.class, "IS_PPT_PLAY", (Object)false);
            this.viewLogParam2 = (String)polyvBaseVideoParams.getOptionValue(String.class, "params2", (Object)"");
            this.viewLogParam4 = (String)polyvBaseVideoParams.getOptionValue(String.class, "params4", (Object)"");
            this.viewLogParam5 = (String)polyvBaseVideoParams.getOptionValue(String.class, "params5", (Object)"");
            boolean bl = (Boolean)polyvBaseVideoParams.getOptionValue(Boolean.class, "enable_accurate_seek", (Object)false);
            this.enableAccurateSeek(bl);
            this.m = (Integer)polyvBaseVideoParams.getOptionValue(Integer.class, "video_listtype", (Object)0);
        }
        catch (Exception exception) {
            PLVCommonLog.e((String)"PolyvBaseVideoView", (String)"param is wrong");
        }
    }

    private void b() {
        this.d.startPlay(this.channelId, this.videoId);
    }

    private void a(int n) {
        PolyvELogSender.sendPlaybackLog(PLVErrorCodePlayVideoPlay.class, 1, new Exception("\u89c6\u9891\u64ad\u653e\u5f02\u5e38, playPath is" + this.getCurrentPlayPath() + ", what is " + n + ", position is " + this.getCurrentPosition()));
    }

    private void c() {
        if (this.b != null) {
            this.b.dispose();
            this.b = null;
        }
        if (this.c != null) {
            this.c.dispose();
            this.c = null;
        }
    }

    private void d() {
        PLVPlayOption pLVPlayOption = PLVPlayOption.getDefault();
        this.setOption(pLVPlayOption);
        if (!this.prepare(pLVPlayOption.get("KEY_PRELOADTIME") != null)) {
            return;
        }
        if (!this.e()) {
            this.f();
        }
    }

    private boolean e() {
        boolean bl;
        boolean bl2 = !TextUtils.isEmpty((CharSequence)this.e.getAdvertFlvUrl());
        boolean bl3 = bl = !TextUtils.isEmpty((CharSequence)this.e.getAdvertImage());
        if (!this.isAllowOpenAdHead || this.hasOpenAdHead) {
            return false;
        }
        if (this.subVideoView != null && (bl2 || bl)) {
            String string = null;
            if (bl2) {
                string = this.e.getAdvertFlvUrl();
            }
            int n = this.e.getAdvertDuration();
            if (bl) {
                this.subVideoView.showWaittingImage(this.e.getAdvertImage(), true, this.e.getAdvertHref());
            } else {
                this.subVideoView.showWaittingImage("", false, this.e.getAdvertHref());
            }
            this.subVideoView.addAudioFocusManager(this.audioFocusManager);
            this.options.put("KEY_HEADAD", new PLVPlayOption.HeadAdOption(string, n));
            this.subVideoView.initOption(this.options);
            this.subVideoView.startHeadAd();
            this.subVideoView.setOnAuxiliaryPlayEndListener(new IPolyvAuxiliaryVideoViewListenerEvent.IPolyvOnAuxiliaryPlayEndListener(){

                public void onBeforeEnd(boolean bl) {
                    if (!PolyvPlaybackVideoView.this.isNetWorkError) {
                        PolyvPlaybackVideoView.this.hasOpenAdHead = true;
                        PolyvPlaybackVideoView.this.clear();
                        PolyvPlaybackVideoView.this.f();
                    }
                }

                public void onAfterEnd() {
                    PLVCommonLog.d((String)"PolyvBaseVideoView", (String)"onAfterEnd");
                }
            });
            return true;
        }
        return false;
    }

    private void f() {
        boolean bl = true;
        if (TextUtils.isEmpty((CharSequence)this.f.getLiveType())) {
            bl = !TextUtils.isEmpty((CharSequence)this.f.getChannelSessionId());
        } else if (!"ppt".equals(this.f.getLiveType())) {
            bl = false;
        }
        ((PolyvPlaybackVideoViewListener)this.polyvListener).notifyPPTShow(bl ? 0 : 4);
        this.startLoaderTime = System.currentTimeMillis();
        this.setPlayerBufferingViewVisibility(0);
        String string = this.f.getFileUrl();
        this.playUri = this.addPlayUriParams(string);
        this.setVideoURIFromSelf(this.playUri);
    }

    private void g() {
        long l = System.currentTimeMillis();
        String string = PolyvLiveSDKClient.getInstance().getAppId();
        String string2 = PolyvLiveSDKClient.getInstance().getAppSecret();
        String string3 = this.m == 1 ? "vod" : "playback";
        String string4 = EncryptUtils.encryptMD5ToString((String)(string2 + "appId" + string + "channelId" + this.channelId + "listType" + string3 + "timestamp" + l + "vid" + this.videoId + string2)).toUpperCase();
        this.b = PolyvApiManager.getPolyvLiveStatusApi().getPlaybackVO(string, this.channelId, this.videoId, l, string4, string3).map((Function)new Function<PolyvPlaybackVO, PolyvPlaybackVO>(){

            public PolyvPlaybackVO apply(PolyvPlaybackVO polyvPlaybackVO) throws Exception {
                PolyvJsonUtils.performTransformWithEvaluation(polyvPlaybackVO, "setData", polyvPlaybackVO.getData(), PolyvPlaybackVO.DataBean.class);
                return polyvPlaybackVO;
            }
        }).compose((ObservableTransformer)new PLVRxBaseTransformer()).subscribe((Consumer)new Consumer<PolyvPlaybackVO>(){

            public void accept(PolyvPlaybackVO polyvPlaybackVO) throws Exception {
                if (polyvPlaybackVO.getCode() != 200) {
                    int n = PolyvELogSender.sendPlaybackLog(PLVErrorCodePlayVideoInfo.class, 8, new Exception("\u56de\u653e\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25, code is " + polyvPlaybackVO.getCode()));
                    ((PolyvPlaybackVideoViewListener)PolyvPlaybackVideoView.this.polyvListener).notifyOnError(PolyvPlayError.toErrorObj((String)PolyvPlaybackVideoView.this.getCurrentPlayPath(), (int)n, (String)polyvPlaybackVO.getMessage(), (int)1001));
                    PolyvPlaybackVideoView.this.setNoStreamViewVisibility(0);
                    return;
                }
                PolyvPlaybackVideoView.this.f = (PolyvPlaybackVO.DataBean)((List)polyvPlaybackVO.getData()).get(0);
                if (PolyvPlaybackVideoView.this.f == null) {
                    PolyvPlaybackVodQOSAnalytics polyvPlaybackVodQOSAnalytics = PolyvPlaybackVodQOSAnalytics.getInstance();
                    String string = PolyvPlaybackVideoView.this.playId;
                    String string2 = PolyvPlaybackVideoView.this.videoId;
                    StringBuilder stringBuilder = new StringBuilder();
                    PolyvPlaybackVodQOSAnalytics.getInstance();
                    polyvPlaybackVodQOSAnalytics.error(string, string2, stringBuilder.append("video_type_").append("playbackVO_is_null").toString(), "", "", "", "", PolyvPlaybackVodQOSAnalytics.getInstance().getQOSAnalyticsParam(), "");
                    int n = PolyvELogSender.sendPlaybackLog(PLVErrorCodePlayVideoInfo.class, 9, new Exception("\u56de\u653e\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25, data is null"));
                    ((PolyvPlaybackVideoViewListener)PolyvPlaybackVideoView.this.polyvListener).notifyOnError(PolyvPlayError.toErrorObj((String)PolyvPlaybackVideoView.this.getCurrentPlayPath(), (int)n, (String)PLVErrorCodePlayVideoInfo.getMessage((int)9), (int)1001));
                    PolyvPlaybackVideoView.this.setNoStreamViewVisibility(0);
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)PolyvPlaybackVideoView.this.f.getFileUrl())) {
                    int n = PolyvELogSender.sendPlaybackLog(PLVErrorCodePlayVideoInfo.class, 10, new Exception("\u56de\u653e\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25, fileUrl is empty"));
                    ((PolyvPlaybackVideoViewListener)PolyvPlaybackVideoView.this.polyvListener).notifyOnError(PolyvPlayError.toErrorObj((String)PolyvPlaybackVideoView.this.getCurrentPlayPath(), (int)n, (String)PLVErrorCodePlayVideoInfo.getMessage((int)10), (int)1001));
                    PolyvPlaybackVideoView.this.setNoStreamViewVisibility(0);
                    return;
                }
                PolyvPlaybackVideoView.this.h();
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                if (null != throwable) {
                    throwable.printStackTrace();
                }
                int n = PolyvELogSender.sendPlaybackLog(PLVErrorCodePlayVideoInfo.class, 11, throwable);
                ((PolyvPlaybackVideoViewListener)PolyvPlaybackVideoView.this.polyvListener).notifyOnError(PolyvPlayError.toErrorObj((String)PolyvPlaybackVideoView.this.getCurrentPlayPath(), (int)n, (String)PolyvPlaybackVideoView.this.getErrorMessage(throwable), (int)1001));
                PolyvPlaybackVideoView.this.setNoStreamViewVisibility(0);
            }
        });
    }

    private void h() {
        this.c = PLVResponseExcutor.excute((Observable)PolyvCommonApiManager.getPolyvPlayerApi().getChannelJsonEncrypt(this.userId, this.channelId), String.class, (PLVrResponseCallback)new PLVrResponseCallback<String>(){

            public void onSuccess(String string) {
                if (PolyvPlaybackVideoView.this.a(string)) {
                    PolyvPlaybackVideoView.this.d();
                    PolyvLiveMarqueeVO polyvLiveMarqueeVO = PolyvPlaybackVideoView.this.e.generateMarqueeVo();
                    if (polyvLiveMarqueeVO == null) {
                        return;
                    }
                    ((PolyvPlaybackVideoViewListener)PolyvPlaybackVideoView.this.polyvListener).notifyGetMarqueeVo(polyvLiveMarqueeVO);
                    ((PolyvPlaybackVideoViewListener)PolyvPlaybackVideoView.this.polyvListener).notifyOnDanmuServerOpen(PolyvPlaybackVideoView.this.e.getCloseDanmuEnable().equals("N"));
                }
            }

            public void onFinish() {
                PLVCommonLog.d((String)"PolyvBaseVideoView", (String)"getChannelJsonEncrypt onFinish");
            }
        });
    }

    private boolean a(String string) {
        String string2 = PolyvLiveSDKClient.getInstance().getChannelData2String(string);
        this.e = (PolyvLiveChannelVO)PLVGsonUtil.fromJson(PolyvLiveChannelVO.class, (String)string2);
        if (this.e == null) {
            return false;
        }
        if (this.e.getReportFreq() > 0) {
            this.playStatInterval = this.e.getReportFreq();
        }
        this.notifyOnGetLogoListener(this.e.getLogoImage(), this.e.getLogoOpacity(), this.e.getLogoPosition(), this.e.getLogoHref());
        PLVCommonLog.d((String)"PolyvBaseVideoView", (String)("channle data :" + string2 + "   interval \uff1a" + this.e.getReportFreq()));
        return true;
    }
}

