/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyv.livescenes.linkmic.manager;

import android.content.Context;
import android.os.Build;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.view.SurfaceView;
import com.easefun.polyv.businesssdk.model.ppt.PolyvPPTAuthentic;
import com.easefun.polyv.livescenes.config.PolyvLiveSDKClient;
import com.easefun.polyv.livescenes.linkmic.IPolyvLinkMicManager;
import com.easefun.polyv.livescenes.linkmic.listener.PolyvLinkMicEventListener;
import com.easefun.polyv.livescenes.linkmic.listener.PolyvLinkMicListener;
import com.easefun.polyv.livescenes.linkmic.manager.PolyvLinkMicConfig;
import com.easefun.polyv.livescenes.log.PolyvElogEntityCreator;
import com.easefun.polyv.livescenes.net.PolyvApiManager;
import com.easefun.polyv.livescenes.socket.PolyvSocketWrapper;
import com.plv.foundationsdk.log.PLVCommonLog;
import com.plv.foundationsdk.log.elog.IPLVErrorCodeSender;
import com.plv.foundationsdk.log.elog.logcode.PLVErrorCodeInfoBase;
import com.plv.foundationsdk.log.elog.logcode.linkmic.PLVErrorCodeLinkMicRTC;
import com.plv.foundationsdk.log.elog.logcode.linkmic.PLVErrorCodeLinkMicRequest;
import com.plv.foundationsdk.log.elog.logcode.linkmic.PLVErrorCodeLinkMicSystemError;
import com.plv.foundationsdk.model.log.PLVLogFileBase;
import com.plv.foundationsdk.model.log.PLVStatisticsBase;
import com.plv.foundationsdk.net.PLVResponseBean;
import com.plv.foundationsdk.net.PLVResponseExcutor;
import com.plv.foundationsdk.net.PLVrResponseCallback;
import com.plv.foundationsdk.sign.PLVSignCreator;
import com.plv.foundationsdk.utils.PLVGsonUtil;
import com.plv.linkmic.PLVLinkMicEventHandler;
import com.plv.linkmic.PLVLinkMicWrapper;
import com.plv.linkmic.log.IPLVLinkMicErrorCodeSender;
import com.plv.linkmic.log.IPLVLinkMicTraceLogSender;
import com.plv.linkmic.model.PLVLinkMicJoinStatus;
import com.plv.linkmic.model.PLVLinkMicJoinSuccess;
import com.plv.linkmic.model.PLVLinkMicMedia;
import com.plv.linkmic.model.PLVLinkMicTokenStatisticsInfo;
import com.plv.linkmic.repository.PLVLinkMicDataRepository;
import com.plv.linkmic.repository.PLVLinkMicEngineToken;
import com.plv.linkmic.repository.PLVLinkMicHttpRequestException;
import com.plv.socket.event.linkmic.PLVJoinLeaveSEvent;
import com.plv.socket.event.linkmic.PLVLinkMicTokenEvent;
import com.plv.socket.impl.PLVSocketMessageObserver;
import com.plv.socket.socketio.PLVSocketIOClient;
import com.plv.thirdpart.blankj.utilcode.util.EncryptUtils;
import com.plv.thirdpart.blankj.utilcode.util.NetworkUtils;
import com.plv.thirdpart.blankj.utilcode.util.ScreenUtils;
import com.plv.thirdpart.blankj.utilcode.util.Utils;
import io.socket.client.Ack;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PolyvLinkMicManager
implements IPolyvLinkMicManager {
    private static final String TAG = PolyvLinkMicManager.class.getSimpleName();
    public static final String CHANNEL_ID = "channelId";
    public static final String VIEWER_ID = "viewerId";
    public static final String UID = "uid";
    public static final String APP_ID = "appId";
    public static final String TIMESTAMP = "timestamp";
    public static final String ROOM_ID = "roomId";
    public static final String NICK = "nick";
    public static final String PIC = "pic";
    public static final String USER_ID = "userId";
    public static final String USER_TYPE = "userType";
    public static final String USER = "user";
    public static final String STATUS = "status";
    public static final String SESSION_ID = "sessionId";
    public static final String EMIT_MODE = "emitMode";
    public static final String POLYV_CHAT_SIGN = "polyvChatSign";
    public static final String TYPE = "type";
    public static final String EVENT = "EVENT";
    private int channelId;
    private String linkMicUid;
    private PolyvLinkMicListener linkMicListener;
    private PLVLinkMicDataRepository linkMicDataRepository;
    private PLVLinkMicWrapper coreLinkMicWrapper;
    private PLVSocketMessageObserver.OnMessageListener socketMsgListener;
    private PLVLinkMicTokenEvent joinSuccessToken;
    private IPLVLinkMicErrorCodeSender errorCodeManager;
    private IPLVLinkMicTraceLogSender traceLogSender;

    PolyvLinkMicManager(IPLVLinkMicErrorCodeSender iPLVLinkMicErrorCodeSender, IPLVLinkMicTraceLogSender iPLVLinkMicTraceLogSender, PLVLinkMicDataRepository pLVLinkMicDataRepository) {
        this.errorCodeManager = iPLVLinkMicErrorCodeSender;
        this.errorCodeManager.setElogVOCreator(new IPLVErrorCodeSender.ELogVOCreator(){

            public <T extends PLVErrorCodeInfoBase> PLVStatisticsBase createElogVO(Class<T> clazz, int n, String string, PLVLogFileBase pLVLogFileBase) {
                return PolyvElogEntityCreator.createLiveEntity(clazz, n, string, pLVLogFileBase, "");
            }
        });
        this.traceLogSender = iPLVLinkMicTraceLogSender;
        this.linkMicDataRepository = pLVLinkMicDataRepository;
        this.coreLinkMicWrapper = new PLVLinkMicWrapper();
    }

    @Override
    public void initEngine(final int n, PolyvLinkMicListener polyvLinkMicListener) {
        this.channelId = n;
        this.linkMicListener = polyvLinkMicListener;
        String string = PolyvLinkMicConfig.getInstance().getRtcType();
        this.linkMicDataRepository.setRTCType(string);
        this.linkMicUid = PolyvLinkMicConfig.getInstance().getLinkMicUid();
        final PLVLinkMicTokenStatisticsInfo pLVLinkMicTokenStatisticsInfo = this.createTokenStatisticsInfo();
        this.coreLinkMicWrapper.init(this.linkMicUid, (Context)Utils.getApp(), string, new PLVLinkMicWrapper.IPLVTokenRequester(){

            public void requestToken(final PLVLinkMicWrapper.IPLVTokenRequester.OnRequestTokenListener onRequestTokenListener) {
                PolyvLinkMicManager.this.linkMicDataRepository.requestToken(n + "", PolyvLiveSDKClient.getInstance().getAppId(), PolyvLiveSDKClient.getInstance().getAppSecret(), PolyvLinkMicManager.this.linkMicUid, pLVLinkMicTokenStatisticsInfo, (PLVLinkMicDataRepository.IPLVLinkMicDataRepoListener)new PLVLinkMicDataRepository.IPLVLinkMicDataRepoListener<PLVLinkMicEngineToken>(){

                    public void onSuccess(PLVLinkMicEngineToken pLVLinkMicEngineToken) {
                        onRequestTokenListener.onSuccess(pLVLinkMicEngineToken);
                    }

                    public void onFail(PLVLinkMicHttpRequestException pLVLinkMicHttpRequestException) {
                        onRequestTokenListener.onFail((Throwable)pLVLinkMicHttpRequestException);
                        PolyvLinkMicManager.this.notifyRequestErrorCode(pLVLinkMicHttpRequestException.getErrorCode(), pLVLinkMicHttpRequestException.getMessage(), (Throwable)pLVLinkMicHttpRequestException);
                    }
                });
            }
        }, new PLVLinkMicWrapper.IPLVLinkMicWrapperCallback(){

            public void onPermissionDenied(Throwable throwable) {
                IPLVErrorCodeSender.SubmitResult submitResult = PolyvLinkMicManager.this.errorCodeManager.submitError(PLVErrorCodeLinkMicSystemError.class, 1, "", throwable);
                if (PolyvLinkMicManager.this.linkMicListener != null) {
                    PolyvLinkMicManager.this.linkMicListener.onLinkMicError(submitResult.getIntactErrorCode(), new Throwable(submitResult.getCounterPartMsgOfCode(), throwable));
                }
            }

            public void onLinkMicEngineCreateFailed(Throwable throwable) {
                PolyvLinkMicManager.this.notifyLinkMicErrorCode(4, "", throwable);
            }

            public void onLinkMicEngineCreated(String string) {
                PolyvSocketWrapper.getInstance().getSocketObserver().addOnMessageListener(new PLVSocketMessageObserver.OnMessageListener(){

                    public void onMessage(String string, String string2, String string3) {
                        if ("joinResponse".equals(string)) {
                            String string4 = PLVSocketIOClient.getInstance().getSocketUserId();
                            String string5 = PolyvLinkMicManager.this.linkMicUid;
                            String string6 = PolyvLiveSDKClient.getInstance().getAppId();
                            long l = System.currentTimeMillis();
                            ArrayMap arrayMap = new ArrayMap();
                            arrayMap.put(PolyvLinkMicManager.CHANNEL_ID, n + "");
                            arrayMap.put(PolyvLinkMicManager.VIEWER_ID, string4);
                            arrayMap.put(PolyvLinkMicManager.UID, string5 + "");
                            arrayMap.put(PolyvLinkMicManager.APP_ID, string6);
                            arrayMap.put(PolyvLinkMicManager.TIMESTAMP, l + "");
                            String string7 = PLVSignCreator.createSign((String)PolyvLiveSDKClient.getInstance().getAppSecret(), (Map)arrayMap);
                            PLVResponseExcutor.excuteDataBean(PolyvApiManager.getPolyvLiveStatusApi().setLinkMicIdRelation(n, string4, string5 + "", string6, l, string7), String.class, (PLVrResponseCallback)new PLVrResponseCallback<String>(){

                                public void onSuccess(String string) {
                                    PLVCommonLog.d((String)TAG, (String)"record viewerId and linkMicId to server succeed");
                                }

                                public void onFailure(PLVResponseBean<String> pLVResponseBean) {
                                    super.onFailure(pLVResponseBean);
                                    PLVCommonLog.exception((Throwable)new Throwable(pLVResponseBean.toString()));
                                }

                                public void onError(Throwable throwable) {
                                    super.onError(throwable);
                                    PLVCommonLog.exception((Throwable)throwable);
                                }

                                public void onFinish() {
                                }
                            });
                        }
                    }
                });
                if (PolyvLinkMicManager.this.linkMicListener != null) {
                    PolyvLinkMicManager.this.linkMicListener.onLinkMicEngineCreatedSuccess();
                }
                PolyvLinkMicManager.this.coreLinkMicWrapper.setBitrate(10);
            }

            public void onJoinChannelError(String string) {
                PolyvLinkMicManager.this.notifyLinkMicErrorCode(2, "", new Throwable(string));
            }
        });
        this.socketMsgListener = new PLVSocketMessageObserver.OnMessageListener(){

            public void onMessage(String string, String string2, String string3) {
                if ("LOGIN".equals(string2)) {
                    PolyvLinkMicManager.this.sendRejoinLinkMicMsg();
                }
            }
        };
        PolyvSocketWrapper.getInstance().getSocketObserver().addOnMessageListener(this.socketMsgListener);
    }

    private PLVLinkMicTokenStatisticsInfo createTokenStatisticsInfo() {
        PLVSocketIOClient pLVSocketIOClient = PLVSocketIOClient.getInstance();
        PLVLinkMicTokenStatisticsInfo pLVLinkMicTokenStatisticsInfo = new PLVLinkMicTokenStatisticsInfo();
        pLVLinkMicTokenStatisticsInfo.setUid(this.linkMicUid);
        pLVLinkMicTokenStatisticsInfo.setChannelId(this.channelId + "");
        pLVLinkMicTokenStatisticsInfo.setScene(PolyvLinkMicConfig.getInstance().getLiveChannelType().getValue());
        pLVLinkMicTokenStatisticsInfo.setUserType(pLVSocketIOClient.getUserType());
        pLVLinkMicTokenStatisticsInfo.setViewerId(pLVSocketIOClient.getSocketUserId());
        pLVLinkMicTokenStatisticsInfo.setNickname(pLVSocketIOClient.getNickName());
        pLVLinkMicTokenStatisticsInfo.setClient("Android SDK");
        pLVLinkMicTokenStatisticsInfo.setClientVersion("1.2.2.2");
        pLVLinkMicTokenStatisticsInfo.setClientTs(System.currentTimeMillis() + "");
        pLVLinkMicTokenStatisticsInfo.setSessionId(PolyvLinkMicConfig.getInstance().getSessionId());
        pLVLinkMicTokenStatisticsInfo.setDeviceType("phone");
        pLVLinkMicTokenStatisticsInfo.setModel(Build.MODEL + "");
        pLVLinkMicTokenStatisticsInfo.setOs("Android");
        pLVLinkMicTokenStatisticsInfo.setOsVersion(Build.VERSION.SDK_INT + "");
        pLVLinkMicTokenStatisticsInfo.setNetworkType(NetworkUtils.isWifiConnected() ? "Wifi" : "4G");
        pLVLinkMicTokenStatisticsInfo.setScreenWidth(ScreenUtils.getScreenWidth() + "");
        pLVLinkMicTokenStatisticsInfo.setScreenHeight(ScreenUtils.getScreenHeight() + "");
        return pLVLinkMicTokenStatisticsInfo;
    }

    @Override
    public void muteLocalVideo(boolean bl) {
        this.coreLinkMicWrapper.muteLocalVideo(bl);
    }

    @Override
    public void switchRoleToAudience() {
        this.coreLinkMicWrapper.switchRoleToAudience();
    }

    @Override
    public void muteLocalAudio(boolean bl) {
        this.coreLinkMicWrapper.muteLocalAudio(bl);
    }

    @Override
    public void muteRemoteVideo(String string, boolean bl) {
        this.coreLinkMicWrapper.muteRemoteVideo(string, bl);
    }

    @Override
    public void muteRemoteAudio(String string, boolean bl) {
        this.coreLinkMicWrapper.muteRemoteAudio(string, bl);
    }

    @Override
    public void getLinkStatus(String string, final PLVLinkMicDataRepository.IPLVLinkMicDataRepoListener<PLVLinkMicJoinStatus> iPLVLinkMicDataRepoListener) {
        this.linkMicDataRepository.getInteractStatus(this.channelId + "", string, true, (PLVLinkMicDataRepository.IPLVLinkMicDataRepoListener)new PLVLinkMicDataRepository.IPLVLinkMicDataRepoListener<PLVLinkMicJoinStatus>(){

            public void onSuccess(PLVLinkMicJoinStatus pLVLinkMicJoinStatus) {
                iPLVLinkMicDataRepoListener.onSuccess((Object)pLVLinkMicJoinStatus);
            }

            public void onFail(PLVLinkMicHttpRequestException pLVLinkMicHttpRequestException) {
                iPLVLinkMicDataRepoListener.onFail(pLVLinkMicHttpRequestException);
                PolyvLinkMicManager.this.notifyRequestErrorCode(pLVLinkMicHttpRequestException.getErrorCode(), pLVLinkMicHttpRequestException.getMessage(), (Throwable)pLVLinkMicHttpRequestException);
            }

            public void onFinish() {
                iPLVLinkMicDataRepoListener.onFinish();
            }
        });
    }

    @Override
    public void joinChannel() {
        this.traceLogSender.submitTraceLog("joinChannel", "\u52a0\u5165\u9891\u9053");
        this.coreLinkMicWrapper.joinChannel(this.channelId + "");
    }

    @Override
    public void switchRoleToBroadcaster() {
        this.coreLinkMicWrapper.switchRoleToBroadcaster();
    }

    @Override
    public void enableLocalVideo(boolean bl) {
        this.coreLinkMicWrapper.enableLocalVideo(bl);
    }

    @Override
    public void leaveChannel() {
        this.traceLogSender.submitTraceLog("leaveChannel", "\u79bb\u5f00\u9891\u9053");
        this.coreLinkMicWrapper.leaveChannel();
    }

    @Override
    public String getLinkMicUid() {
        if (TextUtils.isEmpty((CharSequence)this.linkMicUid)) {
            this.linkMicUid = PolyvLinkMicConfig.getInstance().getLinkMicUid();
        }
        if (TextUtils.isEmpty((CharSequence)this.linkMicUid)) {
            this.linkMicListener.onLinkMicError(266, new RuntimeException("get empty linkMicID"));
        }
        return this.linkMicUid;
    }

    @Override
    public void setupLocalVideo(SurfaceView surfaceView, String string) {
        this.coreLinkMicWrapper.setupLocalVideo(surfaceView, 1, string);
    }

    @Override
    public void setupRemoteVideo(SurfaceView surfaceView, String string) {
        this.coreLinkMicWrapper.setupRemoteVideo(surfaceView, 2, string);
    }

    @Override
    public void releaseRenderView(SurfaceView surfaceView) {
        this.coreLinkMicWrapper.releaseRenderView(surfaceView);
    }

    @Override
    public SurfaceView createRendererView(Context context) {
        return this.coreLinkMicWrapper.createRendererView(context);
    }

    @Override
    public void switchCamera() {
        this.traceLogSender.submitTraceLog("switchCamera", "\u5207\u6362\u6444\u50cf\u5934");
        this.coreLinkMicWrapper.switchCamera();
    }

    @Override
    public void addEventHandler(PolyvLinkMicEventListener polyvLinkMicEventListener) {
        this.coreLinkMicWrapper.addEventHandler((PLVLinkMicEventHandler)polyvLinkMicEventListener);
    }

    @Override
    public void removeEventHandler(PolyvLinkMicEventListener polyvLinkMicEventListener) {
        this.coreLinkMicWrapper.removeEventHandler((PLVLinkMicEventHandler)polyvLinkMicEventListener);
    }

    @Override
    public void destroy() {
        this.linkMicUid = "";
        this.channelId = 0;
        this.joinSuccessToken = null;
        this.leaveChannel();
        this.linkMicDataRepository.release();
        if (this.socketMsgListener != null) {
            PolyvSocketWrapper.getInstance().getSocketObserver().removeOnMessageListener(this.socketMsgListener);
            this.socketMsgListener = null;
        }
        this.coreLinkMicWrapper.destroy();
        this.linkMicListener = null;
    }

    @Override
    public PLVLinkMicJoinSuccess sendJoinSuccessMsg(String string) {
        PLVLinkMicJoinSuccess pLVLinkMicJoinSuccess = new PLVLinkMicJoinSuccess();
        pLVLinkMicJoinSuccess.setRoomId(PolyvSocketWrapper.getInstance().getLoginVO().getChannelId());
        pLVLinkMicJoinSuccess.setSessionId(string);
        PLVLinkMicJoinSuccess.UserBean userBean = new PLVLinkMicJoinSuccess.UserBean();
        userBean.setNick(PolyvSocketWrapper.getInstance().getLoginVO().getNickName());
        userBean.setPic(PolyvSocketWrapper.getInstance().getLoginVO().getAvatarUrl());
        userBean.setUserId(this.linkMicUid);
        userBean.setUserType(PolyvSocketWrapper.getInstance().getLoginVO().getUserType());
        pLVLinkMicJoinSuccess.setUser(userBean);
        PolyvSocketWrapper.getInstance().emit("joinSuccess", new Object[]{PLVGsonUtil.toJson((Object)pLVLinkMicJoinSuccess), new Ack(){

            public void call(Object ... objectArray) {
                PLVCommonLog.d((String)TAG, (String)("SE_JOIN_SUCCESS:" + objectArray));
                String string = objectArray[0].toString();
                PolyvLinkMicManager.this.joinSuccessToken = (PLVLinkMicTokenEvent)PLVGsonUtil.fromJson(PLVLinkMicTokenEvent.class, (String)string);
                if (PolyvLinkMicManager.this.joinSuccessToken == null) {
                    PLVCommonLog.exception((Throwable)new Exception("get invalid join token=" + string));
                }
            }
        }});
        return pLVLinkMicJoinSuccess;
    }

    @Override
    public void sendJoinRequestMsg() {
        PLVCommonLog.d((String)TAG, (String)("uid :" + this.linkMicUid));
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject.put(ROOM_ID, (Object)PolyvSocketWrapper.getInstance().getLoginVO().getChannelId());
            jSONObject2.put(NICK, (Object)PolyvSocketWrapper.getInstance().getLoginVO().getNickName());
            jSONObject2.put(PIC, (Object)PolyvSocketWrapper.getInstance().getLoginVO().getAvatarUrl());
            jSONObject2.put(USER_ID, (Object)this.linkMicUid);
            jSONObject2.put(USER_TYPE, (Object)PolyvSocketWrapper.getInstance().getLoginVO().getUserType());
            jSONObject.put(USER, (Object)jSONObject2);
        }
        catch (JSONException jSONException) {
            PLVCommonLog.exception((Throwable)jSONException);
            return;
        }
        PolyvSocketWrapper.getInstance().emit("joinRequest", new Object[]{jSONObject.toString()});
    }

    @Override
    public void sendJoinLeaveMsg(String string) {
        if (TextUtils.isEmpty((CharSequence)this.linkMicUid)) {
            return;
        }
        PLVJoinLeaveSEvent.UserBean userBean = new PLVJoinLeaveSEvent.UserBean();
        userBean.setNick(PolyvSocketWrapper.getInstance().getLoginVO().getNickName());
        userBean.setPic(PolyvSocketWrapper.getInstance().getLoginVO().getAvatarUrl());
        userBean.setUserId(this.linkMicUid);
        userBean.setUserType(PolyvSocketWrapper.getInstance().getLoginVO().getUserType());
        PLVJoinLeaveSEvent pLVJoinLeaveSEvent = new PLVJoinLeaveSEvent();
        pLVJoinLeaveSEvent.setUser(userBean);
        pLVJoinLeaveSEvent.setRoomId(PolyvSocketWrapper.getInstance().getLoginVO().getChannelId());
        if (this.joinSuccessToken != null) {
            pLVJoinLeaveSEvent.setToken(this.joinSuccessToken.getToken());
            this.joinSuccessToken = null;
        }
        PolyvSocketWrapper.getInstance().emit("joinLeave", new Object[]{PLVGsonUtil.toJson((Object)pLVJoinLeaveSEvent)});
        PolyvPPTAuthentic polyvPPTAuthentic = new PolyvPPTAuthentic();
        polyvPPTAuthentic.setEVENT("TEACHER_SET_PERMISSION");
        polyvPPTAuthentic.setEmitMode(2);
        polyvPPTAuthentic.setRoomId(PolyvSocketWrapper.getInstance().getLoginVO().getChannelId());
        polyvPPTAuthentic.setSessionId(string);
        polyvPPTAuthentic.setStatus("0");
        polyvPPTAuthentic.setType("voice");
        polyvPPTAuthentic.setUserId(this.linkMicUid);
        polyvPPTAuthentic.setSign(EncryptUtils.encryptMD5ToString((String)("polyvChatSignEVENTTEACHER_SET_PERMISSIONemitMode2roomId" + PolyvSocketWrapper.getInstance().getLoginVO().getChannelId() + SESSION_ID + string + STATUS + "0" + TYPE + "voice" + USER_ID + this.linkMicUid + POLYV_CHAT_SIGN)).toUpperCase());
        PolyvSocketWrapper.getInstance().emit("message", new Object[]{PLVGsonUtil.toJson((Object)polyvPPTAuthentic)});
    }

    @Override
    public boolean sendMuteEventMsg(PLVLinkMicMedia pLVLinkMicMedia) {
        pLVLinkMicMedia.setSocketId(PolyvSocketWrapper.getInstance().getSocketId());
        PolyvSocketWrapper.getInstance().emit("message", new Object[]{pLVLinkMicMedia});
        return true;
    }

    private void sendRejoinLinkMicMsg() {
        if (this.joinSuccessToken != null) {
            PolyvSocketWrapper.getInstance().emit("reJoinMic", new Object[]{this.joinSuccessToken.getToken()});
        }
    }

    private void notifyRequestErrorCode(int n, String string, Throwable throwable) {
        IPLVErrorCodeSender.SubmitResult submitResult = this.errorCodeManager.submitError(PLVErrorCodeLinkMicRequest.class, n, string, throwable);
        if (this.linkMicListener != null) {
            this.linkMicListener.onLinkMicError(submitResult.getIntactErrorCode(), new Throwable(submitResult.getCounterPartMsgOfCode(), throwable));
        }
    }

    private void notifyLinkMicErrorCode(int n, String string, Throwable throwable) {
        IPLVErrorCodeSender.SubmitResult submitResult = this.errorCodeManager.submitError(PLVErrorCodeLinkMicRTC.class, n, string, throwable);
        if (this.linkMicListener != null) {
            this.linkMicListener.onLinkMicError(submitResult.getIntactErrorCode(), new Throwable(submitResult.getCounterPartMsgOfCode(), throwable));
        }
    }
}

