/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyv.livescenes.linkmic.manager;

import android.text.TextUtils;
import com.easefun.polyv.livescenes.config.PolyvLiveChannelType;
import com.easefun.polyv.livescenes.config.PolyvLiveSDKClient;
import com.plv.foundationsdk.log.PLVCommonLog;
import com.plv.socket.socketio.PLVSocketIOClient;

public class PolyvLinkMicConfig {
    private static final String TAG = PolyvLinkMicConfig.class.getSimpleName();
    private String linkMicUid;
    private String rtcType;
    private PolyvLiveChannelType liveChannelType;
    private String sessionId = "";
    private boolean pureRtcOnlySubscribeMainScreenVideo = true;
    private boolean pureRtcWatchEnabled = false;
    private static volatile PolyvLinkMicConfig instance;

    private PolyvLinkMicConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PolyvLinkMicConfig getInstance() {
        if (instance != null) return instance;
        Class<PolyvLiveSDKClient> clazz = PolyvLiveSDKClient.class;
        synchronized (PolyvLiveSDKClient.class) {
            if (instance != null) return instance;
            instance = new PolyvLinkMicConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(String string, boolean bl) {
        if (this.rtcType == null) {
            PLVCommonLog.exception((Throwable)new Throwable("rtcType is null"));
            return;
        }
        if (bl) {
            this.linkMicUid = string;
            return;
        }
        switch (this.rtcType) {
            case "urtc": 
            case "zego": {
                this.linkMicUid = string;
                break;
            }
            case "agora": {
                this.linkMicUid = Math.abs((int)System.currentTimeMillis()) + "";
                break;
            }
            default: {
                PLVCommonLog.exception((Throwable)new Throwable("rtcType is empty"));
            }
        }
        PLVSocketIOClient.getInstance().setMicId(this.linkMicUid);
    }

    public void clear() {
        this.linkMicUid = "";
        this.rtcType = "";
    }

    public PolyvLinkMicConfig setRtcType(String string) {
        this.rtcType = string;
        return this;
    }

    String getLinkMicUid() {
        if (TextUtils.isEmpty((CharSequence)this.linkMicUid)) {
            PLVCommonLog.e((String)TAG, (String)"\u83b7\u53d6\u4e86null \u7684\u8fde\u9ea6ID");
        }
        return this.linkMicUid;
    }

    String getRtcType() {
        return this.rtcType;
    }

    public PolyvLinkMicConfig setLiveChannelType(PolyvLiveChannelType polyvLiveChannelType) {
        this.liveChannelType = polyvLiveChannelType;
        return this;
    }

    public PolyvLiveChannelType getLiveChannelType() {
        return this.liveChannelType;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isPureRtcOnlySubscribeMainScreenVideo() {
        return this.pureRtcOnlySubscribeMainScreenVideo;
    }

    public PolyvLinkMicConfig setPureRtcOnlySubscribeMainScreenVideo(boolean bl) {
        this.pureRtcOnlySubscribeMainScreenVideo = bl;
        return this;
    }

    public boolean isPureRtcWatchEnabled() {
        return this.pureRtcWatchEnabled;
    }

    public PolyvLinkMicConfig setPureRtcWatchEnabled(boolean bl) {
        this.pureRtcWatchEnabled = bl;
        return this;
    }
}

