/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyv.livescenes.feature.point_reward;

import com.easefun.polyv.livescenes.config.PolyvLiveSDKClient;
import com.easefun.polyv.livescenes.feature.point_reward.IPolyvPointRewardManager;
import com.easefun.polyv.livescenes.model.pointreward.PolyvPointRewardSettingVO;
import com.easefun.polyv.livescenes.net.PolyvApiManager;
import com.plv.foundationsdk.log.PLVCommonLog;
import com.plv.foundationsdk.net.PLVResponseApiBean;
import com.plv.foundationsdk.net.PLVResponseBean;
import com.plv.foundationsdk.net.PLVResponseExcutor;
import com.plv.foundationsdk.net.PLVrResponseCallback;
import com.plv.foundationsdk.sign.PLVSignCreator;
import com.plv.foundationsdk.utils.PLVFormatUtils;
import com.plv.foundationsdk.utils.PLVGsonUtil;
import io.reactivex.disposables.Disposable;
import java.io.IOException;
import java.util.HashMap;
import retrofit2.HttpException;

public class PolyvPointRewardManager
implements IPolyvPointRewardManager {
    private static final String TAG = "PLVPointRewardDataSourc";
    private static final String APP_ID = "appId";
    private static final String TIMESTAMP = "timestamp";
    private static final String CHANNEL_ID = "channelId";
    private static final String VIEWER_ID = "viewerId";
    private static final String GOOD_ID = "goodId";
    private static final String GOOD_NUM = "goodNum";
    private static final String NICKNAME = "nickname";
    private static final String AVATAR = "avatar";
    private Disposable getPointRewardSettingDisposable;
    private Disposable makeRewardDisposable;
    private Disposable getRemainingRewardPointDisposable;

    @Override
    public void getPointRewardSetting(String string, final IPolyvPointRewardManager.IPointRewardListener<PolyvPointRewardSettingVO> iPointRewardListener) {
        this.dispose(this.getPointRewardSettingDisposable);
        String string2 = PolyvLiveSDKClient.getInstance().getAppId();
        String string3 = PolyvLiveSDKClient.getInstance().getAppSecret();
        long l = System.currentTimeMillis();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(APP_ID, string2);
        hashMap.put(TIMESTAMP, String.valueOf(l));
        hashMap.put(CHANNEL_ID, string);
        String string4 = PLVSignCreator.createSign((String)string3, hashMap);
        this.getPointRewardSettingDisposable = PLVResponseExcutor.excuteDataBean(PolyvApiManager.getPolyvLiveStatusApi().getPointRewardSetting(string2, String.valueOf(l), string4, string), PolyvPointRewardSettingVO.class, (PLVrResponseCallback)new PLVrResponseCallback<PolyvPointRewardSettingVO>(){

            public void onSuccess(PolyvPointRewardSettingVO polyvPointRewardSettingVO) {
                iPointRewardListener.onSuccess(polyvPointRewardSettingVO);
            }

            public void onFailure(PLVResponseBean<PolyvPointRewardSettingVO> pLVResponseBean) {
                super.onFailure(pLVResponseBean);
                iPointRewardListener.onFailed(new Throwable(pLVResponseBean.getMessage()));
            }

            public void onError(Throwable throwable) {
                super.onError(throwable);
                iPointRewardListener.onFailed(throwable);
            }

            public void onFinish() {
                PLVCommonLog.d((String)PolyvPointRewardManager.TAG, (String)"getPointRewardSetting onFinish");
            }
        });
    }

    @Override
    public void makeReward(String string, int n, int n2, String string2, String string3, String string4, final IPolyvPointRewardManager.IPointRewardListener<Integer> iPointRewardListener) {
        String string5 = PolyvLiveSDKClient.getInstance().getAppId();
        String string6 = PolyvLiveSDKClient.getInstance().getAppSecret();
        long l = System.currentTimeMillis();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(CHANNEL_ID, string);
        hashMap.put(APP_ID, string5);
        hashMap.put(TIMESTAMP, String.valueOf(l));
        hashMap.put(VIEWER_ID, string2);
        hashMap.put(GOOD_ID, String.valueOf(n));
        hashMap.put(GOOD_NUM, String.valueOf(n2));
        hashMap.put(NICKNAME, String.valueOf(string3));
        hashMap.put(AVATAR, string4);
        String string7 = PLVSignCreator.createSign((String)string6, hashMap);
        this.dispose(this.makeRewardDisposable);
        this.makeRewardDisposable = PLVResponseExcutor.excuteDataBean(PolyvApiManager.getPolyvLiveStatusApi().pointReward(PLVFormatUtils.parseInt((String)string), string5, l, string7, string2, n, n2, string3, string4), Integer.class, (PLVrResponseCallback)new PLVrResponseCallback<Integer>(){

            public void onSuccess(Integer n) {
                iPointRewardListener.onSuccess(n);
            }

            public void onFailure(PLVResponseBean<Integer> pLVResponseBean) {
                super.onFailure(pLVResponseBean);
                iPointRewardListener.onFailed(new Throwable(pLVResponseBean.getMessage()));
            }

            public void onError(Throwable throwable) {
                super.onError(throwable);
                if (throwable instanceof HttpException) {
                    iPointRewardListener.onFailed(new Throwable(PolyvPointRewardManager.this.getErrorMsg((HttpException)throwable)));
                    return;
                }
                iPointRewardListener.onFailed(throwable);
            }

            public void onFinish() {
                PLVCommonLog.d((String)PolyvPointRewardManager.TAG, (String)"pointReward onFinish");
            }
        });
    }

    @Override
    public void getRemainingRewardPoint(String string, String string2, String string3, final IPolyvPointRewardManager.IPointRewardListener<Integer> iPointRewardListener) {
        String string4 = PolyvLiveSDKClient.getInstance().getAppId();
        long l = System.currentTimeMillis();
        String string5 = PolyvLiveSDKClient.getInstance().getAppSecret();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(CHANNEL_ID, string);
        hashMap.put(APP_ID, string4);
        hashMap.put(TIMESTAMP, String.valueOf(l));
        hashMap.put(VIEWER_ID, string2);
        hashMap.put(NICKNAME, string3);
        String string6 = PLVSignCreator.createSign((String)string5, hashMap);
        this.dispose(this.getRemainingRewardPointDisposable);
        this.getRemainingRewardPointDisposable = PLVResponseExcutor.excuteDataBean(PolyvApiManager.getPolyvLiveStatusApi().getRewardPoint(PLVFormatUtils.parseInt((String)string), string4, l, string6, string2, string3), Integer.class, (PLVrResponseCallback)new PLVrResponseCallback<Integer>(){

            public void onSuccess(Integer n) {
                iPointRewardListener.onSuccess(n);
            }

            public void onFailure(PLVResponseBean<Integer> pLVResponseBean) {
                super.onFailure(pLVResponseBean);
                iPointRewardListener.onFailed(new Throwable(pLVResponseBean.getMessage()));
            }

            public void onError(Throwable throwable) {
                super.onError(throwable);
                if (throwable instanceof HttpException) {
                    iPointRewardListener.onFailed(new Throwable(PolyvPointRewardManager.this.getErrorMsg((HttpException)throwable)));
                    return;
                }
                iPointRewardListener.onFailed(throwable);
            }

            public void onFinish() {
                PLVCommonLog.d((String)PolyvPointRewardManager.TAG, (String)"getRewardPoint onFinish");
            }
        });
    }

    private String getErrorMsg(HttpException httpException) {
        try {
            if (httpException.response().errorBody() == null) {
                return "";
            }
            String string = httpException.response().errorBody().string();
            PLVResponseApiBean pLVResponseApiBean = (PLVResponseApiBean)PLVGsonUtil.fromJson(PLVResponseApiBean.class, (String)string);
            if (pLVResponseApiBean == null) {
                return "";
            }
            return pLVResponseApiBean.getMessage();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "\u9519\u8bef\u6d88\u606f\u89e3\u6790\u9519\u8bef";
        }
    }

    @Override
    public void destroy() {
        this.dispose(this.makeRewardDisposable);
        this.dispose(this.getRemainingRewardPointDisposable);
        this.dispose(this.getPointRewardSettingDisposable);
    }

    private void dispose(Disposable disposable) {
        if (disposable != null) {
            disposable.dispose();
        }
    }
}

