/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyv.livescenes.feature.login;

import com.easefun.polyv.businesssdk.PolyvChatDomainManager;
import com.easefun.polyv.businesssdk.model.chat.PolyvChatDomain;
import com.easefun.polyv.businesssdk.model.video.PolyvPlayBackVO;
import com.easefun.polyv.businesssdk.service.PolyvLoginManager;
import com.easefun.polyv.livescenes.chatroom.PolyvChatApiRequestHelper;
import com.easefun.polyv.livescenes.config.PolyvLiveChannelType;
import com.easefun.polyv.livescenes.config.PolyvLiveSDKClient;
import com.easefun.polyv.livescenes.config.PolyvLiveStatusType;
import com.easefun.polyv.livescenes.feature.login.IPLVSceneLoginManager;
import com.easefun.polyv.livescenes.feature.login.PolyvLiveLoginResult;
import com.easefun.polyv.livescenes.feature.login.PolyvPlaybackLoginResult;
import com.easefun.polyv.livescenes.linkmic.manager.PolyvLinkMicConfig;
import com.easefun.polyv.livescenes.log.PLVELogRequestManager;
import com.easefun.polyv.livescenes.model.PolyvLiveClassDetailVO;
import com.easefun.polyv.livescenes.model.PolyvLiveStatusVO;
import com.easefun.polyv.livescenes.net.PolyvApiManager;
import com.plv.foundationsdk.log.elog.IPLVStaticELogs;
import com.plv.foundationsdk.log.elog.PLVELogsService;
import com.plv.foundationsdk.model.domain.PLVChatDomain;
import com.plv.foundationsdk.net.PLVResponseBean;
import com.plv.foundationsdk.net.PLVResponseExcutor;
import com.plv.foundationsdk.net.PLVrResponseCallback;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function3;

public class PLVSceneLoginManager
implements IPLVSceneLoginManager {
    private Disposable loginLiveDisposable;
    private Disposable loginPlaybackDisposable;

    @Override
    public void loginLive(final String string, final String string2, final String string3, final String string4, final IPLVSceneLoginManager.OnLoginListener<PolyvLiveLoginResult> onLoginListener) {
        this.dispose(this.loginLiveDisposable);
        this.loginLiveDisposable = Observable.zip(this.verify(string3, string2, string4, "", string), this.requestLiveStatus(string4), this.requestLiveDetail(string4, string, string2), (Function3)new Function3<PolyvChatDomain, PolyvLiveStatusVO, PolyvLiveClassDetailVO, PolyvLiveLoginResult>(){

            public PolyvLiveLoginResult apply(PolyvChatDomain polyvChatDomain, PolyvLiveStatusVO polyvLiveStatusVO, PolyvLiveClassDetailVO polyvLiveClassDetailVO) throws Exception {
                PolyvLiveSDKClient.getInstance().setAppIdSecret(string3, string, string2);
                PolyvLiveSDKClient.getInstance().setChannelId(string4);
                PolyvChatDomainManager.getInstance().setChatDomain((PLVChatDomain)polyvChatDomain);
                PolyvLiveChannelType polyvLiveChannelType = PolyvLiveChannelType.mapFromServerString(polyvLiveStatusVO.getChannelType());
                PolyvLiveStatusType polyvLiveStatusType = PolyvLiveStatusType.mapFromServerString(polyvLiveStatusVO.getLiveStatus());
                String string5 = polyvLiveClassDetailVO.getData().getRtcType();
                String string22 = polyvLiveClassDetailVO.getData().getRtcAudioSubEnabled();
                String string32 = polyvLiveClassDetailVO.getData().getPureRtcAvailState();
                String string42 = polyvLiveClassDetailVO.getData().getPureRtcEnabled();
                boolean bl = false;
                if (string5.equals("urtc") && ("Y".equals(string42) || "Y".equals(string32))) {
                    bl = true;
                }
                boolean bl2 = "Y".equals(string22);
                PolyvLinkMicConfig.getInstance().setRtcType(string5).setLiveChannelType(polyvLiveChannelType).setPureRtcWatchEnabled(bl).setPureRtcOnlySubscribeMainScreenVideo(bl2);
                PLVELogsService.getInstance().setELogSender((IPLVStaticELogs)PLVELogRequestManager.getInstance());
                return new PolyvLiveLoginResult(polyvLiveChannelType, polyvLiveStatusType);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<PolyvLiveLoginResult>(){

            public void accept(PolyvLiveLoginResult polyvLiveLoginResult) throws Exception {
                if (onLoginListener != null) {
                    onLoginListener.onLoginSuccess(polyvLiveLoginResult);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                if (onLoginListener != null) {
                    onLoginListener.onLoginFailed(throwable.getMessage(), throwable);
                }
            }
        });
    }

    private Observable<PolyvLiveStatusVO> requestLiveStatus(final String string) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<PolyvLiveStatusVO>(){

            public void subscribe(ObservableEmitter<PolyvLiveStatusVO> observableEmitter) throws Exception {
                PLVResponseExcutor.excuteUndefinData(PolyvApiManager.getPolyvLiveStatusApi().getLiveStatusJson2(string), new PolyvResponseCallbackAdapter<PolyvLiveStatusVO>(observableEmitter));
            }
        });
    }

    private Observable<PolyvLiveClassDetailVO> requestLiveDetail(final String string, final String string2, final String string3) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<PolyvLiveClassDetailVO>(){

            public void subscribe(final ObservableEmitter<PolyvLiveClassDetailVO> observableEmitter) throws Exception {
                PLVResponseExcutor.excuteUndefinData(PolyvChatApiRequestHelper.getInstance().requestLiveClassDetailApi(string, string2, string3), (PLVrResponseCallback)new PolyvResponseCallbackAdapter<PolyvLiveClassDetailVO>(observableEmitter){

                    @Override
                    public void onSuccess(PolyvLiveClassDetailVO polyvLiveClassDetailVO) {
                        if (polyvLiveClassDetailVO.getCode() == 200) {
                            observableEmitter.onNext((Object)polyvLiveClassDetailVO);
                        } else {
                            observableEmitter.onError(new Throwable(polyvLiveClassDetailVO.toString()));
                        }
                    }
                });
            }
        });
    }

    @Override
    public void loginPlayback(final String string, final String string2, final String string3, final String string4, String string5, final IPLVSceneLoginManager.OnLoginListener<PolyvPlaybackLoginResult> onLoginListener) {
        this.dispose(this.loginPlaybackDisposable);
        this.loginPlaybackDisposable = Observable.zip(this.verify(string3, "", string4, string5, string), this.requestPlaybackStatus(string5), (BiFunction)new BiFunction<PolyvChatDomain, PolyvPlayBackVO, PolyvPlaybackLoginResult>(){

            public PolyvPlaybackLoginResult apply(PolyvChatDomain polyvChatDomain, PolyvPlayBackVO polyvPlayBackVO) throws Exception {
                PolyvLiveSDKClient.getInstance().setAppIdSecret(string3, string, string2);
                PolyvLiveSDKClient.getInstance().setChannelId(string4);
                PolyvLiveChannelType polyvLiveChannelType = PolyvLiveChannelType.PPT;
                switch (polyvPlayBackVO.getLiveType()) {
                    case 0: {
                        polyvLiveChannelType = PolyvLiveChannelType.ALONE;
                        break;
                    }
                    case 1: {
                        polyvLiveChannelType = PolyvLiveChannelType.PPT;
                        break;
                    }
                }
                PLVELogsService.getInstance().setELogSender((IPLVStaticELogs)PLVELogRequestManager.getInstance());
                return new PolyvPlaybackLoginResult(polyvLiveChannelType);
            }
        }).subscribe((Consumer)new Consumer<PolyvPlaybackLoginResult>(){

            public void accept(PolyvPlaybackLoginResult polyvPlaybackLoginResult) throws Exception {
                if (onLoginListener != null) {
                    onLoginListener.onLoginSuccess(polyvPlaybackLoginResult);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                if (onLoginListener != null) {
                    onLoginListener.onLoginFailed(throwable.getMessage(), throwable);
                }
            }
        });
    }

    private Observable<PolyvPlayBackVO> requestPlaybackStatus(final String string) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<PolyvPlayBackVO>(){

            public void subscribe(ObservableEmitter<PolyvPlayBackVO> observableEmitter) throws Exception {
                PolyvLoginManager.getPlayBackType((String)string, new PolyvResponseCallbackAdapter<PolyvPlayBackVO>(observableEmitter));
            }
        });
    }

    private Observable<PolyvChatDomain> verify(final String string, final String string2, final String string3, final String string4, final String string5) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<PolyvChatDomain>(){

            public void subscribe(ObservableEmitter<PolyvChatDomain> observableEmitter) throws Exception {
                PolyvLoginManager.checkLoginToken((String)string, (String)string2, (String)string5, (String)string3, (String)string4, new PolyvResponseCallbackAdapter<PolyvChatDomain>(observableEmitter));
            }
        });
    }

    private void dispose(Disposable disposable) {
        if (disposable != null) {
            disposable.dispose();
        }
    }

    @Override
    public void destroy() {
        this.dispose(this.loginLiveDisposable);
        this.dispose(this.loginPlaybackDisposable);
    }

    private static class PolyvResponseCallbackAdapter<Bean>
    extends PLVrResponseCallback<Bean> {
        private ObservableEmitter<Bean> emitter;

        PolyvResponseCallbackAdapter(ObservableEmitter<Bean> observableEmitter) {
            this.emitter = observableEmitter;
        }

        public void onSuccess(Bean Bean) {
            this.emitter.onNext(Bean);
        }

        public void onFinish() {
        }

        public void onFailure(PLVResponseBean<Bean> pLVResponseBean) {
            super.onFailure(pLVResponseBean);
            this.emitter.onError(new Throwable(pLVResponseBean.toString()));
        }

        public void onError(Throwable throwable) {
            super.onError(throwable);
            if (!this.emitter.isDisposed()) {
                this.emitter.onError(throwable);
            }
        }
    }
}

