/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyv.livescenes.feature.liveinfo;

import android.support.v4.util.ArrayMap;
import com.easefun.polyv.livescenes.config.PolyvLiveSDKClient;
import com.easefun.polyv.livescenes.net.PolyvApiManager;
import com.easefun.polyv.livescenes.socket.PolyvSocketWrapper;
import com.plv.foundationsdk.log.PLVCommonLog;
import com.plv.foundationsdk.net.PLVResponseExcutor;
import com.plv.foundationsdk.net.PLVrResponseCallback;
import com.plv.foundationsdk.rx.PLVRxTimer;
import com.plv.foundationsdk.sign.PLVSignCreator;
import com.plv.foundationsdk.utils.PLVGsonUtil;
import com.plv.socket.event.login.PLVLoginEvent;
import com.plv.socket.impl.PLVSocketMessageObserver;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class PolyvLiveInfoDataSource {
    private static final String TAG = "PolyvLiveInfoDataSource";
    private int pageViewerRequestInterval = 5000;
    private Disposable increaseViewerTimer;
    private Disposable increaseViewerApiDisposable;
    private Disposable observeLoginEventDisposable;
    private String viewerId;
    private int channelId;
    private int viewerTimes2Send = 0;

    public PolyvLiveInfoDataSource(int n, String string) {
        this.channelId = n;
        this.viewerId = string;
    }

    public void setPageViewerRequestInterval(int n) {
        this.pageViewerRequestInterval = n;
    }

    public void observePageViewer(final Action action) {
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(final ObservableEmitter<String> observableEmitter) throws Exception {
                PolyvSocketWrapper.getInstance().getSocketObserver().addOnMessageListener(new PLVSocketMessageObserver.OnMessageListener(){

                    public void onMessage(String string, String string2, String string3) {
                        if (!"message".equals(string)) {
                            return;
                        }
                        if ("LOGIN".equals(string2)) {
                            observableEmitter.onNext((Object)string3);
                        }
                    }
                });
            }
        });
        this.dispose(this.observeLoginEventDisposable);
        this.observeLoginEventDisposable = observable.buffer(500L, TimeUnit.MILLISECONDS).flatMap((Function)new Function<List<String>, ObservableSource<String>>(){

            public ObservableSource<String> apply(List<String> list) throws Exception {
                return Observable.fromIterable(list);
            }
        }).map((Function)new Function<String, PLVLoginEvent>(){

            public PLVLoginEvent apply(String string) throws Exception {
                return (PLVLoginEvent)PLVGsonUtil.fromJson(PLVLoginEvent.class, (String)string);
            }
        }).observeOn(AndroidSchedulers.mainThread()).doOnNext((Consumer)new Consumer<PLVLoginEvent>(){

            public void accept(PLVLoginEvent pLVLoginEvent) throws Exception {
                if (action != null) {
                    action.run();
                }
                if (pLVLoginEvent != null && PolyvLiveInfoDataSource.this.viewerId.equals(pLVLoginEvent.getUser().getUserId())) {
                    PolyvLiveInfoDataSource.this.dispose(PolyvLiveInfoDataSource.this.increaseViewerTimer);
                    PolyvLiveInfoDataSource.this.viewerTimes2Send++;
                    PolyvLiveInfoDataSource.this.increaseViewerTimer = PLVRxTimer.delay((long)5000L, (Consumer)new Consumer<Object>(){

                        public void accept(Object object) throws Exception {
                            PolyvLiveInfoDataSource.this.increasePageViewer();
                        }
                    });
                }
            }
        }).subscribe((Consumer)new Consumer<PLVLoginEvent>(){

            public void accept(PLVLoginEvent pLVLoginEvent) throws Exception {
                PLVCommonLog.d((String)PolyvLiveInfoDataSource.TAG, (String)("loginEvent:" + pLVLoginEvent.toString()));
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                throwable.printStackTrace();
            }
        });
    }

    public void destroy() {
        this.dispose(this.observeLoginEventDisposable);
        this.dispose(this.increaseViewerTimer);
        this.dispose(this.increaseViewerApiDisposable);
    }

    private void increasePageViewer() {
        String string = PolyvLiveSDKClient.getInstance().getAppId();
        String string2 = PolyvLiveSDKClient.getInstance().getAppSecret();
        long l = System.currentTimeMillis();
        ArrayMap arrayMap = new ArrayMap();
        arrayMap.put("channelId", String.valueOf(this.channelId));
        arrayMap.put("appId", string);
        arrayMap.put("timestamp", String.valueOf(l));
        arrayMap.put("times", String.valueOf(this.viewerTimes2Send));
        String string3 = PLVSignCreator.createSign((String)string2, (Map)arrayMap);
        this.dispose(this.increaseViewerApiDisposable);
        this.increaseViewerApiDisposable = PLVResponseExcutor.excuteDataBean(PolyvApiManager.getPolyvLiveStatusApi().increasePageViewer(this.channelId, string, l, string3, this.viewerTimes2Send), Integer.class, (PLVrResponseCallback)new PLVrResponseCallback<Integer>(){

            public void onSuccess(Integer n) {
                PolyvLiveInfoDataSource.this.viewerTimes2Send = 0;
            }

            public void onFinish() {
                PLVCommonLog.d((String)PolyvLiveInfoDataSource.TAG, (String)"increasePageViewer onFinish");
            }
        });
    }

    private void dispose(Disposable disposable) {
        if (disposable != null) {
            disposable.dispose();
        }
    }
}

