/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyv.livescenes.feature.interact;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import com.easefun.polyv.livescenes.feature.interact.IPLVInteractJSBridge;
import com.easefun.polyv.livescenes.feature.interact.PLVInteractAppAbs;
import com.easefun.polyv.livescenes.socket.PolyvSocketWrapper;
import com.github.lzyzsd.jsbridge.BridgeHandler;
import com.github.lzyzsd.jsbridge.CallBackFunction;
import com.plv.foundationsdk.web.PLVWebview;
import com.plv.socket.impl.PLVSocketMessageObserver;
import com.plv.thirdpart.blankj.utilcode.util.ActivityUtils;
import com.plv.thirdpart.blankj.utilcode.util.BarUtils;
import com.plv.thirdpart.blankj.utilcode.util.LogUtils;
import com.plv.thirdpart.blankj.utilcode.util.ScreenUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class PLVInteractWebView
extends PLVWebview
implements IPLVInteractJSBridge {
    private static final String LOAD_URL = "https://live.polyv.net/front/trivia-card/mobile?version=6";
    private static final String TAG = PLVInteractWebView.class.getSimpleName();
    private List<PLVInteractAppAbs> interactAppAbsList = new ArrayList<PLVInteractAppAbs>();

    public PLVInteractWebView(Context context) {
        this(context, null);
    }

    public PLVInteractWebView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public PLVInteractWebView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initView();
    }

    private void initView() {
        this.setWebChromeClient(new PolyvNoLeakWebChromeClient(this.getContext()));
        PolyvSocketWrapper.getInstance().getSocketObserver().addOnMessageListener(new PLVSocketMessageObserver.OnMessageListener(){

            public void onMessage(String string, String string2, String string3) {
                if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
                    return;
                }
                for (PLVInteractAppAbs pLVInteractAppAbs : PLVInteractWebView.this.interactAppAbsList) {
                    pLVInteractAppAbs.processSocketMsg(string3, string2);
                }
            }
        }, new String[]{"message"});
    }

    public void addInteractApp(PLVInteractAppAbs pLVInteractAppAbs) {
        if (pLVInteractAppAbs == null) {
            return;
        }
        pLVInteractAppAbs.setInteractJSBridge(this);
        this.interactAppAbsList.add(pLVInteractAppAbs);
    }

    public void removeInteractApp(PLVInteractAppAbs pLVInteractAppAbs) {
        if (pLVInteractAppAbs != null) {
            this.interactAppAbsList.remove(pLVInteractAppAbs);
            pLVInteractAppAbs.destroy();
        }
    }

    public void destroy() {
        super.destroy();
        for (PLVInteractAppAbs pLVInteractAppAbs : this.interactAppAbsList) {
            pLVInteractAppAbs.destroy();
        }
        this.interactAppAbsList.clear();
    }

    public void registerHandler() {
    }

    public void loadWeb() {
        this.loadUrl(LOAD_URL);
    }

    @Override
    public void registerMsgReceiverFromJs(String string, BridgeHandler bridgeHandler) {
        this.registerHandler(string, bridgeHandler);
    }

    @Override
    public void sendMsgToJs(String string, String string2, CallBackFunction callBackFunction) {
        this.callHandler(string, string2, callBackFunction);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = View.MeasureSpec.getSize((int)n2);
        if (n4 == 0) {
            n4 = ScreenUtils.getScreenHeight();
            if (BarUtils.isNavBarVisible((Activity)((Activity)this.getContext()))) {
                n4 -= BarUtils.getNavBarHeight();
            }
        }
        this.setMeasuredDimension(n3, n4);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: {
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 1: {
                if (this.hasFocus()) break;
                this.setFocusable(true);
                this.setFocusableInTouchMode(true);
                this.requestFocus();
                break;
            }
        }
        return super.onTouchEvent(motionEvent);
    }

    protected boolean overrideUrlLoading(WebView webView, String string) {
        if (string.startsWith("yy://")) {
            return super.overrideUrlLoading(webView, string);
        }
        try {
            Uri uri = Uri.parse((String)string);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            ActivityUtils.startActivity((Intent)intent);
        }
        catch (Exception exception) {
            LogUtils.e((Object[])new Object[]{exception});
        }
        return true;
    }

    private static class PolyvNoLeakWebChromeClient
    extends WebChromeClient {
        private WeakReference<Context> wrContext;

        PolyvNoLeakWebChromeClient(Context context) {
            this.wrContext = new WeakReference<Context>(context);
        }

        public boolean onJsConfirm(WebView webView, String string, String string2, final JsResult jsResult) {
            Context context = (Context)this.wrContext.get();
            if (context == null) {
                return true;
            }
            AlertDialog alertDialog = new AlertDialog.Builder(context).setMessage((CharSequence)string2).setPositiveButton((CharSequence)"\u786e\u8ba4", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    jsResult.confirm();
                    dialogInterface.dismiss();
                }
            }).setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    jsResult.cancel();
                    dialogInterface.dismiss();
                }
            }).create();
            alertDialog.setCanceledOnTouchOutside(false);
            alertDialog.setCancelable(false);
            alertDialog.show();
            return true;
        }
    }
}

