/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyv.livescenes.config;

import android.content.Context;
import com.easefun.polyv.businesssdk.PolyvCommonSDKClient;
import com.plv.foundationsdk.PLVUAClient;
import com.plv.foundationsdk.log.PLVCommonLog;
import com.plv.foundationsdk.utils.PLVUtils;
import com.plv.socket.socketio.PLVSocketIOClient;
import com.plv.thirdpart.blankj.utilcode.util.ConvertUtils;
import com.tencent.bugly.crashreport.CrashReport;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PolyvLiveSDKClient
extends PolyvCommonSDKClient {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private static final String POLYV_LIVE_ANDROID_SDK_NAME = "polyv-android-live-sdk";
    private static final String POLYV_LIVE_SDK_VERSION_EXTRA = "jh";
    private static final String POLYV_LIVE_ANDROID_VERSION = "1.2.2.2-20210510-jh";
    private static final String POLYV_LIVE_ANDROID_SDK = "polyv-android-live-sdk-1.2.2.2-20210510-jh";
    private static volatile PolyvLiveSDKClient instance;
    private String appId;
    private String appSecret;
    private String userId;
    private String channelId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PolyvLiveSDKClient getInstance() {
        if (instance != null) return instance;
        Class<PolyvLiveSDKClient> clazz = PolyvLiveSDKClient.class;
        synchronized (PolyvLiveSDKClient.class) {
            if (instance != null) return instance;
            instance = new PolyvLiveSDKClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initCrashReport(Context context) {
        try {
            CrashReport.initCrashReport((Context)context, (String)"32945280d8", (boolean)false);
            CrashReport.putUserData((Context)context, (String)"PolyvAndroidLiveSDK", (String)POLYV_LIVE_ANDROID_SDK);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            PLVCommonLog.e((String)this.TAG, (String)"bugly \u521d\u59cb\u5316\u5931\u8d25\u3002bugly init failed");
        }
    }

    public void initUA() {
        PLVUAClient.generateUserAgent((String)PLVUtils.getPid(), (String)this.getPolyvLiveAndroidSdk());
    }

    public void setAppIdSecret(String string, String string2, String string3) {
        this.userId = string;
        this.appId = string2;
        this.appSecret = string3;
        PLVSocketIOClient.getInstance().setAccountUserId(string);
        PLVSocketIOClient.getInstance().setAccountAppId(string2);
        PLVSocketIOClient.getInstance().setAccountAppSecret(string3);
        PLVSocketIOClient.getInstance().setSdkVersion(this.getPolyvLiveAndroidVersion());
    }

    public void setChannelId(String string) {
        this.channelId = string;
        PLVSocketIOClient.getInstance().setChannelId(string);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    private native byte[] getChannelData(String var1);

    public String getPolyvLiveAndroidSdkName() {
        return POLYV_LIVE_ANDROID_SDK_NAME;
    }

    public String getPolyvLiveAndroidVersion() {
        return POLYV_LIVE_ANDROID_VERSION;
    }

    public String getPolyvLiveAndroidSdk() {
        return POLYV_LIVE_ANDROID_SDK;
    }

    public static String dataToScrData(String string, String string2, String string3) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)new SecretKeySpec(string.getBytes(), "AES"), new IvParameterSpec(string2.getBytes()));
        return new String(cipher.doFinal(ConvertUtils.hexString2Bytes((String)string3)), "UTF-8");
    }
}

