/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyv.livescenes.chatroom;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.easefun.polyv.livescenes.chatroom.IPolyvChatroomManager;
import com.easefun.polyv.livescenes.chatroom.IPolyvProhibitedWordListener;
import com.easefun.polyv.livescenes.chatroom.PolyvLocalMessage;
import com.easefun.polyv.livescenes.chatroom.PolyvQuestionMessage;
import com.easefun.polyv.livescenes.chatroom.PolyvSocketCallbackListener;
import com.easefun.polyv.livescenes.chatroom.send.custom.PolyvBaseCustomEvent;
import com.easefun.polyv.livescenes.chatroom.send.custom.PolyvCustomEvent;
import com.easefun.polyv.livescenes.chatroom.send.custom.PolyvSendCustomMsgListener;
import com.easefun.polyv.livescenes.chatroom.send.img.PolyvSendChatImageHelper;
import com.easefun.polyv.livescenes.chatroom.send.img.PolyvSendChatImageListener;
import com.easefun.polyv.livescenes.chatroom.send.img.PolyvSendChatImgEvent;
import com.easefun.polyv.livescenes.chatroom.send.img.PolyvSendLocalImgEvent;
import com.easefun.polyv.livescenes.config.PolyvLiveSDKClient;
import com.easefun.polyv.livescenes.log.PolyvELogSender;
import com.easefun.polyv.livescenes.model.PolyvChatFunctionSwitchVO;
import com.easefun.polyv.livescenes.model.PolyvInteractiveCallbackVO;
import com.easefun.polyv.livescenes.model.PolyvTeacherStatusInfo;
import com.easefun.polyv.livescenes.net.PolyvApiManager;
import com.easefun.polyv.livescenes.socket.PolyvSocketWrapper;
import com.google.gson.Gson;
import com.plv.foundationsdk.log.PLVCommonLog;
import com.plv.foundationsdk.log.elog.logcode.chat.PLVErrorCodeChatroomApi;
import com.plv.foundationsdk.log.elog.logcode.chat.PLVErrorCodeChatroomImage;
import com.plv.foundationsdk.net.PLVRetrofitHelper;
import com.plv.foundationsdk.rx.PLVRxBaseRetryFunction;
import com.plv.foundationsdk.rx.PLVRxBaseTransformer;
import com.plv.foundationsdk.rx.PLVRxBus;
import com.plv.foundationsdk.utils.PLVCheckUtils;
import com.plv.foundationsdk.utils.PLVGsonUtil;
import com.plv.socket.event.PLVEventHelper;
import com.plv.socket.event.chat.PLVBanIpEvent;
import com.plv.socket.event.chat.PLVChatImgContent;
import com.plv.socket.event.chat.PLVChatImgEvent;
import com.plv.socket.event.chat.PLVCloseRoomEvent;
import com.plv.socket.event.chat.PLVSpeakEvent;
import com.plv.socket.event.chat.PLVUnshieldEvent;
import com.plv.socket.event.login.PLVLoginEvent;
import com.plv.socket.event.login.PLVLogoutEvent;
import com.plv.socket.impl.PLVSocketMessageObserver;
import com.plv.socket.net.model.PLVSocketLoginVO;
import com.plv.socket.socketio.PLVSocketIOObservable;
import com.plv.socket.status.PLVSocketStatus;
import com.plv.socket.user.PLVSocketUserBean;
import com.plv.thirdpart.blankj.utilcode.util.EncryptUtils;
import io.reactivex.ObservableTransformer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.socket.client.Ack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PolyvChatroomManager
implements IPolyvChatroomManager {
    private static final String TAG = PolyvChatroomManager.class.getSimpleName();
    private static final String NICK = "nick";
    private static final String COUNT = "count";
    private static final String ROOM_ID = "roomId";
    private static final String USER_ID = "userId";
    private static final String SESSION_ID = "sessionId";
    private static final String APP_ID = "appId";
    private static final String TIMES = "times";
    private static final String TIMESTAMP = "timestamp";
    private static final String VIEWER_ID = "viewerId";
    private static final String CONTENT = "content";
    private static final String ACTOR = "actor";
    private static final String CHAT_IMG = "chatImg";
    private static final String UP_LOADING_SUCCESS = "upLoadingSuccess";
    private static final String VALUES = "values";
    private static final String ACCOUNT_ID = "accountId";
    private static final String NEED_ID_CALLBACK = "needIdCallback";
    private static final String PIC = "pic";
    private static final String USER_TYPE = "userType";
    private static final String USER = "user";
    private static final String POLYV_SWITCH_API_INNOR = "polyv_switch_api_innor";
    private static final String CHANNEL_ID = "channelId";
    private static volatile PolyvChatroomManager chatMessageSender;
    private static final String STATUS_ERROR = "error";
    private int willSendSocketLikesCount;
    private int willSendApiLikesCount;
    private int willSendSocketLikesDelayTime = 5;
    private int willSendApiLikesDelayTime = 30;
    private String sendLikesSessionId;
    private static final int WHAT_LIKES_SOCKET = 12;
    private static final int WHAT_LIKES_API = 13;
    private static final int WHAT_CALLBACK_TIMEOUT = 15;
    private static final int WHAT_CALLBACK_RESPONSE = 16;
    private boolean isCloseRoom;
    private boolean isBanIp;
    private CompositeDisposable compositeDisposable;
    private Disposable getChatFunctionSwitchDisposable;
    private Disposable sendLikesDisposable;
    private Map<String, PolyvSendLocalImgEvent> sendImgIdMap = new HashMap<String, PolyvSendLocalImgEvent>();
    private List<PolyvSendChatImageListener> sendChatImageListeners;
    private static final String BUNDLE_KEY_INTERACTIVE = "interactive_event";
    private static final int SOCKET_CALLBACK_TIMEOUT = 5000;
    private PolyvSocketCallbackListener socketCallback;
    private int onlineCount;
    private PolyvChatFunctionSwitchVO chatFunctionSwitchVO;
    private PLVSocketIOObservable.OnConnectStatusListener onConnectStatusListener;
    private PLVSocketMessageObserver.OnMessageListener onMessageListener;
    private PolyvSendCustomMsgListener sendCustomMsgListener;
    private IPolyvProhibitedWordListener prohibitedWordListener;
    public static final int TOKEN_VALIDATE = 0x6DDD00;
    @SuppressLint(value={"HandlerLeak"})
    private Handler handler = new Handler(){

        public void handleMessage(Message message) {
            if (12 == message.what) {
                PolyvChatroomManager.this.sendLikesWithSocket(PolyvChatroomManager.this.willSendSocketLikesCount, PolyvChatroomManager.this.sendLikesSessionId);
                PolyvChatroomManager.this.willSendSocketLikesCount = 0;
            } else if (13 == message.what) {
                PolyvChatroomManager.this.sendLikesWithApi(PolyvChatroomManager.this.willSendApiLikesCount);
                PolyvChatroomManager.this.willSendApiLikesCount = 0;
            } else if (15 == message.what) {
                String string = message.getData().getString(PolyvChatroomManager.BUNDLE_KEY_INTERACTIVE);
                PolyvChatroomManager.this.sendInteractiveSocketMessage("message", message.obj, message.arg1, string);
            } else if (16 == message.what && PolyvChatroomManager.this.socketCallback != null) {
                PolyvInteractiveCallbackVO polyvInteractiveCallbackVO = (PolyvInteractiveCallbackVO)message.obj;
                PolyvChatroomManager.this.socketCallback.socketCallback(polyvInteractiveCallbackVO);
            }
        }
    };

    private PolyvChatroomManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PolyvChatroomManager getInstance() {
        if (chatMessageSender != null) return chatMessageSender;
        Class<PolyvChatroomManager> clazz = PolyvChatroomManager.class;
        synchronized (PolyvChatroomManager.class) {
            if (chatMessageSender != null) return chatMessageSender;
            chatMessageSender = new PolyvChatroomManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return chatMessageSender;
        }
    }

    @Override
    public void init() {
        this.compositeDisposable = new CompositeDisposable();
        this.onConnectStatusListener = new PLVSocketIOObservable.OnConnectStatusListener(){

            public void onStatus(PLVSocketStatus pLVSocketStatus) {
                PolyvTeacherStatusInfo polyvTeacherStatusInfo = new PolyvTeacherStatusInfo();
                polyvTeacherStatusInfo.setWatchStatus("loginChatRoom");
                PLVRxBus.get().post((Object)polyvTeacherStatusInfo);
            }
        };
        PolyvSocketWrapper.getInstance().getSocketObserver().addOnConnectStatusListener(this.onConnectStatusListener);
        this.onMessageListener = new PLVSocketMessageObserver.OnMessageListener(){

            public void onMessage(String string, String string2, String string3) {
                if ("message".equals(string)) {
                    block9 : switch (string2) {
                        case "CLOSEROOM": {
                            PLVCloseRoomEvent pLVCloseRoomEvent = (PLVCloseRoomEvent)PLVEventHelper.toEventModel((String)string, (String)string2, (String)string3, PLVCloseRoomEvent.class);
                            if (pLVCloseRoomEvent == null || pLVCloseRoomEvent.getValue() == null) break;
                            PolyvChatroomManager.this.isCloseRoom = pLVCloseRoomEvent.getValue().isClosed();
                            break;
                        }
                        case "BANIP": {
                            PLVBanIpEvent pLVBanIpEvent = (PLVBanIpEvent)PLVEventHelper.toEventModel((String)string, (String)string2, (String)string3, PLVBanIpEvent.class);
                            if (pLVBanIpEvent == null || pLVBanIpEvent.getUserIds() == null) break;
                            for (PLVSocketUserBean pLVSocketUserBean : pLVBanIpEvent.getUserIds()) {
                                if (!PolyvSocketWrapper.getInstance().getLoginVO().getUserId().equals(pLVSocketUserBean.getUserId())) continue;
                                PolyvChatroomManager.this.isBanIp = true;
                                break block9;
                            }
                            break;
                        }
                        case "UNSHIELD": {
                            PLVUnshieldEvent pLVUnshieldEvent = (PLVUnshieldEvent)PLVEventHelper.toEventModel((String)string, (String)string2, (String)string3, PLVUnshieldEvent.class);
                            if (pLVUnshieldEvent == null || pLVUnshieldEvent.getUserIds() == null) break;
                            for (PLVSocketUserBean pLVSocketUserBean : pLVUnshieldEvent.getUserIds()) {
                                if (!PolyvSocketWrapper.getInstance().getLoginVO().getUserId().equals(pLVSocketUserBean.getUserId())) continue;
                                PolyvChatroomManager.this.isBanIp = false;
                                break block9;
                            }
                            break;
                        }
                        case "CHAT_IMG": {
                            final PLVChatImgEvent pLVChatImgEvent = (PLVChatImgEvent)PLVEventHelper.toEventModel((String)string, (String)string2, (String)string3, PLVChatImgEvent.class);
                            if (pLVChatImgEvent == null || pLVChatImgEvent.getUser() == null || !PolyvChatroomManager.this.getLoginVO().getUserId().equals(pLVChatImgEvent.getUser().getUserId()) || pLVChatImgEvent.getValues() == null || pLVChatImgEvent.getValues().size() <= 0) break;
                            final PLVChatImgContent pLVChatImgContent = (PLVChatImgContent)pLVChatImgEvent.getValues().get(0);
                            final PolyvSendLocalImgEvent polyvSendLocalImgEvent = (PolyvSendLocalImgEvent)((Object)PolyvChatroomManager.this.sendImgIdMap.get(pLVChatImgContent.getId()));
                            String string4 = null;
                            if (polyvSendLocalImgEvent != null) {
                                polyvSendLocalImgEvent.setId(pLVChatImgEvent.getId());
                                string4 = polyvSendLocalImgEvent.getImageFilePath();
                            }
                            if (string4 == null || PolyvChatroomManager.this.sendChatImageListeners == null || PolyvChatroomManager.this.sendChatImageListeners.size() <= 0 || PolyvChatroomManager.this.compositeDisposable == null) break;
                            PolyvChatroomManager.this.compositeDisposable.add(AndroidSchedulers.mainThread().createWorker().schedule(new Runnable(){

                                @Override
                                public void run() {
                                    if (pLVChatImgEvent.isResult()) {
                                        PolyvChatroomManager.this.callbackChatImage(new ChatImageRunnable(){

                                            @Override
                                            public void run(PolyvSendChatImageListener polyvSendChatImageListener) {
                                                polyvSendChatImageListener.onSuccess(polyvSendLocalImgEvent, pLVChatImgContent.getUploadImgUrl(), pLVChatImgContent.getId());
                                            }
                                        });
                                    } else {
                                        PolyvELogSender.send(PLVErrorCodeChatroomImage.class, 5, (Throwable)new Exception("\u56fe\u7247\u5ba1\u6838\u4e0d\u901a\u8fc7, event is " + pLVChatImgEvent.toString()));
                                        PolyvChatroomManager.this.callbackChatImage(new ChatImageRunnable(){

                                            @Override
                                            public void run(PolyvSendChatImageListener polyvSendChatImageListener) {
                                                polyvSendChatImageListener.onUploadFail(polyvSendLocalImgEvent, new Exception("\u56fe\u7247\u8d44\u6e90\u5ba1\u6838\u4e0d\u901a\u8fc7"));
                                            }
                                        });
                                    }
                                }
                            }));
                            break;
                        }
                        case "LOGIN": {
                            int n = ((PLVLoginEvent)PLVEventHelper.toEventModel((String)string, (String)string2, (String)string3, PLVLoginEvent.class)).getOnlineUserNumber();
                            PolyvChatroomManager.this.setOnlineCount(n);
                            break;
                        }
                        case "LOGOUT": {
                            int n = ((PLVLogoutEvent)PLVEventHelper.toEventModel((String)string, (String)string2, (String)string3, PLVLogoutEvent.class)).getOnlineUserNumber();
                            PolyvChatroomManager.this.setOnlineCount(n);
                            break;
                        }
                        case "SPEAK": {
                            PLVSpeakEvent pLVSpeakEvent = (PLVSpeakEvent)PLVEventHelper.toEventModel((String)string, (String)string2, (String)string3, PLVSpeakEvent.class);
                            if (pLVSpeakEvent == null) {
                                return;
                            }
                            PLVSocketUserBean pLVSocketUserBean = pLVSpeakEvent.getUser();
                            if (pLVSocketUserBean != null || PolyvChatroomManager.this.prohibitedWordListener == null || !PolyvChatroomManager.STATUS_ERROR.equals(pLVSpeakEvent.getStatus())) break;
                            String string5 = pLVSpeakEvent.getMessage();
                            String string6 = pLVSpeakEvent.getValue();
                            PolyvChatroomManager.this.prohibitedWordListener.onSendProhibitedWord(string6, string5, PolyvChatroomManager.STATUS_ERROR);
                            break;
                        }
                    }
                }
            }
        };
        PolyvSocketWrapper.getInstance().getSocketObserver().addOnMessageListener(this.onMessageListener);
    }

    @Override
    public void setWillSendApiLikesDelaySeconds(int n) {
        this.willSendApiLikesDelayTime = n;
    }

    @Override
    public void setWillSendSocketLikesDelaySeconds(int n) {
        this.willSendSocketLikesDelayTime = n;
    }

    @Override
    public void sendLikes(String string) {
        this.sendLikes(1, string);
    }

    @Override
    public void sendLikes(int n, String string) {
        if (this.willSendSocketLikesCount == this.willSendSocketLikesDelayTime || this.willSendApiLikesCount == this.willSendApiLikesDelayTime) {
            return;
        }
        if (n <= 0) {
            return;
        }
        this.sendLikesSessionId = string;
        if (this.willSendSocketLikesCount == 0) {
            this.willSendSocketLikesCount = Math.min(this.willSendSocketLikesDelayTime, this.willSendSocketLikesCount + n);
            this.startEventCountdown(12, (long)this.willSendSocketLikesDelayTime * 1000L);
        } else {
            this.willSendSocketLikesCount = Math.min(this.willSendSocketLikesDelayTime, this.willSendSocketLikesCount + n);
        }
        if (this.willSendApiLikesCount == 0) {
            this.willSendApiLikesCount = Math.min(this.willSendApiLikesDelayTime, this.willSendApiLikesCount + n);
            this.startEventCountdown(13, (long)this.willSendApiLikesDelayTime * 1000L);
        } else {
            this.willSendApiLikesCount = Math.min(this.willSendApiLikesDelayTime, this.willSendApiLikesCount + n);
        }
    }

    private void sendLikesWithSocket(int n, String string) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("EVENT", (Object)"LIKES");
            jSONObject.put(NICK, (Object)this.getLoginVO().getNickName());
            jSONObject.put(COUNT, n);
            jSONObject.put(ROOM_ID, (Object)PolyvSocketWrapper.getInstance().getLoginRoomId());
            jSONObject.put(USER_ID, (Object)this.getLoginVO().getUserId());
            if (!TextUtils.isEmpty((CharSequence)string)) {
                jSONObject.put(SESSION_ID, (Object)string);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        PolyvSocketWrapper.getInstance().emit("message", new Object[]{jSONObject.toString()});
    }

    private void sendLikesWithApi(int n) {
        long l = System.currentTimeMillis();
        String string = EncryptUtils.encryptMD5ToString((String)(PolyvLiveSDKClient.getInstance().getAppSecret() + APP_ID + PolyvLiveSDKClient.getInstance().getAppId() + TIMES + n + TIMESTAMP + l + VIEWER_ID + this.getLoginVO().getUserId() + PolyvLiveSDKClient.getInstance().getAppSecret())).toUpperCase();
        if (this.sendLikesDisposable != null) {
            this.sendLikesDisposable.dispose();
        }
        this.sendLikesDisposable = PolyvApiManager.getPolyvLiveStatusApi().sendLikes(this.getLoginVO().getChannelId(), PolyvLiveSDKClient.getInstance().getAppId(), l + "", string, this.getLoginVO().getUserId(), n).compose((ObservableTransformer)new PLVRxBaseTransformer()).subscribe((Consumer)new Consumer<ResponseBody>(){

            public void accept(ResponseBody responseBody) throws Exception {
                PLVCommonLog.d((String)TAG, (String)("sendLikes :" + responseBody.toString()));
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                PLVCommonLog.exception((Throwable)throwable);
            }
        });
    }

    @Override
    public void addSendChatImageListener(PolyvSendChatImageListener polyvSendChatImageListener) {
        if (this.sendChatImageListeners == null) {
            this.sendChatImageListeners = new ArrayList<PolyvSendChatImageListener>();
        }
        if (!this.sendChatImageListeners.contains(polyvSendChatImageListener)) {
            this.sendChatImageListeners.add(polyvSendChatImageListener);
        }
    }

    @Override
    public void removeSendChatImageListener(PolyvSendChatImageListener polyvSendChatImageListener) {
        if (this.sendChatImageListeners != null) {
            this.sendChatImageListeners.remove(polyvSendChatImageListener);
        }
    }

    private void callbackChatImage(ChatImageRunnable chatImageRunnable) {
        if (this.sendChatImageListeners != null) {
            for (PolyvSendChatImageListener polyvSendChatImageListener : this.sendChatImageListeners) {
                if (polyvSendChatImageListener == null || chatImageRunnable == null) continue;
                chatImageRunnable.run(polyvSendChatImageListener);
            }
        }
    }

    @Override
    public void sendChatImage(final PolyvSendLocalImgEvent polyvSendLocalImgEvent, final String string) {
        if (polyvSendLocalImgEvent == null || TextUtils.isEmpty((CharSequence)polyvSendLocalImgEvent.getImageFilePath())) {
            this.callbackChatImage(new ChatImageRunnable(){

                @Override
                public void run(PolyvSendChatImageListener polyvSendChatImageListener) {
                    polyvSendChatImageListener.onSendFail(polyvSendLocalImgEvent, -1);
                }
            });
            return;
        }
        if (this.isCloseRoom || this.isBanIp) {
            this.callbackChatImage(new ChatImageRunnable(){

                @Override
                public void run(PolyvSendChatImageListener polyvSendChatImageListener) {
                    polyvSendChatImageListener.onSendFail(polyvSendLocalImgEvent, PolyvChatroomManager.this.isBanIp ? -6 : -4);
                }
            });
            return;
        }
        if (!PolyvSocketWrapper.getInstance().isOnlineStatus()) {
            this.callbackChatImage(new ChatImageRunnable(){

                @Override
                public void run(PolyvSendChatImageListener polyvSendChatImageListener) {
                    polyvSendChatImageListener.onSendFail(polyvSendLocalImgEvent, -3);
                }
            });
            return;
        }
        try {
            PolyvSendChatImageHelper.sendChatImage(this.getLoginVO().getChannelId(), polyvSendLocalImgEvent, new PolyvSendChatImageListener(){

                @Override
                public void onUploadFail(final PolyvSendLocalImgEvent polyvSendLocalImgEvent, final Throwable throwable) {
                    PolyvELogSender.send(PLVErrorCodeChatroomApi.class, 17, throwable);
                    PolyvChatroomManager.this.callbackChatImage(new ChatImageRunnable(){

                        @Override
                        public void run(PolyvSendChatImageListener polyvSendChatImageListener) {
                            polyvSendChatImageListener.onUploadFail(polyvSendLocalImgEvent, throwable);
                        }
                    });
                }

                @Override
                public void onSendFail(final PolyvSendLocalImgEvent polyvSendLocalImgEvent, final int n) {
                    PolyvChatroomManager.this.callbackChatImage(new ChatImageRunnable(){

                        @Override
                        public void run(PolyvSendChatImageListener polyvSendChatImageListener) {
                            polyvSendChatImageListener.onSendFail(polyvSendLocalImgEvent, n);
                        }
                    });
                }

                @Override
                public void onSuccess(PolyvSendLocalImgEvent polyvSendLocalImgEvent, String string3, String string2) {
                    PolyvChatroomManager.this.sendChatImageEvent(polyvSendLocalImgEvent, string3, string2, string);
                }

                @Override
                public void onProgress(final PolyvSendLocalImgEvent polyvSendLocalImgEvent, final float f) {
                    if (PolyvChatroomManager.this.sendChatImageListeners != null && !PolyvChatroomManager.this.sendChatImageListeners.isEmpty() && f != 1.0f && PolyvChatroomManager.this.compositeDisposable != null) {
                        PolyvChatroomManager.this.compositeDisposable.add(AndroidSchedulers.mainThread().createWorker().schedule(new Runnable(){

                            @Override
                            public void run() {
                                PolyvChatroomManager.this.callbackChatImage(new ChatImageRunnable(){

                                    @Override
                                    public void run(PolyvSendChatImageListener polyvSendChatImageListener) {
                                        polyvSendChatImageListener.onProgress(polyvSendLocalImgEvent, f);
                                    }
                                });
                            }
                        }));
                    }
                }
            }, this.compositeDisposable);
        }
        catch (Exception exception) {
            this.callbackChatImage(new ChatImageRunnable(){

                @Override
                public void run(PolyvSendChatImageListener polyvSendChatImageListener) {
                    polyvSendChatImageListener.onUploadFail(polyvSendLocalImgEvent, exception);
                }
            });
        }
    }

    private void sendChatImageEvent(PolyvSendLocalImgEvent polyvSendLocalImgEvent, String string, String string2, String string3) {
        PolyvSendChatImgEvent polyvSendChatImgEvent = new PolyvSendChatImgEvent();
        polyvSendChatImgEvent.setEVENT("CHAT_IMG");
        polyvSendChatImgEvent.setRoomId(PolyvSocketWrapper.getInstance().getLoginRoomId());
        polyvSendChatImgEvent.setSessionId(string3);
        polyvSendChatImgEvent.setAccountId(PolyvLiveSDKClient.getInstance().getUserId());
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            polyvSendChatImgEvent.setSessionId(string3);
        }
        ArrayList<PolyvSendChatImgEvent.ValueBean> arrayList = new ArrayList<PolyvSendChatImgEvent.ValueBean>();
        PolyvSendChatImgEvent.ValueBean valueBean = new PolyvSendChatImgEvent.ValueBean();
        valueBean.setUploadImgUrl(string);
        valueBean.setType(CHAT_IMG);
        valueBean.setStatus(UP_LOADING_SUCCESS);
        valueBean.setId(string2);
        PolyvSendChatImgEvent.ValueBean.SizeBean sizeBean = new PolyvSendChatImgEvent.ValueBean.SizeBean();
        sizeBean.setWidth(polyvSendLocalImgEvent.getWidth());
        sizeBean.setHeight(polyvSendLocalImgEvent.getHeight());
        valueBean.setSize(sizeBean);
        arrayList.add(valueBean);
        polyvSendChatImgEvent.setValues(arrayList);
        PolyvSocketWrapper.getInstance().emit("message", new Object[]{new Gson().toJson((Object)polyvSendChatImgEvent)});
        this.sendImgIdMap.put(string2, polyvSendLocalImgEvent);
    }

    @Override
    public int sendChatMessage(PolyvLocalMessage polyvLocalMessage, String string) {
        return this.sendChatMessage(polyvLocalMessage, string, false, null);
    }

    @Override
    public int sendChatMessage(PolyvLocalMessage polyvLocalMessage, String string, boolean bl, Ack ack) {
        if (polyvLocalMessage == null || PLVCheckUtils.checkParams((String[])new String[]{polyvLocalMessage.getSpeakMessage(), ""}) != null) {
            return -1;
        }
        if (this.isCloseRoom || this.isBanIp) {
            return this.isCloseRoom ? -4 : -6;
        }
        if (!PolyvSocketWrapper.getInstance().isOnlineStatus()) {
            return -3;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            jSONObject.put("EVENT", (Object)"SPEAK");
            jSONArray.put(0, (Object)polyvLocalMessage.getSpeakMessage());
            jSONObject.put(VALUES, (Object)jSONArray);
            jSONObject.put(ACCOUNT_ID, (Object)PolyvLiveSDKClient.getInstance().getUserId());
            jSONObject.put(SESSION_ID, (Object)string);
            jSONObject.put(ROOM_ID, (Object)PolyvSocketWrapper.getInstance().getLoginRoomId());
            jSONObject.put(NEED_ID_CALLBACK, bl);
        }
        catch (JSONException jSONException) {
            PLVCommonLog.exception((Throwable)jSONException);
            return -2;
        }
        PolyvSocketWrapper.getInstance().emit("message", new Object[]{jSONObject.toString(), ack});
        return 1;
    }

    private void startEventCountdown(int n, long l) {
        this.stopEventCountdown(n);
        this.handler.sendEmptyMessageDelayed(n, l);
    }

    private void stopEventCountdown(int n) {
        this.handler.removeMessages(n);
    }

    @Override
    public int sendQuestionMessage(PolyvQuestionMessage polyvQuestionMessage) {
        if (polyvQuestionMessage == null || PLVCheckUtils.checkParams((String[])new String[]{polyvQuestionMessage.getQuestionMessage(), ""}) != null) {
            return -1;
        }
        if (!PolyvSocketWrapper.getInstance().isOnlineStatus()) {
            return -3;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("EVENT", (Object)"S_QUESTION");
            jSONObject.put(CONTENT, (Object)polyvQuestionMessage.getQuestionMessage());
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put(ACTOR, (Object)"\u5b66\u751f");
            jSONObject2.put(NICK, (Object)this.getLoginVO().getNickName());
            jSONObject2.put(PIC, (Object)this.getLoginVO().getAvatarUrl());
            jSONObject2.put(USER_ID, (Object)this.getLoginVO().getUserId());
            jSONObject2.put(USER_TYPE, (Object)this.getLoginVO().getUserType());
            jSONObject.put(USER, (Object)jSONObject2);
            jSONObject.put(ROOM_ID, (Object)PolyvSocketWrapper.getInstance().getLoginRoomId());
        }
        catch (JSONException jSONException) {
            return -2;
        }
        PolyvSocketWrapper.getInstance().emit("message", new Object[]{jSONObject.toString()});
        return 1;
    }

    @Override
    public void setSendCustomMsgListener(PolyvSendCustomMsgListener polyvSendCustomMsgListener) {
        this.sendCustomMsgListener = polyvSendCustomMsgListener;
    }

    @Override
    public <DataBean> void sendCustomMsg(PolyvBaseCustomEvent<DataBean> polyvBaseCustomEvent) {
        if (polyvBaseCustomEvent == null || polyvBaseCustomEvent.getData() == null || TextUtils.isEmpty((CharSequence)polyvBaseCustomEvent.getEVENT())) {
            if (this.sendCustomMsgListener != null) {
                this.sendCustomMsgListener.onSendFail(polyvBaseCustomEvent, -1);
            }
            return;
        }
        if (polyvBaseCustomEvent.getEmitMode() < 0 || polyvBaseCustomEvent.getEmitMode() > 2 || polyvBaseCustomEvent.getEVENT().length() > 50) {
            if (this.sendCustomMsgListener != null) {
                this.sendCustomMsgListener.onSendFail(polyvBaseCustomEvent, -7);
            }
            return;
        }
        if (this.isCloseRoom || this.isBanIp) {
            if (this.sendCustomMsgListener != null) {
                this.sendCustomMsgListener.onSendFail(polyvBaseCustomEvent, this.isCloseRoom ? -4 : -6);
            }
            return;
        }
        PolyvCustomEvent<DataBean> polyvCustomEvent = new PolyvCustomEvent<DataBean>(polyvBaseCustomEvent.getEVENT(), polyvBaseCustomEvent.getEmitMode(), polyvBaseCustomEvent.getData());
        try {
            polyvCustomEvent.setRoomId(Integer.parseInt(PolyvSocketWrapper.getInstance().getLoginRoomId()));
        }
        catch (Exception exception) {
            if (this.sendCustomMsgListener != null) {
                this.sendCustomMsgListener.onSendFail(polyvBaseCustomEvent, exception);
            }
            return;
        }
        polyvCustomEvent.setUser(null);
        polyvCustomEvent.setId(null);
        polyvCustomEvent.setTime(0L);
        polyvCustomEvent.setMsgSource(null);
        polyvCustomEvent.setMsgType(null);
        polyvCustomEvent.setTip(TextUtils.isEmpty((CharSequence)polyvBaseCustomEvent.getTip()) ? "\u53d1\u9001\u4e86\u81ea\u5b9a\u4e49\u6d88\u606f" : polyvBaseCustomEvent.getTip());
        polyvCustomEvent.setVersion(1);
        PolyvSocketWrapper.getInstance().emit("customMessage", new Object[]{new Gson().toJson(polyvCustomEvent)});
        if (this.sendCustomMsgListener != null) {
            this.sendCustomMsgListener.onSuccess(polyvBaseCustomEvent);
        }
    }

    @Override
    public int sendLookAtMeMessage() {
        if (!PolyvSocketWrapper.getInstance().isOnlineStatus()) {
            return -3;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("EVENT", (Object)"LOOK_AT_ME");
        }
        catch (JSONException jSONException) {
            PLVCommonLog.exception((Throwable)jSONException);
            return -2;
        }
        PolyvSocketWrapper.getInstance().emit("message", new Object[]{jSONObject.toString()});
        return 1;
    }

    @Override
    public void sendInteractiveSocketMessage(String string, Object object, int n, final String string2) {
        if (n < 0) {
            PolyvInteractiveCallbackVO polyvInteractiveCallbackVO = new PolyvInteractiveCallbackVO();
            polyvInteractiveCallbackVO.setCode(400);
            polyvInteractiveCallbackVO.setEVENT(string2);
            Message message = Message.obtain();
            message.obj = polyvInteractiveCallbackVO;
            message.what = 16;
            this.handler.sendMessage(message);
            return;
        }
        String string3 = null;
        string3 = object instanceof String ? (String)object : PLVGsonUtil.toJson((Object)object);
        Message message = Message.obtain();
        message.what = 15;
        message.arg1 = n - 1;
        message.obj = string3;
        Bundle bundle = new Bundle();
        bundle.putString(BUNDLE_KEY_INTERACTIVE, string2);
        message.setData(bundle);
        this.handler.sendMessageDelayed(message, 5000L);
        PolyvSocketWrapper.getInstance().emit(string, new Object[]{string3, new Ack(){

            public void call(Object ... objectArray) {
                PLVCommonLog.d((String)TAG, (String)("callback:" + objectArray[0].toString()));
                PolyvInteractiveCallbackVO polyvInteractiveCallbackVO = (PolyvInteractiveCallbackVO)PLVGsonUtil.fromJson(PolyvInteractiveCallbackVO.class, (String)objectArray[0].toString());
                if (polyvInteractiveCallbackVO == null) {
                    polyvInteractiveCallbackVO = new PolyvInteractiveCallbackVO();
                }
                polyvInteractiveCallbackVO.setEVENT(string2);
                PolyvChatroomManager.this.handler.removeMessages(15);
                Message message = Message.obtain();
                message.obj = polyvInteractiveCallbackVO;
                message.what = 16;
                PolyvChatroomManager.this.handler.sendMessage(message);
            }
        }});
    }

    @Override
    public PolyvChatFunctionSwitchVO getChatFunctionSwitchVO() {
        return this.chatFunctionSwitchVO;
    }

    @Override
    public void requestFunctionSwitch(final Consumer<PolyvChatFunctionSwitchVO> consumer) {
        long l = System.currentTimeMillis();
        String string = EncryptUtils.encryptMD5ToString((String)(POLYV_SWITCH_API_INNOR + CHANNEL_ID + this.getLoginVO().getChannelId() + TIMESTAMP + l + POLYV_SWITCH_API_INNOR)).toUpperCase();
        if (this.getChatFunctionSwitchDisposable != null) {
            this.getChatFunctionSwitchDisposable.dispose();
        }
        this.getChatFunctionSwitchDisposable = PolyvApiManager.getPolyvLiveStatusApi().getChatFunctionSwitch(l, string, this.getLoginVO().getChannelId()).retryWhen((Function)new PLVRxBaseRetryFunction(Integer.MAX_VALUE, 3000L)).compose((ObservableTransformer)new PLVRxBaseTransformer()).subscribe((Consumer)new Consumer<PolyvChatFunctionSwitchVO>(){

            public void accept(PolyvChatFunctionSwitchVO polyvChatFunctionSwitchVO) throws Exception {
                PolyvChatroomManager.this.chatFunctionSwitchVO = polyvChatFunctionSwitchVO;
                if (consumer != null) {
                    consumer.accept((Object)PolyvChatroomManager.this.chatFunctionSwitchVO);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                PLVCommonLog.exception((Throwable)throwable);
            }
        });
    }

    @Override
    public void setOnlineCount(int n) {
        this.onlineCount = n;
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                PolyvTeacherStatusInfo polyvTeacherStatusInfo = new PolyvTeacherStatusInfo();
                polyvTeacherStatusInfo.setWatchStatus("loginChatRoom");
                PLVRxBus.get().post((Object)polyvTeacherStatusInfo);
            }
        });
    }

    @Override
    public int getOnlineCount() {
        return this.onlineCount;
    }

    @Override
    public void setSocketCallbackListener(PolyvSocketCallbackListener polyvSocketCallbackListener) {
        this.socketCallback = polyvSocketCallbackListener;
    }

    @Override
    public void setProhibitedWordListener(IPolyvProhibitedWordListener iPolyvProhibitedWordListener) {
        this.prohibitedWordListener = iPolyvProhibitedWordListener;
    }

    private PLVSocketLoginVO getLoginVO() {
        return PolyvSocketWrapper.getInstance().getLoginVO();
    }

    @Override
    public void destroy() {
        this.isCloseRoom = false;
        this.isBanIp = false;
        this.sendLikesSessionId = null;
        this.willSendSocketLikesCount = 0;
        this.willSendApiLikesCount = 0;
        this.onlineCount = 0;
        this.handler.removeCallbacksAndMessages(null);
        if (this.sendChatImageListeners != null) {
            this.sendChatImageListeners.clear();
            this.sendChatImageListeners = null;
        }
        this.chatFunctionSwitchVO = null;
        this.sendCustomMsgListener = null;
        this.prohibitedWordListener = null;
        this.socketCallback = null;
        PolyvSocketWrapper.getInstance().getSocketObserver().removeOnMessageListener(this.onMessageListener);
        PolyvSocketWrapper.getInstance().getSocketObserver().removeOnConnectStatusListener(this.onConnectStatusListener);
        if (this.sendLikesDisposable != null) {
            this.sendLikesDisposable.dispose();
            this.sendLikesDisposable = null;
        }
        if (this.getChatFunctionSwitchDisposable != null) {
            this.getChatFunctionSwitchDisposable.dispose();
            this.getChatFunctionSwitchDisposable = null;
        }
        if (this.compositeDisposable != null) {
            this.compositeDisposable.dispose();
            this.compositeDisposable = null;
        }
        PLVRetrofitHelper.clearProgressListener();
    }

    private static interface ChatImageRunnable {
        public void run(PolyvSendChatImageListener var1);
    }
}

