/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyv.livescenes.chatroom;

import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Patterns;
import com.easefun.polyv.livescenes.config.PolyvLiveSDKClient;
import com.easefun.polyv.livescenes.model.PolyvChatFunctionSwitchVO;
import com.easefun.polyv.livescenes.model.PolyvLiveClassDetailVO;
import com.easefun.polyv.livescenes.model.PolyvPlaybackListVO;
import com.easefun.polyv.livescenes.net.PolyvApiManager;
import com.plv.foundationsdk.rx.PLVRxBaseTransformer;
import com.plv.foundationsdk.sign.PLVSignCreator;
import com.plv.foundationsdk.utils.PLVCheckUtils;
import com.plv.foundationsdk.utils.PLVTimeUtils;
import com.plv.socket.user.PLVAuthorizationBean;
import com.plv.thirdpart.blankj.utilcode.util.EncryptUtils;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import java.util.HashMap;
import java.util.Map;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;

public class PolyvChatApiRequestHelper {
    private static final String CHANNEL_ID = "channelId";
    private static final String POLYV_SWITCH_API_INNOR = "polyv_switch_api_innor";
    private static final String TIMESTAMP = "timestamp";
    private static final String APP_ID = "appId";
    private static final String PAGE = "page";
    private static final String PAGE_SIZE = "pageSize";
    private static final String LIST_TYPE = "listType";
    private static final String VIEWER_ID = "viewerId";
    private static final String VIEWER_NAME = "viewerName";
    private static final String IMAGE_URL = "imageUrl";
    private static final String USER_TYPE = "userType";
    private static final String ACTOR = "actor";
    private static final String BG_COLOR = "bgColor";
    private static final String F_COLOR = "fColor";
    private static final String AUTHORIZATION = "authorization";
    private static final String NICK = "nick";
    private static final String PIC = "pic";
    private static final String ROOM_ID = "roomId";
    private static final String USER_ID = "userId";
    private static final String VID = "vid";
    private static final String LIMIT = "limit";
    private static final String TIME = "time";
    private static final String ID = "id";
    private static final String ORIGIN = "origin";
    private static final String CHAT = "chat";
    private static final String PLAYBACK = "playback";
    private static final String VOD = "vod";
    private static final String MSG = "msg";
    private static final String MSG_TYPE = "msgType";
    private static final String USER = "user";
    private static final String SESSION_ID = "sessionId";
    private static volatile PolyvChatApiRequestHelper chatApiRequestHelper;

    private PolyvChatApiRequestHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PolyvChatApiRequestHelper getInstance() {
        if (chatApiRequestHelper != null) return chatApiRequestHelper;
        Class<PolyvChatApiRequestHelper> clazz = PolyvChatApiRequestHelper.class;
        synchronized (PolyvChatApiRequestHelper.class) {
            if (chatApiRequestHelper != null) return chatApiRequestHelper;
            chatApiRequestHelper = new PolyvChatApiRequestHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return chatApiRequestHelper;
        }
    }

    public Observable<PolyvChatFunctionSwitchVO> requestFunctionSwitch(String string) {
        long l = System.currentTimeMillis();
        String string2 = EncryptUtils.encryptMD5ToString((String)(POLYV_SWITCH_API_INNOR + CHANNEL_ID + string + TIMESTAMP + l + POLYV_SWITCH_API_INNOR)).toUpperCase();
        return PolyvApiManager.getPolyvLiveStatusApi().getChatFunctionSwitch(l, string2, string).compose((ObservableTransformer)new PLVRxBaseTransformer());
    }

    public Observable<PolyvLiveClassDetailVO> requestLiveClassDetailApi(String string, String string2, String string3) {
        String string4 = System.currentTimeMillis() + "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(CHANNEL_ID, string);
        hashMap.put(TIMESTAMP, string4);
        hashMap.put(APP_ID, string2);
        String string5 = PLVSignCreator.createSign((String)string3, hashMap);
        return PolyvApiManager.getPolyvLiveStatusApi().getLiveClassDetail(string, string4, string5, string2).compose((ObservableTransformer)new PLVRxBaseTransformer());
    }

    public Observable<PolyvPlaybackListVO> getPlaybackList(String string, int n, int n2, int n3) {
        long l = System.currentTimeMillis();
        String string2 = PolyvLiveSDKClient.getInstance().getAppId();
        String string3 = PolyvLiveSDKClient.getInstance().getAppSecret();
        String string4 = n3 == 1 ? VOD : PLAYBACK;
        ArrayMap arrayMap = new ArrayMap();
        arrayMap.put(APP_ID, string2);
        arrayMap.put(TIMESTAMP, String.valueOf(l));
        arrayMap.put(PAGE, String.valueOf(n));
        arrayMap.put(PAGE_SIZE, String.valueOf(n2));
        arrayMap.put(LIST_TYPE, string4);
        String string5 = PLVSignCreator.createSign((String)string3, (Map)arrayMap);
        return PolyvApiManager.getPolyvLiveStatusApi().getPlaybackList(string, string2, l, n, n2, string4, string5).compose((ObservableTransformer)new PLVRxBaseTransformer());
    }

    public String generateUser(String string, String string2, String string3, String string4, PLVAuthorizationBean pLVAuthorizationBean, String string5) throws JSONException {
        String string6 = PLVCheckUtils.checkParams((String[])new String[]{string, VIEWER_ID, string2, CHANNEL_ID, string3, VIEWER_NAME, string4, IMAGE_URL, string5, USER_TYPE});
        if (string6 != null) {
            throw new IllegalArgumentException(string6 + "is empty");
        }
        if (!Patterns.WEB_URL.matcher(string4).matches()) {
            throw new IllegalArgumentException("imageUrl is not webUrl");
        }
        if (pLVAuthorizationBean != null && TextUtils.isEmpty((CharSequence)pLVAuthorizationBean.getActor())) {
            throw new IllegalArgumentException("authorization is empty");
        }
        JSONObject jSONObject = new JSONObject();
        if (pLVAuthorizationBean != null) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put(ACTOR, (Object)pLVAuthorizationBean.getActor());
            jSONObject2.put(BG_COLOR, (Object)pLVAuthorizationBean.getBgColor());
            jSONObject2.put(F_COLOR, (Object)pLVAuthorizationBean.getfColor());
            jSONObject.put(AUTHORIZATION, (Object)jSONObject2);
        }
        jSONObject.put(CHANNEL_ID, (Object)string2);
        jSONObject.put(NICK, (Object)string3);
        jSONObject.put(PIC, (Object)string4);
        jSONObject.put(ROOM_ID, (Object)string2);
        jSONObject.put(USER_ID, (Object)string);
        jSONObject.put(USER_TYPE, (Object)string5);
        return jSONObject.toString();
    }

    public Observable<ResponseBody> getChatPlaybackMessage(String string, int n, int n2, int n3, String string2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(VID, string);
        hashMap.put(LIMIT, Math.max(0, n));
        hashMap.put(TIME, PLVTimeUtils.generateTime((long)(n2 * 1000), (boolean)true));
        if (bl) {
            hashMap.put(ID, n3);
        }
        hashMap.put(ORIGIN, string2);
        return PolyvApiManager.getPolyvLiveStatusApi().getDanmaku(hashMap).compose((ObservableTransformer)new PLVRxBaseTransformer());
    }

    public Observable<ResponseBody> sendChatPlaybackMessage(String string, String string2, int n, String string3, String string4, String string5, String string6) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(VID, string);
        hashMap.put(MSG, string2);
        hashMap.put(TIME, PLVTimeUtils.generateTime((long)(n * 1000), (boolean)true));
        hashMap.put(ORIGIN, string3);
        hashMap.put(MSG_TYPE, string4);
        hashMap.put(USER, string5);
        if (!TextUtils.isEmpty((CharSequence)string6)) {
            hashMap.put(SESSION_ID, string6);
        }
        return PolyvApiManager.getPolyvLiveStatusApi().sendDanmaku(hashMap).compose((ObservableTransformer)new PLVRxBaseTransformer());
    }
}

