package com.easefun.polyv.livescenes.video.api;

import com.easefun.polyv.businesssdk.api.common.player.listener.IPolyvVideoViewListenerBinder;

/**
 * 公开给用户的api
 *
 * @author df
 * @create 2018/7/30
 * @Describe
 */
public interface IPolyvLiveVideoViewListenerBinder extends IPolyvVideoViewListenerBinder {
    /**
     * 设置即将播放暖场视频/图片监听器
     *
     * @param l
     */
    void setOnWillPlayWaittingListener(IPolyvLiveListenerEvent.OnWillPlayWaittingListener l);

    /**
     * 设置当前暂无直播的监听器
     *
     * @param l
     */
    void setOnNoLiveAtPresentListener(IPolyvLiveListenerEvent.OnNoLiveAtPresentListener l);


    /**
     * 设置获取直播后台设置的跑马灯样式的监听器
     *
     * @param l
     */
    void setMicroPhoneListener(IPolyvLiveListenerEvent.MicroPhoneListener l);


    /**
     * 设置摄像头回掉
     *
     * @param l
     */
    void setOnCameraShowListener(IPolyvLiveListenerEvent.OnCameraShowListener l);

    /**
     * 线路切换回掉
     */
    void setOnLinesChangedListener(IPolyvLiveListenerEvent.OnLinesChangedListener l);

    /**
     * 设置是否支持RTC的回调
     */
    void setOnSupportRTCListener(IPolyvLiveListenerEvent.OnSupportRTCListener l);

    /**
     * 设置RTC播放事件回调
     */
    void setOnRTCPlayEventListener(IPolyvLiveListenerEvent.OnRTCPlayEventListener l);

    /**
     * 设置拦截播放监听
     */
    void setOnCheckCanPlayListener(IPolyvLiveListenerEvent.OnCheckCanPlayListener l);
}
