package com.easefun.polyv.livescenes.chatroom.send.custom;

import com.easefun.polyv.livescenes.chatroom.PolyvBaseHolder;

/**
 * 自定义事件
 */
public class PolyvBaseCustomEvent<DataBean> extends PolyvBaseHolder {
    public static final String TIP_DEFAULT = "发送了自定义消息";
    public static final int EMITMODE_ALL = 0;
    public static final int EMITMODE_OTHERS = 1;
    public static final int EMITMODE_OWN = 2;
    /**
     * 事件名
     */
    protected String EVENT;
    /**
     * 提示文案，默认为"发送了自定义消息"
     */
    protected String tip;
    /**
     * 发送模式
     */
    protected int emitMode;
    /**
     * 自定义数据
     */
    protected DataBean data;
    /**
     * 消息id
     */
    protected String id;

    public PolyvBaseCustomEvent(String EVENT, DataBean data) {
        this(EVENT, EMITMODE_ALL, data);
    }

    public PolyvBaseCustomEvent(String EVENT, String tip, DataBean data) {
        this(EVENT, EMITMODE_ALL, tip, data);
    }

    public PolyvBaseCustomEvent(String EVENT, int emitMode, DataBean data) {
        this(EVENT, emitMode, TIP_DEFAULT, data);
    }

    public PolyvBaseCustomEvent(String EVENT, int emitMode, String tip, DataBean data) {
        this.EVENT = EVENT;
        this.emitMode = emitMode;
        this.tip = tip;
        this.data = data;
    }

    public String getEVENT() {
        return EVENT;
    }

    public void setEVENT(String EVENT) {
        this.EVENT = EVENT;
    }

    public int getEmitMode() {
        return emitMode;
    }

    public void setEmitMode(int emitMode) {
        this.emitMode = emitMode;
    }

    public String getTip() {
        return tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public DataBean getData() {
        return data;
    }

    public void setData(DataBean data) {
        this.data = data;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return "PolyvBaseCustomEvent{" +
                "EVENT='" + EVENT + '\'' +
                ", tip='" + tip + '\'' +
                ", emitMode=" + emitMode +
                ", id="+id +
                ", data=" + data +
                '}';
    }
}
