package net.peanuuutz.fork.util.minecraft

import net.fabricmc.fabric.api.event.Event
import net.fabricmc.fabric.api.event.EventFactory
import net.minecraft.util.Identifier

public inline fun <reified T> Event(
    noinline invokerFactory: (Array<T>) -> T
): Event<T> {
    return EventFactory.createArrayBacked(T::class.java, invokerFactory)
}

public inline fun <reified T> Event(
    emptyInvoker: T,
    noinline invokerFactory: (Array<T>) -> T
): Event<T> {
    return EventFactory.createArrayBacked(T::class.java, emptyInvoker, invokerFactory)
}

public inline fun <reified T> Event(
    vararg phases: Identifier,
    noinline invokerFactory: (Array<T>) -> T
): Event<T> {
    return EventFactory.createWithPhases(T::class.java, invokerFactory, *phases)
}
