package net.peanuuutz.fork.util.minecraft

import org.objectweb.asm.tree.ClassNode
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin
import org.spongepowered.asm.mixin.extensibility.IMixinInfo

public abstract class BaseMixinPlugin : IMixinConfigPlugin {
    override fun onLoad(mixinPackage: String) {}

    override fun getRefMapperConfig(): String? {
        return null
    }

    override fun shouldApplyMixin(
        targetClassName: String,
        mixinClassName: String
    ): Boolean {
        return true
    }

    override fun acceptTargets(
        myTargets: MutableSet<String>,
        otherTargets: MutableSet<String>
    ) {}

    override fun getMixins(): List<String>? {
        return null
    }

    override fun preApply(
        targetClassName: String,
        targetClass: ClassNode,
        mixinClassName: String,
        mixinInfo: IMixinInfo
    ) {}

    override fun postApply(
        targetClassName: String,
        targetClass: ClassNode,
        mixinClassName: String,
        mixinInfo: IMixinInfo
    ) {}
}
