package net.peanuuutz.fork.util.common

public fun pack2Floats(first: Float, second: Float): Long {
    return (first.toBits().toLong() shl 32) or (second.toBits().toLong() and 0xFFFFFFFFL)
}

public fun unpackFloat1(packedLong: Long): Float {
    return Float.fromBits((packedLong shr 32).toInt())
}

public fun unpackFloat2(packedLong: Long): Float {
    return Float.fromBits((packedLong and 0xFFFFFFFFL).toInt())
}

public fun pack2Ints(first: Int, second: Int): Long {
    return (first.toLong() shl 32) or (second.toLong() and 0xFFFFFFFFL)
}

public fun unpackInt1(packedLong: Long): Int {
    return (packedLong shr 32).toInt()
}

public fun unpackInt2(packedLong: Long): Int {
    return (packedLong and 0xFFFFFFFFL).toInt()
}

public fun pack4Shorts(first: Int, second: Int, third: Int, forth: Int): Long {
    return (first.toLong() and 0xFFFFL shl 48) or
            (second.toLong() and 0xFFFFL shl 32) or
            (third.toLong() and 0xFFFFL shl 16) or
            (forth.toLong() and 0xFFFFL)
}

public fun unpackShort1(packedLong: Long): Int {
    return (packedLong shr 48).toInt()
}

public fun unpackShort2(packedLong: Long): Int {
    return (packedLong shr 32 and 0xFFFFL).toInt()
}

public fun unpackShort3(packedLong: Long): Int {
    return (packedLong shr 16 and 0xFFFFL).toInt()
}

public fun unpackShort4(packedLong: Long): Int {
    return (packedLong and 0xFFFFL).toInt()
}

public fun packColor(red: Int, green: Int, blue: Int, alpha: Int = 0xFF): Long {
    return ((alpha and 0xFF shl 24) or
            (red and 0xFF shl 16) or
            (green and 0xFF shl 8) or
            (blue and 0xFF)).toLong()
}

public fun packColor(red: Float, green: Float, blue: Float, alpha: Float = 1.0f): Long {
    val byteRed = (red * 255).toInt().coerceIn(0, 255)
    val byteGreen = (green * 255).toInt().coerceIn(0, 255)
    val byteBlue = (blue * 255).toInt().coerceIn(0, 255)
    val byteAlpha = (alpha * 255).toInt().coerceIn(0, 255)
    return packColor(byteRed, byteGreen, byteBlue, byteAlpha)
}

public fun packColor(rgb: Int, alpha: Int = 0xFF): Long {
    return ((alpha and 0xFF shl 24) or rgb).toLong()
}

public fun unpackAlpha(packedLong: Long): Int {
    return packedLong.toInt() shr 24 and 0xFF
}

public fun unpackRed(packedLong: Long): Int {
    return packedLong.toInt() shr 16 and 0xFF
}

public fun unpackGreen(packedLong: Long): Int {
    return packedLong.toInt() shr 8 and 0xFF
}

public fun unpackBlue(packedLong: Long): Int {
    return packedLong.toInt() and 0xFF
}
