/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.util.Serializer;

public class JavaSerializer
implements Serializer {
    @Override
    public String name() {
        return "java";
    }

    @Override
    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(obj);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    @Override
    public Object deserialize(byte[] bits) throws IOException {
        Object object;
        if (bits == null || bits.length == 0) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bits);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new CacheException(e);
            }
        }
        ois.close();
        return object;
    }
}

