/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.redis;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import net.oschina.j2cache.CacheProviderHolder;
import net.oschina.j2cache.Command;
import net.oschina.j2cache.cluster.ClusterPolicy;
import net.oschina.j2cache.redis.RedisUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.util.Pool;

public class RedisPubSubClusterPolicy
extends JedisPubSub
implements ClusterPolicy {
    private static final Logger log = LoggerFactory.getLogger(RedisPubSubClusterPolicy.class);
    private int LOCAL_COMMAND_ID = Command.genRandomSrc();
    private static int CONNECT_TIMEOUT = 5000;
    private static int SO_TIMEOUT = 5000;
    private static int MAX_ATTEMPTS = 3;
    private Pool<Jedis> client;
    private JedisCluster cluster;
    private String channel;
    private CacheProviderHolder holder;
    private boolean clusterMode = false;

    public RedisPubSubClusterPolicy(String channel, Properties props) {
        String mode;
        this.channel = channel;
        int timeout = Integer.parseInt((String)props.getOrDefault((Object)"timeout", "2000"));
        String password = props.getProperty("password");
        if (password != null && password.trim().length() == 0) {
            password = null;
        }
        int database = Integer.parseInt(props.getProperty("database", "0"));
        boolean ssl = Boolean.valueOf(props.getProperty("ssl", "false"));
        JedisPoolConfig config = RedisUtils.newPoolConfig(props, null);
        String node = props.getProperty("channel.host");
        if (node == null || node.trim().length() == 0) {
            node = props.getProperty("hosts");
        }
        if ("sentinel".equalsIgnoreCase(mode = props.getProperty("mode"))) {
            HashSet<String> hosts = new HashSet<String>();
            hosts.addAll(Arrays.asList(node.split(",")));
            String masterName = props.getProperty("cluster_name", "j2cache");
            this.client = new JedisSentinelPool(masterName, hosts, (GenericObjectPoolConfig)config, timeout, password, database);
        } else if ("cluster".equalsIgnoreCase(mode)) {
            String[] nodeArray = node.split(",");
            HashSet<HostAndPort> nodeSet = new HashSet<HostAndPort>(nodeArray.length);
            for (String nodeItem : nodeArray) {
                String[] arr = nodeItem.split(":");
                nodeSet.add(new HostAndPort(arr[0], Integer.valueOf(arr[1]).intValue()));
            }
            JedisPoolConfig poolConfig = RedisUtils.newPoolConfig(props, null);
            this.cluster = new JedisCluster(nodeSet, CONNECT_TIMEOUT, SO_TIMEOUT, MAX_ATTEMPTS, password, (GenericObjectPoolConfig)poolConfig);
            this.clusterMode = true;
        } else {
            node = node.split(",")[0];
            String[] infos = node.split(":");
            String host = infos[0];
            int port = infos.length > 1 ? Integer.parseInt(infos[1]) : 6379;
            this.client = new JedisPool((GenericObjectPoolConfig)config, host, port, timeout, password, database, ssl);
        }
    }

    @Override
    public boolean isLocalCommand(Command cmd) {
        return cmd.getSrc() == this.LOCAL_COMMAND_ID;
    }

    @Override
    public void evict(String region, String ... keys) {
        this.holder.getLevel1Cache(region).evict(keys);
    }

    @Override
    public void clear(String region) {
        this.holder.getLevel1Cache(region).clear();
    }

    @Override
    public void connect(Properties props, CacheProviderHolder holder) {
        long ct = System.currentTimeMillis();
        this.holder = holder;
        this.publish(Command.join());
        Thread subscribeThread = new Thread(() -> {
            if (this.clusterMode) {
                while (this.cluster != null) {
                    try {
                        this.cluster.subscribe((JedisPubSub)this, new String[]{this.channel});
                    }
                    catch (Exception e) {
                        log.error("failed connect redis cluster, reconnect it.", (Throwable)e);
                        e.printStackTrace();
                        if (this.cluster == null) continue;
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {}
                    }
                    break;
                }
            } else {
                while (!this.client.isClosed()) {
                    try (Jedis jedis = (Jedis)this.client.getResource();){
                        jedis.subscribe((JedisPubSub)this, new String[]{this.channel});
                        log.info("Disconnect to redis channel: {}", (Object)this.channel);
                    }
                    catch (JedisConnectionException e) {
                        log.error("Failed connect to redis, reconnect it.", (Throwable)e);
                        if (this.client.isClosed()) continue;
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {}
                    }
                    break;
                }
            }
        }, "RedisSubscribeThread");
        subscribeThread.setDaemon(true);
        subscribeThread.start();
        log.info("Connected to redis channel:{}, time {} ms.", (Object)this.channel, (Object)(System.currentTimeMillis() - ct));
    }

    @Override
    public void disconnect() {
        try {
            this.publish(Command.quit());
            if (this.isSubscribed()) {
                this.unsubscribe();
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void publish(Command cmd) {
        cmd.setSrc(this.LOCAL_COMMAND_ID);
        if (this.clusterMode) {
            this.cluster.publish(this.channel, cmd.json());
        } else {
            try (Jedis jedis = (Jedis)this.client.getResource();){
                jedis.publish(this.channel, cmd.json());
            }
        }
    }

    public void onMessage(String channel, String message) {
        Command cmd = Command.parse(message);
        this.handleCommand(cmd);
    }

    public void unsubscribe() {
        if (!this.clusterMode) {
            super.unsubscribe();
        }
    }

    private void close() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.cluster != null) {
                this.cluster.close();
            }
            this.cluster = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

